/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class VampireBookScreen
extends Screen {
    private static final ResourceLocation pageTexture = new ResourceLocation("vampirism", "textures/gui/vampire_book.png");
    private final int xSize = 245;
    private final int ySize = 192;
    private int guiLeft;
    private int guiTop;
    private PageButton buttonNext;
    private PageButton buttonPrev;
    private int pageNumber;
    private final  @NotNull VampireBookManager.BookInfo info;
    private List<FormattedText> content;

    public VampireBookScreen( @NotNull VampireBookManager.BookInfo info) {
        super((Component)Component.m_237113_((String)info.title()));
        this.info = info;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.m_280218_(pageTexture, this.guiLeft, this.guiTop, 0, 0, 245, 192);
        this.pageNumber = Mth.m_14045_((int)this.pageNumber, (int)0, (int)(this.content.size() - 1));
        if (this.pageNumber < this.content.size()) {
            FormattedText toDraw = this.content.get(this.pageNumber);
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            List cutLines = fontRenderer.m_92923_(toDraw, 170);
            int y = this.guiTop + 12 + 5;
            for (FormattedCharSequence cut : cutLines) {
                graphics.m_280649_(fontRenderer, cut, this.guiLeft + 44, y, 0, false);
                y += 10;
            }
        }
        VampireBookScreen.drawCenteredStringWithoutShadow(graphics, this.f_96547_, String.format("%d/%d", this.pageNumber + 1, this.content.size()), this.guiLeft + 122, this.guiTop + 160, 0);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.guiLeft + 122, this.guiTop - 10, Color.WHITE.getRGB());
        this.buttonPrev.f_93624_ = this.pageNumber != 0;
        this.buttonNext.f_93624_ = this.pageNumber != this.content.size() - 1 && !this.content.isEmpty();
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
        this.buttonNext = new PageButton(this.guiLeft + 163, this.guiTop + 160, true, btn -> {
            if (this.pageNumber + 1 < this.content.size()) {
                this.nextPage();
            }
        }, true);
        this.m_142416_((GuiEventListener)this.buttonNext);
        this.buttonPrev = new PageButton(this.guiLeft + 49, this.guiTop + 160, false, btn -> {
            if (this.pageNumber > 0) {
                this.prevPage();
            }
        }, true);
        this.m_142416_((GuiEventListener)this.buttonPrev);
        this.content = Arrays.stream(this.info.content()).map(Component::m_237113_).flatMap(v -> VampireBookScreen.prepareForLongText((Component)v, 164, 120, 120).stream()).collect(Collectors.toList());
    }

    public static void drawCenteredStringWithoutShadow(@NotNull GuiGraphics graphics, @NotNull Font p_238471_1_, @NotNull String p_238471_2_, int p_238471_3_, int p_238471_4_, int p_238471_5_) {
        graphics.m_280056_(p_238471_1_, p_238471_2_, p_238471_3_ - p_238471_1_.m_92895_(p_238471_2_) / 2, p_238471_4_, p_238471_5_, false);
    }

    public boolean m_7933_(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (keyCode == 259 || keyCode == this.f_96541_.f_91066_.f_92095_.getKey().m_84873_()) {
            this.f_96541_.m_91152_(null);
            return true;
        }
        if ((keyCode == 265 || keyCode == 262) && this.pageNumber + 1 < this.content.size()) {
            this.nextPage();
            return true;
        }
        if ((keyCode == 264 || keyCode == 263) && this.pageNumber > 0) {
            this.prevPage();
            return true;
        }
        return super.m_7933_(keyCode, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean m_6050_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double movement) {
        if (movement < 0.0) {
            this.nextPage();
        } else if (movement > 0.0) {
            this.prevPage();
        }
        return movement != 0.0 || super.m_6050_(p_mouseScrolled_1_, p_mouseScrolled_3_, movement);
    }

    public void nextPage() {
        if (this.pageNumber != this.content.size() - 1 && !this.content.isEmpty()) {
            ++this.pageNumber;
        }
    }

    public void prevPage() {
        if (this.pageNumber != 0) {
            --this.pageNumber;
        }
    }

    @NotNull
    private static List<FormattedText> prepareForLongText(@NotNull Component text, int lineWidth, int firstHeight, int subsequentHeight) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        Objects.requireNonNull(fontRenderer);
        int firstCount = firstHeight / 9;
        Objects.requireNonNull(fontRenderer);
        int count = subsequentHeight / 9;
        ArrayList<FormattedText> lines = new ArrayList<FormattedText>(fontRenderer.m_92865_().m_92414_((FormattedText)text, lineWidth, Style.f_131099_));
        ArrayList<FormattedText> pages = new ArrayList<FormattedText>();
        ArrayList<FormattedText> pageLines = lines.size() > firstCount ? lines.subList(0, firstCount) : lines;
        pages.add(VampireBookScreen.combineWithNewLine(pageLines));
        pageLines.clear();
        while (lines.size() > 0) {
            pageLines = lines.size() > count ? lines.subList(0, count) : lines;
            pages.add(VampireBookScreen.combineWithNewLine(pageLines));
            pageLines.clear();
        }
        return pages;
    }

    @NotNull
    private static FormattedText combineWithNewLine(@NotNull List<FormattedText> elements) {
        MutableComponent newLine = Component.m_237113_((String)"\n");
        ArrayList<Object> copy = new ArrayList<Object>(elements.size() * 2);
        for (int i = 0; i < elements.size() - 1; ++i) {
            copy.add(elements.get(i));
            copy.add(newLine);
        }
        copy.add(elements.get(elements.size() - 1));
        return FormattedText.m_130768_(copy);
    }
}

