/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import com.google.common.collect.ImmutableMap;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.blockentity.CoffinBlockEntity;
import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoffinBlock
extends VampirismBlockContainer {
    public static final Map<DyeColor, CoffinBlock> COFFIN_BLOCKS = new HashMap<DyeColor, CoffinBlock>();
    public static final String name = "coffin";
    public static final EnumProperty<CoffinPart> PART = EnumProperty.m_61587_((String)"part", CoffinPart.class);
    public static final BooleanProperty CLOSED = BooleanProperty.m_61465_((String)"closed");
    public static final BooleanProperty VERTICAL = BooleanProperty.m_61465_((String)"vertical");
    private static final ShapeTable shapes = new ShapeTable();
    private static final Map<Player.BedSleepingProblem, Component> sleepResults = ImmutableMap.of((Object)Player.BedSleepingProblem.NOT_POSSIBLE_NOW, (Object)Component.m_237115_((String)"text.vampirism.coffin.no_sleep"), (Object)Player.BedSleepingProblem.TOO_FAR_AWAY, (Object)Component.m_237115_((String)"text.vampirism.coffin.too_far_away"), (Object)Player.BedSleepingProblem.OBSTRUCTED, (Object)Component.m_237115_((String)"text.vampirism.coffin.obstructed"));
    private final DyeColor color;

    public static boolean isOccupied(@NotNull BlockGetter world, @NotNull BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() instanceof CoffinBlock && (Boolean)state.m_61143_((Property)BedBlock.f_49441_) != false;
    }

    public static boolean isClosed(@NotNull BlockGetter world, @NotNull BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() instanceof CoffinBlock && (Boolean)state.m_61143_((Property)CLOSED) != false;
    }

    public static boolean isHead(@NotNull BlockGetter world, @NotNull BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_() instanceof CoffinBlock && state.m_61143_(PART) == CoffinPart.HEAD;
    }

    private static Direction getDirectionToOther(CoffinPart type, @NotNull Direction facing) {
        return type == CoffinPart.FOOT ? facing : facing.m_122424_();
    }

    public CoffinBlock(DyeColor color) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60978_(0.2f).m_60955_().m_278166_(PushReaction.DESTROY).m_278183_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BedBlock.f_49441_, (Comparable)Boolean.FALSE)).m_61124_(PART, (Comparable)((Object)CoffinPart.FOOT))).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)VERTICAL, (Comparable)Boolean.valueOf(false)));
        this.color = color;
        COFFIN_BLOCKS.put(color, this);
    }

    @NotNull
    public Direction getBedDirection(@NotNull BlockState state, LevelReader world, BlockPos pos) {
        return (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        Direction enumfacing = context.m_8125_();
        boolean vertical = context.m_43719_().m_122434_() != Direction.Axis.Y;
        BlockPos blockpos = context.m_8083_();
        BlockPos blockpos1 = blockpos.m_121945_(vertical ? Direction.UP : enumfacing);
        return context.m_43725_().m_8055_(blockpos1).m_60629_(context) ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)enumfacing)).m_61124_((Property)VERTICAL, (Comparable)Boolean.valueOf(vertical)) : null;
    }

    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull PathComputationType type) {
        return false;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return shapes.getShape((CoffinPart)((Object)state.m_61143_(PART)), (Boolean)state.m_61143_((Property)CLOSED), (Boolean)state.m_61143_((Property)VERTICAL), (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_));
    }

    public boolean isBed(@NotNull BlockState state, BlockGetter world, BlockPos pos, Entity player) {
        return (Boolean)state.m_61143_((Property)CLOSED) == false || (Boolean)state.m_61143_((Property)BedBlock.f_49441_) != false;
    }

    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new CoffinBlockEntity(pos, state, this.color);
    }

    public void m_5707_(@NotNull Level worldIn, BlockPos pos, BlockState state, @NotNull Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        CoffinPart part;
        if (!worldIn.f_46443_ && player.m_7500_() && (part = (CoffinPart)((Object)state.m_61143_(PART))) == CoffinPart.FOOT && (blockstate = worldIn.m_8055_(blockpos = this.getOtherPos(pos, state))).m_60734_() == this && blockstate.m_61143_(PART) == CoffinPart.HEAD) {
            worldIn.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            worldIn.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    public void m_6402_(@NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity entity, @NotNull ItemStack itemStack) {
        super.m_6402_(worldIn, pos, state, entity, itemStack);
        if (!worldIn.f_46443_) {
            BlockPos blockpos = this.getOtherPos(pos, state);
            worldIn.m_7731_(blockpos, (BlockState)state.m_61124_(PART, (Comparable)((Object)CoffinPart.HEAD)), 3);
            worldIn.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)worldIn, pos, 3);
        }
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (facing == CoffinBlock.getDirectionToOther((CoffinPart)((Object)stateIn.m_61143_(PART)), (Boolean)stateIn.m_61143_((Property)VERTICAL) != false ? Direction.UP : (Direction)stateIn.m_61143_((Property)BlockStateProperties.f_61374_))) {
            return facingState.m_60734_() == this && facingState.m_61143_(PART) != stateIn.m_61143_(PART) ? (BlockState)stateIn.m_61124_((Property)BedBlock.f_49441_, (Comparable)((Boolean)facingState.m_61143_((Property)BedBlock.f_49441_))) : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (state.m_61143_(PART) != CoffinPart.HEAD && !(state = worldIn.m_8055_(pos = this.getOtherPos(pos, state))).m_60713_((Block)this)) {
            return InteractionResult.CONSUME;
        }
        player.m_36220_(ModStats.interact_with_coffin);
        if (player.m_6144_() && !((Boolean)state.m_61143_((Property)BedBlock.f_49441_)).booleanValue()) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)CLOSED) == false)), 3);
            BlockPos otherPos = this.getOtherPos(pos, state);
            worldIn.m_7731_(otherPos, (BlockState)worldIn.m_8055_(otherPos).m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)CLOSED) == false)), 3);
            return InteractionResult.CONSUME;
        }
        if (VampirismPlayerAttributes.get((Player)player).vampireLevel == 0) {
            player.m_5661_((Component)Component.m_237115_((String)"text.vampirism.coffin.cant_use"), true);
            return InteractionResult.CONSUME;
        }
        if (((Boolean)state.m_61143_((Property)BedBlock.f_49441_)).booleanValue()) {
            player.m_5661_((Component)Component.m_237115_((String)"text.vampirism.coffin.occupied"), true);
            return InteractionResult.CONSUME;
        }
        if (((Boolean)state.m_61143_((Property)CLOSED)).booleanValue()) {
            player.m_5661_((Component)Component.m_237115_((String)"text.vampirism.coffin.closed"), true);
            return InteractionResult.CONSUME;
        }
        if (!BedBlock.m_49488_((Level)worldIn)) {
            worldIn.m_7471_(pos, false);
            BlockPos blockpos = pos.m_121945_((Boolean)state.m_61143_((Property)VERTICAL) != false ? Direction.DOWN : ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_());
            if (worldIn.m_8055_(blockpos).m_60713_((Block)this)) {
                worldIn.m_7471_(blockpos, false);
            }
            Vec3 vec3 = pos.m_252807_();
            worldIn.m_254951_(null, worldIn.m_269111_().m_269488_(vec3), null, vec3, 5.0f, true, Level.ExplosionInteraction.BLOCK);
            return InteractionResult.CONSUME;
        }
        if (((Boolean)state.m_61143_((Property)BedBlock.f_49441_)).booleanValue()) {
            player.m_5661_((Component)Component.m_237115_((String)"text.vampirism.coffin.occupied"), true);
            return InteractionResult.CONSUME;
        }
        BlockPos finalPos = pos;
        BlockState finalState = state;
        player.m_7720_((Boolean)state.m_61143_((Property)VERTICAL) != false ? pos.m_7495_() : pos).ifLeft(sleepResult1 -> {
            if (sleepResult1 != null) {
                player.m_5661_(sleepResults.getOrDefault(sleepResult1, sleepResult1.m_36423_()), true);
            }
        }).ifRight(u -> CoffinBlock.setCoffinSleepPosition(player, finalPos, finalState));
        return InteractionResult.CONSUME;
    }

    public static void setCoffinSleepPosition(@NotNull Player player, @NotNull BlockPos blockPos, @NotNull BlockState state) {
        if (((Boolean)state.m_61143_((Property)VERTICAL)).booleanValue()) {
            double z;
            double x;
            player.m_20124_(Pose.STANDING);
            switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)) {
                case NORTH: {
                    x = 0.5;
                    z = 0.3;
                    player.f_20885_ = 0.0f;
                    player.f_20883_ = 0.0f;
                    break;
                }
                case EAST: {
                    x = 0.7;
                    z = 0.5;
                    player.f_20885_ = 90.0f;
                    player.f_20883_ = 90.0f;
                    break;
                }
                case SOUTH: {
                    x = 0.5;
                    z = 0.7;
                    player.f_20885_ = 180.0f;
                    player.f_20883_ = 180.0f;
                    break;
                }
                case WEST: {
                    x = 0.3;
                    z = 0.5;
                    player.f_20885_ = 270.0f;
                    player.f_20883_ = 270.0f;
                    break;
                }
                default: {
                    return;
                }
            }
            player.m_6034_((double)blockPos.m_123341_() + x, (double)blockPos.m_123342_() - 0.05, (double)blockPos.m_123343_() + z);
            player.m_20011_(new AABB((double)blockPos.m_123341_() + x - 0.2, (double)blockPos.m_123342_() + 0.15, (double)blockPos.m_123343_() + z - 0.2, (double)blockPos.m_123341_() + x + 0.2, (double)blockPos.m_123342_() + 1.3, (double)blockPos.m_123343_() + z + 0.2));
        } else {
            player.m_6034_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.2, (double)blockPos.m_123343_() + 0.5);
            player.m_20011_(player.f_19815_.m_20384_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.2, (double)blockPos.m_123343_() + 0.5).m_82406_(0.3));
        }
    }

    public Optional<Vec3> getRespawnPosition(BlockState state, EntityType<?> type, LevelReader levelReader, BlockPos pos, float orientation, @Nullable LivingEntity entity) {
        if (((Boolean)state.m_61143_((Property)VERTICAL)).booleanValue()) {
            if (state.m_61143_(PART) == CoffinPart.HEAD) {
                pos = pos.m_7495_();
            }
            pos = pos.m_121945_(((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_());
            return Optional.of(pos.m_252807_());
        }
        return Optional.of(pos.m_252807_());
    }

    @NotNull
    public BlockPos getOtherPos(@NotNull BlockPos pos, @NotNull BlockState state) {
        if (((Boolean)state.m_61143_((Property)VERTICAL)).booleanValue()) {
            if (state.m_61143_(PART) == CoffinPart.FOOT) {
                return pos.m_7494_();
            }
            return pos.m_7495_();
        }
        if (state.m_61143_(PART) == CoffinPart.FOOT) {
            return pos.m_121945_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_));
        }
        return pos.m_121945_(((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_());
    }

    public void setBedOccupied(BlockState state, @NotNull Level world, @NotNull BlockPos pos, LivingEntity sleeper, boolean occupied) {
        super.setBedOccupied(state, world, pos, sleeper, occupied);
        world.m_7731_(pos, (BlockState)world.m_8055_(pos).m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(occupied)), 3);
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_, BedBlock.f_49441_, PART, CLOSED, VERTICAL});
    }

    public DyeColor getColor() {
        return this.color;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntity) {
        return state.m_61143_(PART) == CoffinPart.HEAD ? CoffinBlock.m_152132_(blockEntity, (BlockEntityType)((BlockEntityType)ModTiles.COFFIN.get()), CoffinBlockEntity::clientTickHead) : null;
    }

    public static enum CoffinPart implements StringRepresentable
    {
        HEAD("head"),
        FOOT("foot");

        private final String name;

        private CoffinPart(String name) {
            this.name = name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class ShapeTable {
        private final VoxelShape[][][] @NotNull [] shapes = this.buildShapes();

        public VoxelShape getShape(@NotNull CoffinPart part, boolean closed, boolean vertical, @NotNull Direction facing) {
            return this.shapes[part.ordinal()][closed ? 1 : 0][vertical ? 1 : 0][facing.m_122416_()];
        }

        private VoxelShape[][][] @NotNull [] buildShapes() {
            VoxelShape shape = Shapes.m_83040_();
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)2.0), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.90625, (double)0.0625, (double)0.046875, (double)0.96875, (double)0.1875, (double)1.96875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.875, (double)0.1875, (double)1.375, (double)0.9375, (double)0.375, (double)1.875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.875, (double)0.1875, (double)0.75, (double)0.9375, (double)0.375, (double)1.25), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.875, (double)0.1875, (double)0.125, (double)0.9375, (double)0.375, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.1875, (double)1.875, (double)0.75, (double)0.375, (double)1.9375), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.1875, (double)0.125, (double)0.125, (double)0.375, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.1875, (double)0.75, (double)0.125, (double)0.375, (double)1.25), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.1875, (double)1.375, (double)0.125, (double)0.375, (double)1.875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.1875, (double)0.0625, (double)0.75, (double)0.375, (double)0.125), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.03125, (double)0.0625, (double)0.046875, (double)0.09375, (double)0.1875, (double)1.96875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.09375, (double)0.0625, (double)1.921875, (double)0.90625, (double)0.1875, (double)1.96875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.09375, (double)0.0625, (double)0.046875, (double)0.90625, (double)0.1875, (double)0.09375), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.90625, (double)0.1875, (double)1.875, (double)0.96875, (double)0.375, (double)1.96875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.90625, (double)0.1875, (double)1.25, (double)0.96875, (double)0.375, (double)1.375), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.90625, (double)0.1875, (double)0.625, (double)0.96875, (double)0.375, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.90625, (double)0.1875, (double)0.046875, (double)0.96875, (double)0.375, (double)0.125), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.03125, (double)0.1875, (double)0.046875, (double)0.09375, (double)0.375, (double)0.125), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.03125, (double)0.1875, (double)0.625, (double)0.09375, (double)0.375, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.03125, (double)0.1875, (double)1.25, (double)0.09375, (double)0.375, (double)1.375), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.03125, (double)0.1875, (double)1.875, (double)0.09375, (double)0.375, (double)1.96875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.09375, (double)0.1875, (double)1.921875, (double)0.25, (double)0.375, (double)1.96875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.1875, (double)1.921875, (double)0.90625, (double)0.375, (double)1.96875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.1875, (double)0.046875, (double)0.90625, (double)0.375, (double)0.09375), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.09375, (double)0.1875, (double)0.046875, (double)0.25, (double)0.375, (double)0.09375), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.09375, (double)0.375, (double)0.046875, (double)0.90625, (double)0.5, (double)0.09375), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.03125, (double)0.375, (double)0.046875, (double)0.09375, (double)0.5, (double)1.96875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.09375, (double)0.375, (double)1.921875, (double)0.90625, (double)0.5, (double)1.96875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.90625, (double)0.375, (double)0.046875, (double)0.96875, (double)0.5, (double)1.96875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.90625, (double)0.5, (double)0.0, (double)1.0, (double)0.5625, (double)2.0), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.5, (double)0.0, (double)0.09375, (double)0.5625, (double)2.0), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.09375, (double)0.5, (double)1.921875, (double)0.90625, (double)0.5625, (double)2.0), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.09375, (double)0.5, (double)0.0, (double)0.90625, (double)0.5625, (double)0.09375), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.09375, (double)0.0625, (double)0.09375, (double)0.140625, (double)0.546875, (double)1.921875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.859375, (double)0.0625, (double)0.09375, (double)0.90625, (double)0.546875, (double)1.921875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.140625, (double)0.0625, (double)1.859375, (double)0.859375, (double)0.546875, (double)1.921875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.140625, (double)0.0625, (double)0.09375, (double)0.859375, (double)0.546875, (double)0.15625), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.125, (double)0.1875, (double)0.8125, (double)0.3125, (double)0.5), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.203125, (double)0.203125, (double)0.4375, (double)0.796875, (double)0.34375, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.203125, (double)0.203125, (double)0.171875, (double)0.796875, (double)0.328125, (double)0.296875), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.9375, (double)0.09375, (double)0.25, (double)1.0, (double)0.15625, (double)0.5), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.9375, (double)0.09375, (double)0.875, (double)1.0, (double)0.15625, (double)1.125), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.9375, (double)0.09375, (double)1.5, (double)1.0, (double)0.15625, (double)1.75), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.09375, (double)1.5, (double)0.0625, (double)0.15625, (double)1.75), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.09375, (double)0.875, (double)0.0625, (double)0.15625, (double)1.125), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.09375, (double)0.25, (double)0.0625, (double)0.15625, (double)0.5), (BooleanOp)BooleanOp.f_82695_);
            VoxelShape lidShape = Shapes.m_83040_();
            lidShape = Shapes.m_83113_((VoxelShape)lidShape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.5625, (double)0.0, (double)0.09375, (double)0.625, (double)2.0), (BooleanOp)BooleanOp.f_82695_);
            lidShape = Shapes.m_83113_((VoxelShape)lidShape, (VoxelShape)Shapes.m_83048_((double)0.09375, (double)0.5625, (double)0.0, (double)0.90625, (double)0.625, (double)0.078125), (BooleanOp)BooleanOp.f_82695_);
            lidShape = Shapes.m_83113_((VoxelShape)lidShape, (VoxelShape)Shapes.m_83048_((double)0.90625, (double)0.5625, (double)0.0, (double)1.0, (double)0.625, (double)2.0), (BooleanOp)BooleanOp.f_82695_);
            lidShape = Shapes.m_83113_((VoxelShape)lidShape, (VoxelShape)Shapes.m_83048_((double)0.09375, (double)0.5625, (double)1.90625, (double)0.90625, (double)0.625, (double)2.0), (BooleanOp)BooleanOp.f_82695_);
            lidShape = Shapes.m_83113_((VoxelShape)lidShape, (VoxelShape)Shapes.m_83048_((double)0.09375, (double)0.625, (double)0.0625, (double)0.90625, (double)0.6875, (double)1.921875), (BooleanOp)BooleanOp.f_82695_);
            VoxelShape head = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82689_);
            VoxelShape foot = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)2.0), (BooleanOp)BooleanOp.f_82689_).m_83216_(0.0, 0.0, -1.0);
            VoxelShape lidHead = Shapes.m_83113_((VoxelShape)lidShape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82689_);
            VoxelShape lidFoot = Shapes.m_83113_((VoxelShape)lidShape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)2.0), (BooleanOp)BooleanOp.f_82689_).m_83216_(0.0, 0.0, -1.0);
            VoxelShape[][][][] shapes = new VoxelShape[2][][][];
            shapes[CoffinPart.HEAD.ordinal()] = this.buildShapePart(head, lidHead);
            shapes[CoffinPart.FOOT.ordinal()] = this.buildShapePart(foot, lidFoot);
            return shapes;
        }

        private VoxelShape[][] @NotNull [] buildShapePart(VoxelShape shape, @NotNull VoxelShape shapeLid) {
            VoxelShape[][][] shapes = new VoxelShape[][][]{this.buildShapeClosed(shape, shapeLid, false), this.buildShapeClosed(shape, shapeLid, true)};
            return shapes;
        }

        private VoxelShape[] @NotNull [] buildShapeClosed(VoxelShape shape, @NotNull VoxelShape shapeLid, boolean closed) {
            if (closed) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)shapeLid);
            }
            VoxelShape[][] shapes = new VoxelShape[][]{this.buildShapeVertical(shape, false), this.buildShapeVertical(shape, true)};
            return shapes;
        }

        private VoxelShape @NotNull [] buildShapeVertical(VoxelShape shape, boolean vertical) {
            if (vertical) {
                shape = UtilLib.rollShape(shape, Direction.NORTH);
            }
            VoxelShape[] shapes = new VoxelShape[4];
            VoxelShape finalShape = shape;
            Direction.Plane.HORIZONTAL.m_122557_().forEach(dir -> {
                shapes[dir.m_122416_()] = this.buildShapeDirectional(finalShape, (Direction)dir);
            });
            return shapes;
        }

        private VoxelShape buildShapeDirectional(@NotNull VoxelShape shape, @NotNull Direction direction) {
            return switch (direction) {
                case Direction.NORTH -> shape;
                case Direction.EAST -> UtilLib.rotateShape(shape, UtilLib.RotationAmount.NINETY);
                case Direction.SOUTH -> UtilLib.rotateShape(shape, UtilLib.RotationAmount.HUNDRED_EIGHTY);
                case Direction.WEST -> UtilLib.rotateShape(shape, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY);
                default -> throw new IllegalArgumentException("Wrong direction argument");
            };
        }
    }
}

