/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.items;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.items.oil.IApplicableOil;
import de.teamlapen.vampirism.api.items.oil.IOil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IFactionExclusiveItem
extends ItemLike {
    @Deprecated(since="1.9", forRemoval=true)
    default public void addFactionPoisonousToolTip(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, TooltipFlag flagIn, @Nullable Player player) {
        this.addFactionToolTips(stack, worldIn, tooltip, flagIn, player);
    }

    default public void addFactionToolTips(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, TooltipFlag flagIn, @Nullable Player player) {
        this.addOilDescTooltip(stack, worldIn, tooltip, flagIn, player);
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237115_((String)"text.vampirism.faction_specifics").m_130940_(ChatFormatting.GRAY));
        ChatFormatting color = ChatFormatting.GRAY;
        IFaction<?> faction = this.getExclusiveFaction(stack);
        if (faction != null) {
            if (player != null) {
                color = VampirismAPI.factionRegistry().getFaction((Entity)player) == faction ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_RED;
            }
            tooltip.add((Component)Component.m_237115_((String)" ").m_7220_(faction.getName()).m_7220_((Component)Component.m_237115_((String)"text.vampirism.faction_only")).m_130940_(color));
        }
    }

    default public void addOilDescTooltip(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, TooltipFlag flagIn, @Nullable Player player) {
        if (!stack.m_41782_()) {
            return;
        }
        CompoundTag tag = stack.m_41783_().m_128469_("applied_oil");
        if (tag.m_128441_("oil")) {
            IOil oil = (IOil)VampirismRegistries.OILS.get().getValue(new ResourceLocation(tag.m_128461_("oil")));
            int duration = tag.m_128451_("duration");
            if (oil instanceof IApplicableOil && duration > 0) {
                ((IApplicableOil)oil).getToolTipLine(stack, (IApplicableOil)oil, duration, flagIn).ifPresent(tooltip::add);
            }
        }
    }

    @Nullable
    public IFaction<?> getExclusiveFaction(@NotNull ItemStack var1);
}

