/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.libmc.Auxiliaries;
import wile.engineersdecor.libmc.Inventories;
import wile.engineersdecor.libmc.Overlay;
import wile.engineersdecor.libmc.RfEnergy;
import wile.engineersdecor.libmc.StandardBlocks;
import wile.engineersdecor.libmc.StandardEntityBlocks;

public class EdBreaker {
    public static final int BOOST_FACTOR = 8;
    public static final int DEFAULT_BOOST_ENERGY = 64;
    public static final int DEFAULT_BREAKING_RELUCTANCE = 17;
    public static final int DEFAULT_MIN_BREAKING_TIME = 15;
    public static final int MAX_BREAKING_TIME = 800;
    private static int boost_energy_consumption = 64;
    private static int energy_max = 32000;
    private static int breaking_reluctance = 17;
    private static int min_breaking_time = 15;
    private static boolean requires_power = false;

    public static void on_config(int boost_energy_per_tick, int breaking_time_per_hardness, int min_breaking_time_ticks, boolean power_required) {
        int interval = 5;
        boost_energy_consumption = 5 * Mth.m_14045_((int)boost_energy_per_tick, (int)4, (int)4096);
        energy_max = Math.max(boost_energy_consumption * 10, 100000);
        breaking_reluctance = Mth.m_14045_((int)breaking_time_per_hardness, (int)5, (int)50);
        min_breaking_time = Mth.m_14045_((int)min_breaking_time_ticks, (int)10, (int)100);
        requires_power = power_required;
        ModConfig.log("Config block breaker: Boost energy consumption:" + boost_energy_consumption / 5 + "rf/t, reluctance=" + breaking_reluctance + "t/hrdn, break time offset=" + min_breaking_time + "t.");
    }

    public static class BreakerTileEntity
    extends StandardEntityBlocks.StandardBlockEntity {
        public static final int IDLE_TICK_INTERVAL = 40;
        public static final int TICK_INTERVAL = 5;
        private int tick_timer_;
        private int active_timer_;
        private int proc_time_elapsed_;
        private int time_needed_;
        private final RfEnergy.Battery battery_ = new RfEnergy.Battery(energy_max, boost_energy_consumption, 0);
        private final LazyOptional<IEnergyStorage> energy_handler_ = this.battery_.createEnergyHandler();
        private static final HashSet<Block> blacklist = new HashSet();

        public BreakerTileEntity(BlockPos pos, BlockState state) {
            super(ModContent.getBlockEntityTypeOfBlock(state.m_60734_()), pos, state);
        }

        public void block_updated() {
            if (this.tick_timer_ > 2) {
                this.tick_timer_ = 2;
            }
        }

        public void readnbt(CompoundTag nbt) {
            this.battery_.load(nbt);
        }

        private void writenbt(CompoundTag nbt) {
            this.battery_.save(nbt);
        }

        public void state_message(Player player) {
            String progress = "0";
            if (this.proc_time_elapsed_ > 0 && this.time_needed_ > 0) {
                progress = Integer.toString((int)Mth.m_14008_((double)((double)this.proc_time_elapsed_ / (double)this.time_needed_ * 100.0), (double)0.0, (double)100.0));
            }
            Overlay.show(player, (Component)Auxiliaries.localizable("block.engineersdecor.small_block_breaker.status", this.battery_.getSOC(), energy_max, progress));
        }

        public void m_142466_(CompoundTag nbt) {
            super.m_142466_(nbt);
            this.readnbt(nbt);
        }

        protected void m_183515_(CompoundTag nbt) {
            super.m_183515_(nbt);
            this.writenbt(nbt);
        }

        public void m_7651_() {
            super.m_7651_();
            this.energy_handler_.invalidate();
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == ForgeCapabilities.ENERGY) {
                return this.energy_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        private static boolean isBreakable(BlockState state, BlockPos pos, Level world) {
            Block block = state.m_60734_();
            if (blacklist.contains(block)) {
                return false;
            }
            if (state.m_60795_()) {
                return false;
            }
            if (state.m_278721_()) {
                return false;
            }
            float bh = state.m_60800_((BlockGetter)world, pos);
            return !(bh < 0.0f) && !(bh > 55.0f);
        }

        private static void spawnBlockAsEntity(Level world, BlockPos pos, ItemStack stack) {
            if (world.f_46443_ || stack.m_41619_() || !world.m_46469_().m_46207_(GameRules.f_46136_) || world.restoringBlockSnapshots) {
                return;
            }
            ItemEntity e = new ItemEntity(world, (double)world.f_46441_.m_188501_() * 0.1 + 0.5 + (double)pos.m_123341_(), (double)world.f_46441_.m_188501_() * 0.1 + 0.5 + (double)pos.m_123342_(), (double)world.f_46441_.m_188501_() * 0.1 + 0.5 + (double)pos.m_123343_(), stack);
            e.m_32060_();
            e.m_20334_((double)world.f_46441_.m_188501_() * 0.1 - 0.05, (double)world.f_46441_.m_188501_() * 0.1 - 0.03, (double)world.f_46441_.m_188501_() * 0.1 - 0.05);
            world.m_7967_((Entity)e);
        }

        private static boolean canInsertInto(Level world, BlockPos pos) {
            BlockState state = world.m_8055_(pos);
            return state.m_60734_() == ModContent.getBlock("factory_hopper") || state.m_60734_() == Blocks.f_50332_;
        }

        private boolean breakBlock(BlockState state, BlockPos pos, Level world) {
            if (world.f_46443_ || !(world instanceof ServerLevel) || world.restoringBlockSnapshots) {
                return false;
            }
            Block block = state.m_60734_();
            boolean insert = BreakerTileEntity.canInsertInto(world, this.m_58899_().m_7495_());
            List drops = Block.m_49869_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.m_7702_(pos));
            world.m_7471_(pos, false);
            for (ItemStack drop : drops) {
                if (!insert) {
                    BreakerTileEntity.spawnBlockAsEntity(world, pos, drop);
                    continue;
                }
                ItemStack remaining = Inventories.insert(world, this.m_58899_().m_7495_(), Direction.UP, drop, false);
                if (remaining.m_41619_()) continue;
                BreakerTileEntity.spawnBlockAsEntity(world, pos, remaining);
            }
            SoundType stype = state.m_60734_().getSoundType(state, (LevelReader)world, pos, null);
            if (stype != null) {
                world.m_5594_(null, pos, stype.m_56777_(), SoundSource.BLOCKS, stype.m_56773_() * 0.6f, stype.m_56774_());
            }
            return true;
        }

        @Override
        public void tick() {
            boolean active;
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 5;
            BlockState device_state = this.f_58857_.m_8055_(this.f_58858_);
            if (!(device_state.m_60734_() instanceof BreakerBlock)) {
                return;
            }
            BlockPos target_pos = this.f_58858_.m_121945_((Direction)device_state.m_61143_((Property)BreakerBlock.HORIZONTAL_FACING));
            BlockState target_state = this.f_58857_.m_8055_(target_pos);
            if (this.f_58857_.m_276867_(this.f_58858_) || !BreakerTileEntity.isBreakable(target_state, target_pos, this.f_58857_)) {
                if (((Boolean)device_state.m_61143_((Property)BreakerBlock.ACTIVE)).booleanValue()) {
                    this.f_58857_.m_7731_(this.f_58858_, (BlockState)device_state.m_61124_((Property)BreakerBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
                }
                this.proc_time_elapsed_ = 0;
                this.tick_timer_ = 40;
                return;
            }
            this.time_needed_ = Mth.m_14045_((int)((int)(target_state.m_60800_((BlockGetter)this.f_58857_, this.f_58858_) * (float)breaking_reluctance) + min_breaking_time), (int)min_breaking_time, (int)800);
            if (this.battery_.draw(boost_energy_consumption)) {
                this.proc_time_elapsed_ += 45;
                this.time_needed_ += min_breaking_time * 4;
                this.active_timer_ = 2;
            } else if (!requires_power) {
                this.proc_time_elapsed_ += 5;
                this.active_timer_ = 1024;
            } else if (this.active_timer_ > 0) {
                --this.active_timer_;
            }
            boolean bl = active = this.active_timer_ > 0;
            if (requires_power && !active) {
                this.proc_time_elapsed_ = Math.max(0, this.proc_time_elapsed_ - 10);
            }
            if (this.proc_time_elapsed_ >= this.time_needed_) {
                this.proc_time_elapsed_ = 0;
                this.breakBlock(target_state, target_pos, this.f_58857_);
                active = false;
            }
            if ((Boolean)device_state.m_61143_((Property)BreakerBlock.ACTIVE) != active) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)device_state.m_61124_((Property)BreakerBlock.ACTIVE, (Comparable)Boolean.valueOf(active)), 3);
            }
        }

        static {
            blacklist.add(Blocks.f_50016_);
            blacklist.add(Blocks.f_50752_);
            blacklist.add(Blocks.f_50083_);
            blacklist.add(Blocks.f_50257_);
            blacklist.add(Blocks.f_50446_);
            blacklist.add(Blocks.f_50258_);
            blacklist.add(Blocks.f_50142_);
            blacklist.add(Blocks.f_50375_);
        }
    }

    public static class BreakerBlock
    extends StandardBlocks.HorizontalWaterLoggable
    implements StandardEntityBlocks.IStandardEntityBlock<BreakerTileEntity> {
        public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");

        public BreakerBlock(long config, BlockBehaviour.Properties builder, AABB[] unrotatedAABBs) {
            super(config, builder, unrotatedAABBs);
        }

        @Override
        public boolean isBlockEntityTicking(Level world, BlockState state) {
            return true;
        }

        @Override
        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            builder.m_61104_(new Property[]{ACTIVE});
        }

        @Override
        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            return (BlockState)super.m_5573_(context).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
        }

        @OnlyIn(value=Dist.CLIENT)
        public void animateTick(BlockState state, Level world, BlockPos pos, Random rnd) {
            if (state.m_60734_() != this || !((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
                return;
            }
            SoundEvent sound = SoundEvents.f_12634_;
            BlockState target_state = world.m_8055_(pos.m_121945_((Direction)state.m_61143_((Property)HORIZONTAL_FACING)));
            SoundType stype = target_state.m_60734_().m_49962_(target_state);
            if (stype == SoundType.f_56745_ || stype == SoundType.f_56740_ || stype == SoundType.f_56747_) {
                sound = SoundEvents.f_12641_;
            } else if (stype == SoundType.f_56739_ || stype == SoundType.f_56746_) {
                sound = SoundEvents.f_11995_;
            }
            world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), sound, SoundSource.BLOCKS, 0.1f, 1.2f, false);
            double rv = rnd.nextDouble();
            if (rv < 0.8) {
                double x = 0.5 + (double)pos.m_123341_();
                double y = 0.5 + (double)pos.m_123342_();
                double z = 0.5 + (double)pos.m_123343_();
                double xc = 0.52;
                double xr = rnd.nextDouble() * 0.4 - 0.2;
                double yr = y - 0.3 + rnd.nextDouble() * 0.2;
                switch ((Direction)state.m_61143_((Property)HORIZONTAL_FACING)) {
                    case WEST: {
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x - 0.52, yr, z + xr, 0.0, 0.0, 0.0);
                        break;
                    }
                    case EAST: {
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + 0.52, yr, z + xr, 0.0, 0.0, 0.0);
                        break;
                    }
                    case NORTH: {
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + xr, yr, z - 0.52, 0.0, 0.0, 0.0);
                        break;
                    }
                    default: {
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + xr, yr, z + 0.52, 0.0, 0.0, 0.0);
                    }
                }
            }
        }

        public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean unused) {
            if (!(world instanceof Level) || world.f_46443_) {
                return;
            }
            BlockEntity te = world.m_7702_(pos);
            if (!(te instanceof BreakerTileEntity)) {
                return;
            }
            ((BreakerTileEntity)te).block_updated();
        }

        public boolean m_7899_(BlockState state) {
            return true;
        }

        public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
            return 0;
        }

        public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
            return 0;
        }

        public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
            if (world.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            BlockEntity te = world.m_7702_(pos);
            if (te instanceof BreakerTileEntity) {
                ((BreakerTileEntity)te).state_message(player);
            }
            return InteractionResult.CONSUME;
        }
    }
}

