/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj.callback.block;

import blusunrize.immersiveengineering.api.client.ieobj.BlockCallback;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.common.blocks.metal.ConnectorProbeBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector4f;

public class ProbeConnectorCallbacks
implements BlockCallback<Key> {
    public static final ProbeConnectorCallbacks INSTANCE = new ProbeConnectorCallbacks();
    private static final Key INVALID = new Key(DyeColor.WHITE, DyeColor.WHITE);

    @Override
    public Key extractKey(@Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state, BlockEntity blockEntity) {
        if (!(blockEntity instanceof ConnectorProbeBlockEntity)) {
            return this.getDefaultKey();
        }
        ConnectorProbeBlockEntity probe = (ConnectorProbeBlockEntity)blockEntity;
        return new Key(probe.redstoneChannel, probe.redstoneChannelSending);
    }

    @Override
    public Key getDefaultKey() {
        return INVALID;
    }

    @Override
    public boolean dependsOnLayer() {
        return true;
    }

    @Override
    public boolean shouldRenderGroup(Key key, String group, RenderType layer) {
        if ("glass".equals(group)) {
            return layer == RenderType.m_110466_();
        }
        return layer == RenderType.m_110463_();
    }

    @Override
    public Vector4f getRenderColor(Key key, String group, String material, ShaderCase shader, Vector4f original) {
        if ("colour_in".equals(group)) {
            float[] rgb = key.receiving().m_41068_();
            return new Vector4f(rgb[0], rgb[1], rgb[2], 1.0f);
        }
        if ("colour_out".equals(group)) {
            float[] rgb = key.sending().m_41068_();
            return new Vector4f(rgb[0], rgb[1], rgb[2], 1.0f);
        }
        return original;
    }

    public record Key(DyeColor receiving, DyeColor sending) {
    }
}

