/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.block;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import xerca.xercamusic.client.ClientStuff;
import xerca.xercamusic.common.entity.EntityMusicSpirit;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.item.ItemMusicSheet;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class BlockInstrument
extends Block {
    public BlockInstrument(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public abstract IItemInstrument getItemInstrument();

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Vec3 vec3 = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() - 0.5, (double)pos.m_123343_() + 0.5);
        if (vec3.m_82554_(player.m_20182_()) > 4.0) {
            return InteractionResult.PASS;
        }
        ItemStack handStack = player.m_21120_(hand);
        if (handStack.m_41720_() instanceof ItemMusicSheet) {
            this.playMusic(worldIn, player, pos);
            return InteractionResult.SUCCESS;
        }
        ItemStack offhandStack = player.m_21120_(InteractionHand.values()[(hand.ordinal() + 1) % 2]);
        if (!(offhandStack.m_41720_() instanceof ItemMusicSheet)) {
            if (worldIn.f_46443_) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientStuff.showInstrumentGui(this.getItemInstrument(), pos));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void playMusic(Level worldIn, Player playerIn, BlockPos pos) {
        List musicSpirits = worldIn.m_6443_(EntityMusicSpirit.class, playerIn.m_20191_().m_82400_(3.0), entity -> entity.getBody().m_7306_((Entity)playerIn));
        if (musicSpirits.size() == 0) {
            worldIn.m_7967_((Entity)new EntityMusicSpirit(worldIn, playerIn, pos, this.getItemInstrument()));
        } else {
            musicSpirits.forEach(spirit -> spirit.setPlaying(false));
        }
    }
}

