/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.woodworks.common.block;

import com.teamabnormals.blueprint.core.api.IChestBlock;
import com.teamabnormals.woodworks.common.block.entity.ClosetBlockEntity;
import com.teamabnormals.woodworks.core.registry.WoodworksBlockEntityTypes;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ClosetBlock
extends ChestBlock
implements IChestBlock {
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.f_61394_;
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)14.0, (double)14.0, (double)15.0);
    protected static final VoxelShape NORTH_AABB_TALL = Block.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0);
    protected static final VoxelShape SOUTH_AABB_TALL = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)14.0, (double)16.0, (double)15.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)14.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)14.0);
    protected static final VoxelShape WEST_AABB_TALL = Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB_TALL = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)14.0);
    protected static final VoxelShape AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape AABB_TALL = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public final String type;
    private static final DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<MenuProvider>> MENU_PROVIDER_COMBINER = new DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<MenuProvider>>(){

        public Optional<MenuProvider> acceptDouble(final ChestBlockEntity chest1, final ChestBlockEntity chest2) {
            CompoundContainer container = new CompoundContainer((Container)chest2, (Container)chest1);
            return Optional.of(new MenuProvider(){
                final /* synthetic */ Container val$container;
                {
                    this.val$container = container;
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int num, Inventory inventory, Player player) {
                    if (chest1.m_7525_(player) && chest2.m_7525_(player)) {
                        chest1.m_59640_(inventory.f_35978_);
                        chest2.m_59640_(inventory.f_35978_);
                        return ChestMenu.m_39246_((int)num, (Inventory)inventory, (Container)this.val$container);
                    }
                    return null;
                }

                public Component m_5446_() {
                    if (chest1.m_8077_()) {
                        return chest1.m_5446_();
                    }
                    return chest2.m_8077_() ? chest2.m_5446_() : Component.m_237115_((String)"container.woodworks.closetDouble");
                }
            });
        }

        public Optional<MenuProvider> acceptSingle(ChestBlockEntity p_51602_) {
            return Optional.of(p_51602_);
        }

        public Optional<MenuProvider> acceptNone() {
            return Optional.empty();
        }
    };

    public ClosetBlock(String type, BlockBehaviour.Properties props, Supplier<BlockEntityType<? extends ChestBlockEntity>> blockEntityType) {
        super(props, blockEntityType);
        this.type = type;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_51478_, (Comparable)Direction.NORTH)).m_61124_(HINGE, (Comparable)DoorHingeSide.LEFT)).m_61124_((Property)f_51479_, (Comparable)ChestType.SINGLE)).m_61124_((Property)f_51480_, (Comparable)Boolean.valueOf(false)));
    }

    public ClosetBlock(String type, BlockBehaviour.Properties props) {
        this(type, props, () -> WoodworksBlockEntityTypes.CLOSET.get());
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ClosetBlockEntity(pos, state);
    }

    public String getChestMaterialsName() {
        return this.type;
    }

    @Nullable
    public MenuProvider m_7246_(BlockState state, Level level, BlockPos pos) {
        return ((Optional)this.m_5641_(state, level, pos, false).m_5649_(MENU_PROVIDER_COMBINER)).orElse(null);
    }

    public DoubleBlockCombiner.NeighborCombineResult<? extends ChestBlockEntity> m_5641_(BlockState state, Level level, BlockPos pos, boolean p_51547_) {
        BiPredicate<LevelAccessor, BlockPos> bipredicate = p_51547_ ? (p_51578_, p_51579_) -> false : ClosetBlock::isChestBlockedAt;
        return DoubleBlockCombiner.m_52822_((BlockEntityType)((BlockEntityType)this.f_48675_.get()), ChestBlock::m_51582_, ClosetBlock::getConnectedDirection, (DirectionProperty)f_51478_, (BlockState)state, (LevelAccessor)level, (BlockPos)pos, bipredicate);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        boolean left;
        boolean tall = state.m_61143_((Property)f_51479_) == ChestType.RIGHT;
        boolean bl = left = state.m_61143_(HINGE) == DoorHingeSide.LEFT;
        if (ClosetBlock.shouldTranslateCloset(state, level, pos)) {
            VoxelShape north = tall ? NORTH_AABB_TALL : NORTH_AABB;
            VoxelShape south = tall ? SOUTH_AABB_TALL : SOUTH_AABB;
            VoxelShape east = tall ? EAST_AABB_TALL : EAST_AABB;
            VoxelShape west = tall ? WEST_AABB_TALL : WEST_AABB;
            switch ((Direction)state.m_61143_((Property)f_51478_)) {
                default: {
                    return !left ? north : south;
                }
                case SOUTH: {
                    return !left ? south : north;
                }
                case WEST: {
                    return left ? west : east;
                }
                case EAST: 
            }
            return left ? east : west;
        }
        if (tall) {
            return AABB_TALL;
        }
        return AABB;
    }

    public static boolean shouldTranslateCloset(BlockState state, BlockGetter level, BlockPos pos) {
        ChestType chesttype;
        boolean right = state.m_61138_(HINGE) && state.m_61143_(HINGE) == DoorHingeSide.RIGHT;
        Direction facing = (Direction)state.m_61143_((Property)ChestBlock.f_51478_);
        BlockPos neighborPos = pos.m_121945_(!right ? facing.m_122428_() : facing.m_122427_());
        ChestType chestType = chesttype = state.m_61138_((Property)ChestBlock.f_51479_) ? (ChestType)state.m_61143_((Property)ChestBlock.f_51479_) : ChestType.SINGLE;
        if (level.m_8055_(neighborPos).m_60713_(state.m_60734_())) {
            BlockState neighborState = level.m_8055_(neighborPos);
            DoorHingeSide hinge = (DoorHingeSide)state.m_61143_(HINGE);
            return neighborState.m_61143_((Property)f_51479_) == chesttype && neighborState.m_61143_((Property)f_51478_) == facing && neighborState.m_61143_(HINGE) != hinge;
        }
        return false;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState otherState, LevelAccessor level, BlockPos pos, BlockPos otherPos) {
        if (((Boolean)state.m_61143_((Property)f_51480_)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (otherState.m_60713_((Block)this) && direction.m_122434_().m_122478_()) {
            ChestType chesttype = (ChestType)otherState.m_61143_((Property)f_51479_);
            if (state.m_61143_((Property)f_51479_) == ChestType.SINGLE && chesttype != ChestType.SINGLE && state.m_61143_((Property)f_51478_) == otherState.m_61143_((Property)f_51478_) && ClosetBlock.getConnectedDirection(otherState) == direction.m_122424_()) {
                return (BlockState)state.m_61124_((Property)f_51479_, (Comparable)chesttype.m_61486_());
            }
        } else if (ClosetBlock.getConnectedDirection(state) == direction) {
            return (BlockState)state.m_61124_((Property)f_51479_, (Comparable)ChestType.SINGLE);
        }
        return state;
    }

    public static boolean isChestBlockedAt(LevelAccessor level, BlockPos pos) {
        Direction facing = (Direction)level.m_8055_(pos).m_61143_((Property)f_51478_);
        BlockPos offsetPos = pos.m_121945_(facing);
        return level.m_8055_(offsetPos).m_60796_((BlockGetter)level, offsetPos);
    }

    public static Direction getConnectedDirection(BlockState state) {
        return state.m_61143_((Property)f_51479_) == ChestType.LEFT ? Direction.DOWN : Direction.UP;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        DoorHingeSide hinge2;
        Direction direction2;
        ChestType chestType = ChestType.SINGLE;
        Direction facingDirection = context.m_8125_().m_122424_();
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        boolean isSneaking = context.m_7078_();
        Direction direction1 = context.m_43719_();
        DoorHingeSide hinge = this.getHinge(context);
        if (direction1.m_122434_().m_122478_() && isSneaking && (direction2 = this.candidatePartnerFacing(context, direction1.m_122424_())) != null && direction2 == facingDirection && direction2.m_122434_() != direction1.m_122434_()) {
            chestType = direction1 == Direction.DOWN ? ChestType.RIGHT : ChestType.LEFT;
            DoorHingeSide hinge22 = this.candidatePartnerHinge(context, direction1.m_122424_());
            if (hinge22 != null) {
                hinge = hinge22;
            }
        }
        if (direction1.m_122434_().m_122479_() && isSneaking && (hinge2 = this.candidatePartnerHinge(context, direction1.m_122424_())) != null) {
            DoorHingeSide doorHingeSide = hinge = hinge2 == DoorHingeSide.LEFT ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT;
        }
        if (chestType == ChestType.SINGLE && !isSneaking) {
            if (facingDirection == this.candidatePartnerFacing(context, Direction.DOWN)) {
                chestType = ChestType.LEFT;
                hinge2 = this.candidatePartnerHinge(context, Direction.DOWN);
                if (hinge2 != null) {
                    hinge = hinge2;
                }
            } else if (facingDirection == this.candidatePartnerFacing(context, Direction.UP)) {
                chestType = ChestType.RIGHT;
                hinge2 = this.candidatePartnerHinge(context, Direction.UP);
                if (hinge2 != null) {
                    hinge = hinge2;
                }
            }
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_51478_, (Comparable)facingDirection)).m_61124_(HINGE, (Comparable)hinge)).m_61124_((Property)f_51479_, (Comparable)chestType)).m_61124_((Property)f_51480_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    private DoorHingeSide getHinge(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockPos abovePos = pos.m_7494_();
        Direction dir = context.m_8125_();
        Direction dirCCW = dir.m_122428_();
        BlockPos posCCW = pos.m_121945_(dirCCW);
        BlockState stateCCW = level.m_8055_(posCCW);
        BlockPos abovePosCCW = abovePos.m_121945_(dirCCW);
        BlockState aboveStateCCW = level.m_8055_(abovePosCCW);
        Direction dirCW = dir.m_122427_();
        BlockPos posCW = pos.m_121945_(dirCW);
        BlockState stateCW = level.m_8055_(posCW);
        BlockPos abovePosCW = abovePos.m_121945_(dirCW);
        BlockState aboveStateCW = level.m_8055_(abovePosCW);
        int i = (stateCCW.m_60838_((BlockGetter)level, posCCW) ? -1 : 0) + (aboveStateCCW.m_60838_((BlockGetter)level, abovePosCCW) ? -1 : 0) + (stateCW.m_60838_((BlockGetter)level, posCW) ? 1 : 0) + (aboveStateCW.m_60838_((BlockGetter)level, abovePosCW) ? 1 : 0);
        boolean flag = stateCCW.m_60713_((Block)this);
        boolean flag1 = stateCW.m_60713_((Block)this);
        if ((!flag || flag1) && i <= 0) {
            if ((!flag1 || flag) && i >= 0) {
                int j = dir.m_122429_();
                int k = dir.m_122431_();
                Vec3 vec3 = context.m_43720_();
                double d0 = vec3.f_82479_ - (double)pos.m_123341_();
                double d1 = vec3.f_82481_ - (double)pos.m_123343_();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    @Nullable
    private Direction candidatePartnerFacing(BlockPlaceContext context, Direction direction) {
        BlockState state = context.m_43725_().m_8055_(context.m_8083_().m_121945_(direction));
        return state.m_60713_((Block)this) && state.m_61143_((Property)f_51479_) == ChestType.SINGLE ? (Direction)state.m_61143_((Property)f_51478_) : null;
    }

    @Nullable
    private DoorHingeSide candidatePartnerHinge(BlockPlaceContext context, Direction direction) {
        BlockState state = context.m_43725_().m_8055_(context.m_8083_().m_121945_(direction));
        return state.m_60713_((Block)this) && state.m_61143_((Property)f_51479_) == ChestType.SINGLE ? (DoorHingeSide)state.m_61143_(HINGE) : null;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)super.m_6943_(state, mirror).m_61122_(HINGE);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HINGE});
    }
}

