//package com.rosemods.wintertale.core.other.armor;
//
//import com.rosemods.wintertale.core.registry.WinterTaleItems;
//import lombok.Getter;
//import net.minecraft.Util;
//import net.minecraft.sounds.SoundEvent;
//import net.minecraft.sounds.SoundEvents;
//import net.minecraft.util.LazyLoadedValue;
//import net.minecraft.util.StringRepresentable;
//import net.minecraft.world.item.ArmorItem;
//import net.minecraft.world.item.ArmorMaterial;
//import net.minecraft.world.item.ArmorMaterials;
//import net.minecraft.world.item.Items;
//import net.minecraft.world.item.crafting.Ingredient;
//import org.jetbrains.annotations.NotNull;
//
//import java.util.EnumMap;
//
//@Getter
//public enum WinterTaleArmorMaterials implements StringRepresentable, ArmorMaterial {
//    ANTLER("anntler", 5, Util.make(new EnumMap<>(ArmorItem.Type.class), (p_266652_) -> {
//        p_266652_.put(ArmorItem.Type.HELMET, 1);
//    }), 15, SoundEvents.ARMOR_EQUIP_GENERIC, 0.0F, 0.0F, () -> {
//        return Ingredient.of(Items.LEATHER);
//    }),
//
//    public static final StringRepresentable.EnumCodec<ArmorMaterials> CODEC = StringRepresentable.fromEnum(ArmorMaterials::values);
//
//    private static final EnumMap<ArmorItem.Type, Integer> HEALTH_FUNCTION_FOR_TYPE = Util.make(new EnumMap<>(ArmorItem.Type.class), (p_266653_) -> {
//        p_266653_.put(ArmorItem.Type.HELMET, 11);
//    });
//    private final String name;
//    private final int durabilityMultiplier;
//    private final EnumMap<ArmorItem.Type, Integer> protectionFunctionForType;
//    private final int enchantmentValue;
//    private final SoundEvent sound;
//    private final float toughness;
//    private final float knockbackResistance;
//    private final LazyLoadedValue<Ingredient> repairIngredient;
//
//    private WinterTaleArmorMaterials(String p_268171_, int p_268303_, EnumMap<ArmorItem.Type, Integer> p_267941_, int p_268086_, SoundEvent p_268145_, float p_268058_, float p_268180_, Supplier<Ingredient> p_268256_) {
//        this.name = p_268171_;
//        this.durabilityMultiplier = p_268303_;
//        this.protectionFunctionForType = p_267941_;
//        this.enchantmentValue = p_268086_;
//        this.sound = p_268145_;
//        this.toughness = p_268058_;
//        this.knockbackResistance = p_268180_;
//        this.repairIngredient = new LazyLoadedValue<>(p_268256_);
//    }
//
//    public int getDurabilityForType(ArmorItem.Type p_266745_) {
//        return HEALTH_FUNCTION_FOR_TYPE.get(p_266745_) * this.durabilityMultiplier;
//    }
//
//    public int getDefenseForType(ArmorItem.Type p_266752_) {
//        return this.protectionFunctionForType.get(p_266752_);
//    }
//
//    public @NotNull SoundEvent getEquipSound() {
//        return this.sound;
//    }
//
//    public @NotNull Ingredient getRepairIngredient() {
//        return this.repairIngredient.get();
//    }
//
//    public String getSerializedName() {
//        return this.name;
//    }
//}