/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.datagen.models;

import com.google.gson.JsonElement;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.valhelsia.valhelsia_core.api.common.registry.helper.block.BlockEntrySet;
import net.valhelsia.valhelsia_core.api.common.registry.helper.block.BlockRegistryEntry;
import net.valhelsia.valhelsia_furniture.common.block.AbstractCurtainBlock;
import net.valhelsia.valhelsia_furniture.common.block.ChairBlock;
import net.valhelsia.valhelsia_furniture.common.block.ClosedCurtainBlock;
import net.valhelsia.valhelsia_furniture.common.block.DeskBlock;
import net.valhelsia.valhelsia_furniture.common.block.DeskDrawerBlock;
import net.valhelsia.valhelsia_furniture.common.block.FabricDeskLampBlock;
import net.valhelsia.valhelsia_furniture.common.block.FurnitureBlock;
import net.valhelsia.valhelsia_furniture.common.block.StoolBlock;
import net.valhelsia.valhelsia_furniture.common.block.TableBlock;
import net.valhelsia.valhelsia_furniture.common.block.UpholsteredChairBlock;
import net.valhelsia.valhelsia_furniture.common.block.properties.CurtainPart;
import net.valhelsia.valhelsia_furniture.common.block.properties.ModBlockStateProperties;
import net.valhelsia.valhelsia_furniture.core.registry.ModBlocks;
import net.valhelsia.valhelsia_furniture.datagen.models.ModModelTemplates;
import net.valhelsia.valhelsia_furniture.datagen.models.ModTextureMapping;
import net.valhelsia.valhelsia_furniture.datagen.models.ModTextureSlots;

public class ModBlockModels {
    private final BlockModelGenerators generators;
    private final Consumer<BlockStateGenerator> blockStateOutput;
    private final BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput;
    private final Consumer<Item> skippedAutoItemModels;

    private ModBlockModels(BlockModelGenerators generators, Consumer<Item> skippedAutoItemModels) {
        this.generators = generators;
        this.blockStateOutput = generators.f_124477_;
        this.modelOutput = generators.f_124478_;
        this.skippedAutoItemModels = skippedAutoItemModels;
    }

    public static void create(BlockModelGenerators generators, Consumer<Item> skippedAutoItemModels) {
        new ModBlockModels(generators, skippedAutoItemModels).createModels();
    }

    private void skipAutoItemBlock(Block block) {
        this.skippedAutoItemModels.accept(block.m_5456_());
    }

    public void createModels() {
        this.createTable((Block)ModBlocks.OAK_TABLE.get());
        this.createTable((Block)ModBlocks.SPRUCE_TABLE.get());
        this.createTable((Block)ModBlocks.BIRCH_TABLE.get());
        this.createTable((Block)ModBlocks.JUNGLE_TABLE.get());
        this.createTable((Block)ModBlocks.ACACIA_TABLE.get());
        this.createTable((Block)ModBlocks.CHERRY_TABLE.get());
        this.createTable((Block)ModBlocks.DARK_OAK_TABLE.get());
        this.createTable((Block)ModBlocks.MANGROVE_TABLE.get());
        this.createTable((Block)ModBlocks.CRIMSON_TABLE.get());
        this.createTable((Block)ModBlocks.WARPED_TABLE.get());
        this.apply(ModBlocks.COLORED_OAK_TABLES, this::createTable);
        this.apply(ModBlocks.COLORED_SPRUCE_TABLES, this::createTable);
        this.apply(ModBlocks.COLORED_BIRCH_TABLES, this::createTable);
        this.apply(ModBlocks.COLORED_JUNGLE_TABLES, this::createTable);
        this.apply(ModBlocks.COLORED_ACACIA_TABLES, this::createTable);
        this.apply(ModBlocks.COLORED_CHERRY_TABLES, this::createTable);
        this.apply(ModBlocks.COLORED_DARK_OAK_TABLES, this::createTable);
        this.apply(ModBlocks.COLORED_MANGROVE_TABLES, this::createTable);
        this.apply(ModBlocks.COLORED_CRIMSON_TABLES, this::createTable);
        this.apply(ModBlocks.COLORED_WARPED_TABLES, this::createTable);
        this.createChair((Block)ModBlocks.OAK_CHAIR.get());
        this.createChair((Block)ModBlocks.SPRUCE_CHAIR.get());
        this.createChair((Block)ModBlocks.BIRCH_CHAIR.get());
        this.createChair((Block)ModBlocks.JUNGLE_CHAIR.get());
        this.createChair((Block)ModBlocks.ACACIA_CHAIR.get());
        this.createChair((Block)ModBlocks.CHERRY_CHAIR.get());
        this.createChair((Block)ModBlocks.DARK_OAK_CHAIR.get());
        this.createChair((Block)ModBlocks.MANGROVE_CHAIR.get());
        this.createChair((Block)ModBlocks.CRIMSON_CHAIR.get());
        this.createChair((Block)ModBlocks.WARPED_CHAIR.get());
        this.createChair((Block)ModBlocks.HAY_OAK_CHAIR.get());
        this.createChair((Block)ModBlocks.HAY_SPRUCE_CHAIR.get());
        this.createChair((Block)ModBlocks.HAY_BIRCH_CHAIR.get());
        this.createChair((Block)ModBlocks.HAY_JUNGLE_CHAIR.get());
        this.createChair((Block)ModBlocks.HAY_ACACIA_CHAIR.get());
        this.createChair((Block)ModBlocks.HAY_CHERRY_CHAIR.get());
        this.createChair((Block)ModBlocks.HAY_DARK_OAK_CHAIR.get());
        this.createChair((Block)ModBlocks.HAY_MANGROVE_CHAIR.get());
        this.createChair((Block)ModBlocks.HAY_CRIMSON_CHAIR.get());
        this.createChair((Block)ModBlocks.HAY_WARPED_CHAIR.get());
        this.apply(ModBlocks.WOOL_OAK_CHAIRS, this::createChair);
        this.apply(ModBlocks.WOOL_SPRUCE_CHAIRS, this::createChair);
        this.apply(ModBlocks.WOOL_BIRCH_CHAIRS, this::createChair);
        this.apply(ModBlocks.WOOL_JUNGLE_CHAIRS, this::createChair);
        this.apply(ModBlocks.WOOL_ACACIA_CHAIRS, this::createChair);
        this.apply(ModBlocks.WOOL_CHERRY_CHAIRS, this::createChair);
        this.apply(ModBlocks.WOOL_DARK_OAK_CHAIRS, this::createChair);
        this.apply(ModBlocks.WOOL_MANGROVE_CHAIRS, this::createChair);
        this.apply(ModBlocks.WOOL_CRIMSON_CHAIRS, this::createChair);
        this.apply(ModBlocks.WOOL_WARPED_CHAIRS, this::createChair);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_OAK_CHAIRS, this::createUpholsteredChair);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_SPRUCE_CHAIRS, this::createUpholsteredChair);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_BIRCH_CHAIRS, this::createUpholsteredChair);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_JUNGLE_CHAIRS, this::createUpholsteredChair);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_ACACIA_CHAIRS, this::createUpholsteredChair);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_CHERRY_CHAIRS, this::createUpholsteredChair);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_DARK_OAK_CHAIRS, this::createUpholsteredChair);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_MANGROVE_CHAIRS, this::createUpholsteredChair);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_CRIMSON_CHAIRS, this::createUpholsteredChair);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_WARPED_CHAIRS, this::createUpholsteredChair);
        this.createStool((Block)ModBlocks.OAK_STOOL.get());
        this.createStool((Block)ModBlocks.SPRUCE_STOOL.get());
        this.createStool((Block)ModBlocks.BIRCH_STOOL.get());
        this.createStool((Block)ModBlocks.JUNGLE_STOOL.get());
        this.createStool((Block)ModBlocks.ACACIA_STOOL.get());
        this.createStool((Block)ModBlocks.CHERRY_STOOL.get());
        this.createStool((Block)ModBlocks.DARK_OAK_STOOL.get());
        this.createStool((Block)ModBlocks.MANGROVE_STOOL.get());
        this.createStool((Block)ModBlocks.CRIMSON_STOOL.get());
        this.createStool((Block)ModBlocks.WARPED_STOOL.get());
        this.apply(ModBlocks.WOOL_UPHOLSTERED_OAK_STOOLS, this::createUpholsteredStool);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_SPRUCE_STOOLS, this::createUpholsteredStool);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_BIRCH_STOOLS, this::createUpholsteredStool);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_JUNGLE_STOOLS, this::createUpholsteredStool);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_ACACIA_STOOLS, this::createUpholsteredStool);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_CHERRY_STOOLS, this::createUpholsteredStool);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_DARK_OAK_STOOLS, this::createUpholsteredStool);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_MANGROVE_STOOLS, this::createUpholsteredStool);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_CRIMSON_STOOLS, this::createUpholsteredStool);
        this.apply(ModBlocks.WOOL_UPHOLSTERED_WARPED_STOOLS, this::createUpholsteredStool);
        this.createDesk((Block)ModBlocks.OAK_DESK.get());
        this.createDesk((Block)ModBlocks.SPRUCE_DESK.get());
        this.createDesk((Block)ModBlocks.BIRCH_DESK.get());
        this.createDesk((Block)ModBlocks.JUNGLE_DESK.get());
        this.createDesk((Block)ModBlocks.ACACIA_DESK.get());
        this.createDesk((Block)ModBlocks.CHERRY_DESK.get());
        this.createDesk((Block)ModBlocks.DARK_OAK_DESK.get());
        this.createDesk((Block)ModBlocks.MANGROVE_DESK.get());
        this.createDesk((Block)ModBlocks.CRIMSON_DESK.get());
        this.createDesk((Block)ModBlocks.WARPED_DESK.get());
        this.createDesk((Block)ModBlocks.OAK_DESK_DRAWER.get());
        this.createDesk((Block)ModBlocks.SPRUCE_DESK_DRAWER.get());
        this.createDesk((Block)ModBlocks.BIRCH_DESK_DRAWER.get());
        this.createDesk((Block)ModBlocks.JUNGLE_DESK_DRAWER.get());
        this.createDesk((Block)ModBlocks.ACACIA_DESK_DRAWER.get());
        this.createDesk((Block)ModBlocks.CHERRY_DESK_DRAWER.get());
        this.createDesk((Block)ModBlocks.DARK_OAK_DESK_DRAWER.get());
        this.createDesk((Block)ModBlocks.MANGROVE_DESK_DRAWER.get());
        this.createDesk((Block)ModBlocks.CRIMSON_DESK_DRAWER.get());
        this.createDesk((Block)ModBlocks.WARPED_DESK_DRAWER.get());
        this.apply(ModBlocks.FABRIC_DESK_LAMPS, this::createDeskLamp);
        this.apply(ModBlocks.CLOSED_CURTAINS, (T block) -> this.createCurtain((AbstractCurtainBlock<?>)((Object)block), (EnumProperty<? extends CurtainPart>)ModBlockStateProperties.CLOSED_CURTAIN_PART));
        this.apply(ModBlocks.OPEN_CURTAINS, (T block) -> this.createCurtain((AbstractCurtainBlock<?>)((Object)block), (EnumProperty<? extends CurtainPart>)ModBlockStateProperties.OPEN_CURTAIN_PART));
    }

    private <T extends Block> void apply(BlockEntrySet<T, ?> set, Consumer<T> consumer) {
        for (BlockRegistryEntry entry : set.values()) {
            consumer.accept((Block)entry.get());
        }
    }

    private <T extends Block, K extends Enum<K>> void apply(BlockEntrySet<T, K> set, BiConsumer<T, K> consumer) {
        for (Map.Entry entry : set.entrySet()) {
            consumer.accept((Block)((BlockRegistryEntry)entry.getValue()).get(), (Enum)entry.getKey());
        }
    }

    private void createTable(Block block) {
        if (!(block instanceof TableBlock)) {
            return;
        }
        TableBlock tableBlock = (TableBlock)block;
        String folder = FurnitureBlock.Type.TABLE.m_7912_() + "/" + tableBlock.getWoodType().f_61839_();
        TextureMapping textureMapping = new TextureMapping().m_125758_(ModTextureSlots.TABLE, ModTextureMapping.getBlockTexture(block, folder)).m_125758_(ModTextureSlots.CONNECTED_TABLE, ModTextureMapping.getBlockTexture(block, folder, "_connected"));
        this.createTableModels(block, textureMapping);
        PropertyDispatch dispatch = PropertyDispatch.m_125308_((Property)BlockStateProperties.f_61368_, (Property)BlockStateProperties.f_61369_, (Property)BlockStateProperties.f_61370_, (Property)BlockStateProperties.f_61371_, (Property)ModBlockStateProperties.ROTATED).m_176408_((north, east, south, west, rotated) -> {
            String suffix;
            boolean connected = north != false || east != false || south != false || west != false;
            boolean allConnected = north != false && east != false && south != false && west != false;
            String string = suffix = connected ? "_" : "";
            if (north.booleanValue()) {
                String string2 = suffix = rotated != false && !allConnected ? suffix.concat("e") : suffix.concat("n");
            }
            if (east.booleanValue()) {
                String string3 = suffix = rotated != false && !allConnected ? suffix.concat("s") : suffix.concat("e");
            }
            if (south.booleanValue()) {
                String string4 = suffix = rotated != false && !allConnected ? suffix.concat("w") : suffix.concat("s");
            }
            if (west.booleanValue()) {
                suffix = rotated != false && !allConnected ? suffix.concat("n") : suffix.concat("w");
            }
            suffix = switch (suffix) {
                case "_esn" -> "_nes";
                case "_swn" -> "_nsw";
                case "_ewn" -> "_new";
                case "_sn" -> "_ns";
                case "_en" -> "_ne";
                case "_wn" -> "_nw";
                default -> suffix;
            };
            Variant variant = Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)ModelLocationUtils.m_125578_((Block)block, (String)suffix));
            if (rotated.booleanValue()) {
                variant.m_125511_(VariantProperties.f_125519_, (Object)(!connected ? VariantProperties.Rotation.R90 : VariantProperties.Rotation.R270));
            }
            return variant;
        });
        this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)block).m_125271_(dispatch));
    }

    private void createTableModels(Block block, TextureMapping mapping) {
        ModModelTemplates.TABLE.m_125592_(block, mapping, this.modelOutput);
        ModModelTemplates.TABLE_N.m_125596_(block, "_n", mapping, this.modelOutput);
        ModModelTemplates.TABLE_E.m_125596_(block, "_e", mapping, this.modelOutput);
        ModModelTemplates.TABLE_S.m_125596_(block, "_s", mapping, this.modelOutput);
        ModModelTemplates.TABLE_W.m_125596_(block, "_w", mapping, this.modelOutput);
        ModModelTemplates.TABLE_NE.m_125596_(block, "_ne", mapping, this.modelOutput);
        ModModelTemplates.TABLE_NES.m_125596_(block, "_nes", mapping, this.modelOutput);
        ModModelTemplates.TABLE_NESW.m_125596_(block, "_nesw", mapping, this.modelOutput);
        ModModelTemplates.TABLE_NEW.m_125596_(block, "_new", mapping, this.modelOutput);
        ModModelTemplates.TABLE_NS.m_125596_(block, "_ns", mapping, this.modelOutput);
        ModModelTemplates.TABLE_NSW.m_125596_(block, "_nsw", mapping, this.modelOutput);
        ModModelTemplates.TABLE_NW.m_125596_(block, "_nw", mapping, this.modelOutput);
        ModModelTemplates.TABLE_SW.m_125596_(block, "_sw", mapping, this.modelOutput);
        ModModelTemplates.TABLE_ES.m_125596_(block, "_es", mapping, this.modelOutput);
        ModModelTemplates.TABLE_ESW.m_125596_(block, "_esw", mapping, this.modelOutput);
        ModModelTemplates.TABLE_EW.m_125596_(block, "_ew", mapping, this.modelOutput);
    }

    private void createChair(Block block) {
        if (!(block instanceof ChairBlock)) {
            return;
        }
        ChairBlock chairBlock = (ChairBlock)block;
        TextureMapping textureMapping = new TextureMapping().m_125758_(ModTextureSlots.CHAIR, ModTextureMapping.getBlockTexture(block, "chair/" + chairBlock.getWoodType().f_61839_()));
        ResourceLocation model = ModModelTemplates.CHAIR.m_125592_(block, textureMapping, this.modelOutput);
        this.blockStateOutput.accept((BlockStateGenerator)ModBlockModels.createSimpleBlock(block, model).m_125271_(BlockModelGenerators.m_124727_()));
    }

    private void createUpholsteredChair(UpholsteredChairBlock block) {
        TextureMapping textureMapping = new TextureMapping().m_125758_(ModTextureSlots.WOOL, new ResourceLocation("valhelsia_furniture", "block/upholstered_chair/colors/" + block.getColor())).m_125758_(ModTextureSlots.WOOD, new ResourceLocation("valhelsia_furniture", "block/upholstered_chair/base/" + block.getWoodType().f_61839_()));
        ResourceLocation model = ModModelTemplates.UPHOLSTERED_CHAIR.m_125592_((Block)block, textureMapping, this.modelOutput);
        this.blockStateOutput.accept((BlockStateGenerator)ModBlockModels.createSimpleBlock(block, model).m_125271_(BlockModelGenerators.m_124727_()));
    }

    private void createStool(Block block) {
        TextureMapping textureMapping = new TextureMapping().m_125758_(ModTextureSlots.STOOL, ModTextureMapping.getBlockTexture(block, "stool"));
        ResourceLocation model = ModModelTemplates.STOOL.m_125592_(block, textureMapping, this.modelOutput);
        ResourceLocation rotatedModel = ModModelTemplates.STOOL_ROTATED.m_125596_(block, "_rotated", textureMapping, this.modelOutput);
        this.blockStateOutput.accept((BlockStateGenerator)ModBlockModels.createSimpleBlock(block, model).m_125271_(ModBlockModels.createRotatedDispatch(rotatedModel)));
    }

    private void createUpholsteredStool(StoolBlock block) {
        TextureMapping textureMapping = new TextureMapping().m_125758_(ModTextureSlots.WOOD, new ResourceLocation("valhelsia_furniture", "block/upholstered_stool/base/" + block.getWoodType().f_61839_())).m_125758_(ModTextureSlots.WOOL, new ResourceLocation("valhelsia_furniture", "block/upholstered_stool/colors/" + block.getColor()));
        ResourceLocation model = ModModelTemplates.UPHOLSTERED_STOOL.m_125592_((Block)block, textureMapping, this.modelOutput);
        ResourceLocation rotatedModel = ModModelTemplates.UPHOLSTERED_STOOL_ROTATED.m_125596_((Block)block, "_rotated", textureMapping, this.modelOutput);
        this.blockStateOutput.accept((BlockStateGenerator)ModBlockModels.createSimpleBlock(block, model).m_125271_(ModBlockModels.createRotatedDispatch(rotatedModel)));
    }

    private void createDesk(Block block) {
        if (!(block instanceof DeskBlock)) {
            return;
        }
        DeskBlock deskBlock = (DeskBlock)block;
        PropertyDispatch dispatch = PropertyDispatch.m_125296_((Property)ModBlockStateProperties.LEFT, (Property)ModBlockStateProperties.RIGHT).m_125362_((left, right) -> {
            String variant = "";
            if (left.booleanValue() && right.booleanValue()) {
                variant = "_center";
            } else if (left.booleanValue()) {
                variant = "_right";
            } else if (right.booleanValue()) {
                variant = "_left";
            }
            List<TextureSlot> textureSlots = variant.equals("_left") || variant.equals("_right") ? DeskBlock.VARIANT_TEXTURES.get("left_or_right") : (variant.equals("_center") ? DeskBlock.VARIANT_TEXTURES.get("center") : DeskBlock.VARIANT_TEXTURES.get("single"));
            TextureMapping textureMapping = new TextureMapping();
            for (TextureSlot slot : textureSlots) {
                textureMapping.m_125758_(slot, new ResourceLocation("valhelsia_furniture", "block/desk/" + deskBlock.getWoodType().f_61839_() + "/" + slot.m_125897_()));
            }
            ResourceLocation model = this.getDeskModel((boolean)left, (boolean)right, block instanceof DeskDrawerBlock).m_125596_(block, variant, textureMapping, this.modelOutput);
            return Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)model);
        });
        this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)block).m_125271_(BlockModelGenerators.m_124727_()).m_125271_(dispatch));
    }

    private ModelTemplate getDeskModel(boolean left, boolean right, boolean drawer) {
        if (left && right) {
            return drawer ? ModModelTemplates.DESK_DRAWER_CENTER : ModModelTemplates.DESK_CENTER;
        }
        if (left) {
            return drawer ? ModModelTemplates.DESK_DRAWER_RIGHT : ModModelTemplates.DESK_RIGHT;
        }
        if (right) {
            return drawer ? ModModelTemplates.DESK_DRAWER_LEFT : ModModelTemplates.DESK_LEFT;
        }
        return drawer ? ModModelTemplates.DESK_DRAWER : ModModelTemplates.DESK;
    }

    private void createDeskLamp(FabricDeskLampBlock block, DyeColor color) {
        TextureMapping textureMapping = new TextureMapping().m_125758_(ModTextureSlots.COLOR, new ResourceLocation("valhelsia_furniture", "block/fabric_desk_lamp/colors/" + color.m_41065_()));
        ResourceLocation model = ModModelTemplates.FABRIC_DESK_LAMP.m_125592_((Block)block, textureMapping, this.modelOutput);
        ResourceLocation modelOn = ModModelTemplates.FABRIC_DESK_LAMP_ON.m_125596_((Block)block, "_rotated", textureMapping, this.modelOutput);
        this.createSimpleFlatItemModel(block.m_5456_());
        this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)block).m_125271_(BlockModelGenerators.m_124622_((BooleanProperty)ModBlockStateProperties.SWITCHED_ON, (ResourceLocation)modelOn, (ResourceLocation)model)));
    }

    private void createCurtain(AbstractCurtainBlock<?> block, EnumProperty<? extends CurtainPart> property) {
        for (CurtainPart part2 : property.m_6908_()) {
            if (part2.getModelTemplate() == null) continue;
            String folder = "curtain/" + block.getColor().m_41065_();
            TextureMapping textureMapping = new TextureMapping().m_125758_(TextureSlot.f_125872_, ModTextureMapping.getBlockTexture(folder, part2.getTopTexture())).m_125758_(TextureSlot.f_125881_, ModTextureMapping.getBlockTexture(folder, part2.getBottomTexture()));
            part2.getModelTemplate().m_125596_(block, part2.getModelName(), textureMapping, this.modelOutput);
        }
        PropertyDispatch dispatch = PropertyDispatch.m_125294_(property).m_125335_(part -> {
            ResourceLocation model = BuiltInRegistries.f_256975_.m_7981_((Object)block).m_247266_(s -> "block/" + s + ((CurtainPart)((Object)part)).getModelName());
            if (((CurtainPart)((Object)part)).getModelTemplate() == null) {
                model = new ResourceLocation("valhelsia_furniture", "block/curtain/curtain_bracket");
            }
            return Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)model);
        });
        if (block instanceof ClosedCurtainBlock) {
            this.delegateItemModel(block, ModelLocationUtils.m_125578_(block, (String)"_single"));
        }
        this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.m_125254_(block).m_125271_(BlockModelGenerators.m_124727_()).m_125271_(dispatch));
    }

    private static MultiVariantGenerator createSimpleBlock(Block block, ResourceLocation resourceLocation) {
        return MultiVariantGenerator.m_125256_((Block)block, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)resourceLocation));
    }

    private static PropertyDispatch createRotatedDispatch(ResourceLocation model) {
        return PropertyDispatch.m_125294_((Property)ModBlockStateProperties.ROTATED).m_125329_((Comparable)Boolean.valueOf(false), Variant.m_125501_()).m_125329_((Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)model));
    }

    void createSimpleFlatItemModel(Item item) {
        ModelTemplates.f_125658_.m_125612_(ModelLocationUtils.m_125571_((Item)item), TextureMapping.m_125766_((Item)item), this.modelOutput);
    }

    void delegateItemModel(Block block, ResourceLocation resourceLocation) {
        this.modelOutput.accept(ModelLocationUtils.m_125571_((Item)block.m_5456_()), (Supplier<JsonElement>)new DelegatedModel(resourceLocation));
    }
}

