/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.usefulspyglass;

import com.brokenkeyboard.usefulspyglass.TooltipInfo;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class DrawOverlay {
    private static final Minecraft CLIENT = Minecraft.m_91087_();
    private static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");

    public static void drawGUI(GuiGraphics graphics, HitResult result, List<TooltipInfo> tooltipList, int rectX, int rectY, int rectW, int rectH) {
        graphics.m_280168_().m_85836_();
        graphics.m_286007_(() -> TooltipRenderUtil.m_280205_((GuiGraphics)graphics, (int)rectX, (int)rectY, (int)rectW, (int)rectH, (int)400));
        if (result instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)result;
            if (DrawOverlay.CLIENT.f_91074_ != null) {
                BlockState state = DrawOverlay.CLIENT.f_91074_.m_9236_().m_8055_(blockHit.m_82425_());
                ItemStack stack = state.m_60734_().m_7397_((BlockGetter)DrawOverlay.CLIENT.f_91074_.m_9236_(), blockHit.m_82425_(), state);
                DrawOverlay.renderStack(graphics, stack, null, rectX, rectY + rectH / 2 - 8);
            }
        }
        int yOffset = rectY;
        for (TooltipInfo info : tooltipList) {
            if (info instanceof TooltipInfo.TextTooltip) {
                TooltipInfo.TextTooltip infoLine = (TooltipInfo.TextTooltip)info;
                DrawOverlay.renderText(graphics, infoLine.TOOLTIP, rectX, yOffset);
            } else if (info instanceof TooltipInfo.MobInfo) {
                TooltipInfo.MobInfo infoLine = (TooltipInfo.MobInfo)info;
                int xOffset = rectX;
                for (Map.Entry<TooltipInfo.Icon, ClientTooltipComponent> entry : infoLine.MOB_INFO.entrySet()) {
                    if (entry.getKey() == TooltipInfo.Icon.HEALTH) {
                        DrawOverlay.renderIcon(graphics, xOffset, yOffset, TooltipInfo.Icon.HEALTH_EMPTY.ICON_X, TooltipInfo.Icon.HEALTH_EMPTY.ICON_Y);
                    }
                    DrawOverlay.renderIcon(graphics, xOffset, yOffset, entry.getKey().ICON_X, entry.getKey().ICON_Y);
                    DrawOverlay.renderText(graphics, entry.getValue(), xOffset += entry.getKey().ICON_WIDTH + 2, yOffset + 1);
                    xOffset += entry.getValue().m_142069_(DrawOverlay.CLIENT.f_91062_) + 2;
                }
            } else if (info instanceof TooltipInfo.BlockInfo) {
                int n;
                TooltipInfo.BlockInfo infoLine = (TooltipInfo.BlockInfo)info;
                if (tooltipList.size() == 1) {
                    int n2 = yOffset + rectH / 2;
                    Objects.requireNonNull(DrawOverlay.CLIENT.f_91062_);
                    n = n2 - 9 / 2;
                } else {
                    n = yOffset;
                }
                int offset = n;
                DrawOverlay.renderText(graphics, infoLine.TOOLTIP, rectX + 18, offset);
            }
            yOffset += info.getHeight();
        }
        graphics.m_280168_().m_85849_();
    }

    public static void renderText(GuiGraphics graphics, ClientTooltipComponent tooltip, int x, int y) {
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        graphics.m_280168_().m_85836_();
        tooltip.m_142440_(DrawOverlay.CLIENT.f_91062_, x, y, graphics.m_280168_().m_85850_().m_252922_(), graphics.m_280091_());
        graphics.m_280168_().m_85849_();
    }

    public static void renderIcon(GuiGraphics graphics, int x, int y, int iconX, int iconY) {
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        graphics.m_280168_().m_85836_();
        graphics.m_280218_(GUI_ICONS_LOCATION, x, y, iconX, iconY, 9, 9);
        graphics.m_280168_().m_85849_();
    }

    public static void renderStack(GuiGraphics graphics, ItemStack stack, String countText, int x, int y) {
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        graphics.m_280168_().m_85836_();
        Lighting.m_84931_();
        RenderSystem.enableDepthTest();
        graphics.m_280480_(stack, x, y);
        graphics.m_280302_(DrawOverlay.CLIENT.f_91062_, stack, x, y, countText);
        Lighting.m_84930_();
        RenderSystem.disableDepthTest();
        graphics.m_280168_().m_85849_();
    }
}

