/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core.other;

import com.teamabnormals.blueprint.core.util.BlockUtil;
import com.teamabnormals.blueprint.core.util.DataUtil;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.Pike;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class UADispenseBehaviorRegistry {
    static DispenseItemBehavior bucketFishItemBehavior = new DefaultDispenseItemBehavior(){

        protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
            BlockPos blockPos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            ServerLevel world = source.m_7727_();
            List entities = world.m_45976_(WaterAnimal.class, new AABB(blockPos));
            if (!entities.isEmpty()) {
                for (WaterAnimal mob : entities) {
                    if (mob instanceof AbstractFish) {
                        ItemStack bucket = ((AbstractFish)mob).m_28282_();
                        mob.m_146870_();
                        world.m_5594_(null, blockPos, SoundEvents.f_11782_, SoundSource.BLOCKS, 0.5f, 1.0f);
                        return bucket;
                    }
                    if (mob instanceof Bucketable) {
                        Bucketable bucketable = (Bucketable)mob;
                        ItemStack bucket = bucketable.m_28282_();
                        if (mob instanceof Pike) {
                            CompoundTag nbt = bucket.m_41784_();
                            CompoundTag compoundnbt1 = new CompoundTag();
                            nbt.m_128405_("BucketVariantTag", ((Pike)mob).getPikeType().id);
                            if (!mob.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
                                mob.m_6844_(EquipmentSlot.MAINHAND).m_41739_(compoundnbt1);
                            }
                            nbt.m_128365_("PikeHeldItem", (Tag)compoundnbt1);
                            nbt.m_128379_("ShouldDropItem", ((Pike)mob).shouldDropItem());
                        }
                        mob.m_146870_();
                        world.m_5594_(null, blockPos, SoundEvents.f_11782_, SoundSource.BLOCKS, 0.5f, 1.0f);
                        return bucket;
                    }
                    if (!(mob instanceof Squid)) continue;
                    ItemStack bucket = new ItemStack((ItemLike)UAItems.SQUID_BUCKET.get());
                    if (mob.m_8077_()) {
                        bucket.m_41714_(mob.m_7770_());
                    }
                    mob.m_146870_();
                    world.m_5594_(null, blockPos, SoundEvents.f_11782_, SoundSource.BLOCKS, 0.5f, 1.0f);
                    return bucket;
                }
            }
            return stack;
        }
    };

    public static void registerDispenseBehaviors() {
        DefaultDispenseItemBehavior fishBucketDispenseBehavior = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            public ItemStack m_7498_(BlockSource source, ItemStack stack) {
                DispensibleContainerItem item = (DispensibleContainerItem)stack.m_41720_();
                BlockPos blockpos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                ServerLevel level = source.m_7727_();
                if (item.m_142073_(null, (Level)level, blockpos, null)) {
                    item.m_142131_(null, (Level)level, stack, blockpos);
                    return new ItemStack((ItemLike)Items.f_42446_);
                }
                return this.defaultDispenseItemBehavior.m_6115_(source, stack);
            }
        };
        DispenserBlock.m_52672_((ItemLike)((ItemLike)UAItems.NAUTILUS_BUCKET.get()), (DispenseItemBehavior)fishBucketDispenseBehavior);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)UAItems.PIKE_BUCKET.get()), (DispenseItemBehavior)fishBucketDispenseBehavior);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)UAItems.LIONFISH_BUCKET.get()), (DispenseItemBehavior)fishBucketDispenseBehavior);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)UAItems.SQUID_BUCKET.get()), (DispenseItemBehavior)fishBucketDispenseBehavior);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)UAItems.GLOW_SQUID_BUCKET.get()), (DispenseItemBehavior)fishBucketDispenseBehavior);
        DataUtil.registerAlternativeDispenseBehavior((DataUtil.AlternativeDispenseBehavior)new DataUtil.AlternativeDispenseBehavior("upgrade_aquatic", Items.f_42447_, (source, stack) -> !BlockUtil.getEntitiesAtOffsetPos((BlockSource)source, WaterAnimal.class, entity -> entity instanceof AbstractFish || entity instanceof Bucketable || entity instanceof Squid).isEmpty(), bucketFishItemBehavior));
    }
}

