/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core.mixin;

import com.teamabnormals.upgrade_aquatic.core.UAConfig;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BubbleColumnBlock.class})
public abstract class BubbleColumnBlockMixin {
    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random, CallbackInfo info) {
        if (!((Boolean)state.m_61143_((Property)BubbleColumnBlock.f_50956_)).booleanValue() && ((Boolean)UAConfig.COMMON.renewableSandRequiresMagmaBlocks.get()).booleanValue()) {
            return;
        }
        BlockPos abovePos = pos.m_7494_();
        Block aboveBlock = world.m_8055_(abovePos).m_60734_();
        boolean noFallingBlockAbove = world.m_45976_(FallingBlockEntity.class, new AABB(pos)).isEmpty();
        if (noFallingBlockAbove) {
            if (((Boolean)UAConfig.COMMON.renewableSand.get()).booleanValue()) {
                UABlocks.SAND_FALLABLES.forEach((inputBlock, outputBlock) -> {
                    if (inputBlock.get() == aboveBlock) {
                        this.spawnFallingBlock(world, pos, (Block)outputBlock.get());
                    }
                });
                if (UABlocks.ATMOSPHERIC_SAND_FALLABLES != null) {
                    UABlocks.ATMOSPHERIC_SAND_FALLABLES.forEach((inputBlock, outputBlock) -> {
                        if (inputBlock.get() == aboveBlock) {
                            this.spawnFallingBlock(world, pos, (Block)outputBlock.get());
                        }
                    });
                }
            }
            if (((Boolean)UAConfig.COMMON.renewableGravel.get()).booleanValue()) {
                UABlocks.GRAVEL_FALLABLES.forEach((inputBlock, outputBlock) -> {
                    if (inputBlock.get() == aboveBlock) {
                        this.spawnFallingBlock(world, pos, (Block)outputBlock.get());
                    }
                });
            }
        }
    }

    private void spawnFallingBlock(ServerLevel world, BlockPos pos, Block block) {
        FallingBlockEntity fallingblockentity = FallingBlockEntity.m_201971_((Level)world, (BlockPos)pos, (BlockState)block.m_49966_());
        fallingblockentity.f_31942_ = 1;
        world.m_7967_((Entity)fallingblockentity);
    }
}

