/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class JellyTorchParticle
extends TextureSheetParticle {
    protected final SpriteSet animatedSprite;
    private final float rotSpeed;
    private final float scale;
    private final int MAX_FRAME_ID = 2;
    protected int currentFrame = 0;
    private boolean directionRight = true;
    private int lastTick = 0;

    public JellyTorchParticle(SpriteSet animatedSprite, ClientLevel world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        super(world, posX, posY, posZ, motionX, motionY, motionZ);
        this.f_107215_ = this.f_107215_ * (double)0.01f + motionX;
        this.f_107216_ = this.f_107216_ * (double)0.01f + motionY;
        this.f_107217_ = this.f_107217_ * (double)0.01f + motionZ;
        this.f_107663_ = 0.25f;
        this.scale = 0.25f;
        this.rotSpeed = ((float)Math.random() - 0.5f) * 0.1f;
        this.f_107231_ = (float)Math.random() * ((float)Math.PI * 2);
        this.f_107226_ = 0.0f;
        this.f_107227_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107229_ = 1.0f;
        this.f_107225_ = (int)(12.0 / (Math.random() * 0.8 + 0.2)) + 4;
        this.animatedSprite = animatedSprite;
        this.m_108339_(animatedSprite);
    }

    public void m_5744_(VertexConsumer p_225606_1_, Camera activeInfo, float partialTicks) {
        Entity entity = activeInfo.m_90592_();
        if (entity.f_19797_ >= this.lastTick + 5) {
            if (this.currentFrame == 2) {
                this.directionRight = false;
            } else if (this.currentFrame == 0) {
                this.directionRight = true;
            }
            this.currentFrame += this.directionRight ? 1 : -1;
            this.lastTick = entity.f_19797_;
        }
        float f = ((float)this.f_107224_ + partialTicks) / (float)this.f_107225_;
        this.f_107663_ = this.scale * (1.0f - f * f * 0.5f);
        super.m_5744_(p_225606_1_, activeInfo, partialTicks);
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107204_ = this.f_107231_;
        this.f_107231_ += (float)Math.PI * this.rotSpeed * 2.0f;
        if (this.f_107218_) {
            this.f_107231_ = 0.0f;
            this.f_107204_ = 0.0f;
        }
        if (this.m_107276_()) {
            this.m_108339_(this.animatedSprite);
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public int m_6355_(float partialTick) {
        float f = ((float)this.f_107224_ + partialTick) / (float)this.f_107225_;
        f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
        int i = super.m_6355_(partialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet animatedSprite;

        public Factory(SpriteSet animatedSprite) {
            this.animatedSprite = animatedSprite;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new JellyTorchParticle(this.animatedSprite, world, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

