/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.gui;

import com.google.common.collect.Lists;
import com.tom.storagemod.Content;
import com.tom.storagemod.gui.IForgeMenu;
import com.tom.storagemod.gui.StorageTerminalMenu;
import com.tom.storagemod.tile.CraftingTerminalBlockEntity;
import com.tom.storagemod.util.IAutoFillTerminal;
import com.tom.storagemod.util.IDataReceiver;
import com.tom.storagemod.util.StoredItemStack;
import com.tom.storagemod.util.TerminalCraftingFiller;
import com.tom.storagemod.util.TerminalRecipePlacer;
import java.util.List;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;

public class CraftingTerminalMenu
extends StorageTerminalMenu
implements IAutoFillTerminal,
IDataReceiver,
IForgeMenu {
    private final CraftingContainer craftMatrix;
    private final ResultContainer craftResult;
    private Slot craftingResultSlot;
    private final List<ContainerListener> listeners = Lists.newArrayList();

    public void m_38893_(ContainerListener listener) {
        super.m_38893_(listener);
        this.listeners.add(listener);
    }

    public void m_38943_(ContainerListener listener) {
        super.m_38943_(listener);
        this.listeners.remove(listener);
    }

    public CraftingTerminalMenu(int id, Inventory inv, CraftingTerminalBlockEntity te) {
        super(Content.craftingTerminalCont.get(), id, inv, te);
        this.craftMatrix = te.getCraftingInv();
        this.craftResult = te.getCraftResult();
        this.init();
        this.addPlayerSlots(inv, 8, 174);
        te.registerCrafting(this);
    }

    public CraftingTerminalMenu(int id, Inventory inv) {
        super(Content.craftingTerminalCont.get(), id, inv);
        this.craftMatrix = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
        this.craftResult = new ResultContainer();
        this.init();
        this.addPlayerSlots(inv, 8, 174);
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        if (this.te != null) {
            ((CraftingTerminalBlockEntity)this.te).unregisterCrafting(this);
        }
    }

    private void init() {
        int x = -4;
        int y = 94;
        this.craftingResultSlot = new Result(x + 124, y + 35);
        this.m_38897_(this.craftingResultSlot);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.m_38897_(new SlotCrafting((Container)this.craftMatrix, j + i * 3, x + 30 + j * 18, y + 17 + i * 18));
            }
        }
    }

    @Override
    protected void addStorageSlots() {
        this.addStorageSlots(5, 8, 18);
    }

    public boolean m_5882_(ItemStack stack, Slot slotIn) {
        return slotIn.f_40218_ != this.craftResult && super.m_5882_(stack, slotIn);
    }

    @Override
    public ItemStack shiftClickItems(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == 0) {
                if (this.te == null) {
                    return ItemStack.f_41583_;
                }
                if (!((CraftingTerminalBlockEntity)this.te).canCraft() || !this.m_38903_(itemstack1, 10, 46, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
                if (itemstack1.m_41619_()) {
                    slot.m_5852_(ItemStack.f_41583_);
                } else {
                    slot.m_6654_();
                }
                if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                    return ItemStack.f_41583_;
                }
                slot.m_142406_(playerIn, itemstack1);
                if (index == 0) {
                    playerIn.m_36176_(itemstack1, false);
                }
                return itemstack;
            }
            if (index > 0 && index < 10) {
                if (this.te == null) {
                    return ItemStack.f_41583_;
                }
                ItemStack stack = ((CraftingTerminalBlockEntity)this.te).pushStack(itemstack);
                slot.m_5852_(stack);
                if (!playerIn.m_9236_().f_46443_) {
                    this.m_38946_();
                }
            }
            slot.m_142406_(playerIn, itemstack1);
        }
        return ItemStack.f_41583_;
    }

    public void onCraftMatrixChanged() {
        for (int i = 0; i < this.f_38839_.size(); ++i) {
            Slot slot = (Slot)this.f_38839_.get(i);
            if (!(slot instanceof SlotCrafting) && slot != this.craftingResultSlot) continue;
            for (ContainerListener listener : this.listeners) {
                if (!(listener instanceof ServerPlayer)) continue;
                ((ServerPlayer)listener).f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.f_38840_, this.m_182425_(), i, slot.m_7993_()));
            }
        }
    }

    public boolean m_6366_(Player playerIn, int id) {
        if (this.te != null && id == 0) {
            ((CraftingTerminalBlockEntity)this.te).clear(playerIn);
        } else if (this.te != null && id == 1) {
            ((CraftingTerminalBlockEntity)this.te).polymorphUpdate();
        } else {
            super.m_6366_(playerIn, id);
        }
        return false;
    }

    @Override
    public void m_5816_(StackedContents itemHelperIn) {
        this.craftMatrix.m_5809_(itemHelperIn);
        if (this.te != null) {
            this.sync.fillStackedContents(itemHelperIn);
        } else {
            this.itemList.forEach(e -> itemHelperIn.m_36466_(e.getActualStack()));
        }
    }

    @Override
    public void m_6650_() {
        this.craftMatrix.m_6211_();
        this.craftResult.m_6211_();
    }

    @Override
    public boolean m_6032_(Recipe<? super CraftingContainer> recipeIn) {
        return recipeIn.m_5818_((Container)this.craftMatrix, this.pinv.f_35978_.m_9236_());
    }

    @Override
    public int m_6636_() {
        return 0;
    }

    @Override
    public int m_6635_() {
        return this.craftMatrix.m_39347_();
    }

    @Override
    public int m_6656_() {
        return this.craftMatrix.m_39346_();
    }

    @Override
    public int m_6653_() {
        return 10;
    }

    @Override
    public List<RecipeBookCategories> getRecipeBookCategories() {
        return Lists.newArrayList((Object[])new RecipeBookCategories[]{RecipeBookCategories.CRAFTING_SEARCH, RecipeBookCategories.CRAFTING_EQUIPMENT, RecipeBookCategories.CRAFTING_BUILDING_BLOCKS, RecipeBookCategories.CRAFTING_MISC, RecipeBookCategories.CRAFTING_REDSTONE});
    }

    public TerminalRecipePlacer getRecipePlacer() {
        return new TerminalRecipePlacer(this, (CraftingTerminalBlockEntity)this.te, this.pinv.f_35978_);
    }

    @Override
    public void receive(CompoundTag message) {
        Recipe recipe;
        ResourceLocation id;
        super.receive(message);
        if (message.m_128441_("fill") && (id = ResourceLocation.m_135820_((String)message.m_128461_("fill"))) != null && (recipe = (Recipe)this.pinv.f_35978_.m_9236_().m_7465_().m_44043_(id).orElse(null)) != null) {
            new TerminalCraftingFiller((CraftingTerminalBlockEntity)this.te, this.pinv.f_35978_, this.sync).placeRecipe(recipe);
        }
    }

    @Override
    public List<StoredItemStack> getStoredItems() {
        return this.itemList;
    }

    public Slot getCraftingResultSlot() {
        return this.craftingResultSlot;
    }

    public Player getPlayer() {
        return this.pinv.f_35978_;
    }

    private class Result
    extends ResultSlot {
        public Result(int x, int y) {
            super(CraftingTerminalMenu.this.pinv.f_35978_, CraftingTerminalMenu.this.craftMatrix, (Container)CraftingTerminalMenu.this.craftResult, 0, x, y);
        }

        public void m_142406_(Player thePlayer, ItemStack stack) {
            this.m_5845_(stack);
            if (!CraftingTerminalMenu.this.pinv.f_35978_.m_20193_().f_46443_) {
                ((CraftingTerminalBlockEntity)CraftingTerminalMenu.this.te).craft(thePlayer);
            }
        }
    }

    public static class SlotCrafting
    extends Slot {
        public SlotCrafting(Container inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }
    }
}

