/*
 * Decompiled with CFR 0.152.
 */
package net.thal0rin.titlebarchanger.utils;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.WinDef;
import java.util.Arrays;
import java.util.List;
import net.thal0rin.titlebarchanger.TitlebarChanger;

public enum SystemStatus {
    SUITABLE,
    LIMITED_SUITABILITY,
    NOT_SUITABLE;


    public static SystemStatus checkSystem() {
        try {
            OSVERSIONINFOEX.ByReference osVersionInfo = new OSVERSIONINFOEX.ByReference();
            osVersionInfo.dwOSVersionInfoSize.setValue((long)osVersionInfo.size());
            int result = Ntdll.INSTANCE.RtlGetVersion(osVersionInfo);
            if (result != 0) {
                TitlebarChanger.LOGGER.error("Failed to retrieve OS version info, error code: {}", (Object)result);
                return NOT_SUITABLE;
            }
            int major = osVersionInfo.dwMajorVersion.intValue();
            int build = osVersionInfo.dwBuildNumber.intValue();
            if (major == 10 && build >= 22000) {
                TitlebarChanger.LOGGER.info("Detected Windows 11, build number {}.{}", (Object)major, (Object)build);
                return SUITABLE;
            }
            if (major == 10) {
                TitlebarChanger.LOGGER.warn("Detected Windows 10, build number {}.{}. Some features may be limited.", (Object)major, (Object)build);
                return LIMITED_SUITABILITY;
            }
            TitlebarChanger.LOGGER.error("Unsupported OS version: {}.{}. This mod requires Windows 10 or later.", (Object)major, (Object)build);
            return NOT_SUITABLE;
        }
        catch (Exception e) {
            TitlebarChanger.LOGGER.error("An error occurred while checking the system version: {}", (Object)e.getMessage());
            return NOT_SUITABLE;
        }
    }

    public static class OSVERSIONINFOEX
    extends Structure {
        public WinDef.DWORD dwOSVersionInfoSize = new WinDef.DWORD();
        public WinDef.DWORD dwMajorVersion = new WinDef.DWORD();
        public WinDef.DWORD dwMinorVersion = new WinDef.DWORD();
        public WinDef.DWORD dwBuildNumber = new WinDef.DWORD();
        public WinDef.DWORD dwPlatformId = new WinDef.DWORD();
        public byte[] szCSDVersion = new byte[128];
        public WinDef.WORD wServicePackMajor = new WinDef.WORD();
        public WinDef.WORD wServicePackMinor = new WinDef.WORD();
        public WinDef.WORD wSuiteMask = new WinDef.WORD();
        public byte wProductType;
        public byte wReserved;

        protected List<String> getFieldOrder() {
            return Arrays.asList("dwOSVersionInfoSize", "dwMajorVersion", "dwMinorVersion", "dwBuildNumber", "dwPlatformId", "szCSDVersion", "wServicePackMajor", "wServicePackMinor", "wSuiteMask", "wProductType", "wReserved");
        }

        public static class ByReference
        extends OSVERSIONINFOEX
        implements Structure.ByReference {
        }
    }

    public static interface Ntdll
    extends Library {
        public static final Ntdll INSTANCE = (Ntdll)Native.load((String)"ntdll", Ntdll.class);

        public int RtlGetVersion(OSVERSIONINFOEX.ByReference var1);
    }
}

