/*
 * Decompiled with CFR 0.152.
 */
package com.temporal.api.core.registry.factory.common;

import com.temporal.api.core.engine.io.EnginedRegisterFactory;
import com.temporal.api.core.registry.factory.common.TypedFactory;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ItemFactory
implements TypedFactory<Item> {
    public static final DeferredRegister<Item> ITEMS = EnginedRegisterFactory.create(Registries.f_256913_);
    private static volatile ItemFactory instance;

    public RegistryObject<Item> create(String name) {
        return this.create(name, () -> new Item(new Item.Properties()));
    }

    public RegistryObject<Item> create(String name, Item.Properties properties) {
        return this.create(name, () -> new Item(properties));
    }

    @Override
    public RegistryObject<Item> create(String name, Supplier<Item> itemSupplier) {
        return ITEMS.register(name, itemSupplier);
    }

    @Override
    public RegistryObject<? extends Item> createTyped(String name, Supplier<? extends Item> itemSupplier) {
        return ITEMS.register(name, itemSupplier);
    }

    @Override
    public void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ItemFactory getInstance() {
        if (instance != null) return instance;
        Class<ItemFactory> clazz = ItemFactory.class;
        synchronized (ItemFactory.class) {
            if (instance != null) return instance;
            instance = new ItemFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

