/*
 * Decompiled with CFR 0.152.
 */
package com.temporal.api.core.event.trade;

import com.temporal.api.core.event.trade.TradeCustomizer;
import com.temporal.api.core.event.trade.object.TradingItemHolder;
import com.temporal.api.core.event.trade.object.VillagerTrade;
import com.temporal.api.core.event.trade.object.VillagerTradeDescription;
import com.temporal.api.core.event.trade.object.WandererTrade;
import com.temporal.api.core.event.trade.object.WandererTradeDescription;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;

public class SimpleTradeCustomizer
implements TradeCustomizer {
    @Override
    public void customize(VillagerTradesEvent event, VillagerTrade villagerTrade) {
        VillagerTradeDescription tradeDescription = villagerTrade.getTradeDescription();
        if (event.getType() == tradeDescription.getVillagerProfession()) {
            Int2ObjectMap trades = event.getTrades();
            TradingItemHolder itemStack1 = villagerTrade.getHolder1();
            TradingItemHolder itemStack2 = villagerTrade.getHolder2();
            ((List)trades.get(tradeDescription.getLevel())).add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)itemStack1.getItem(), itemStack1.getItemCount()), new ItemStack((ItemLike)itemStack2.getItem(), itemStack2.getItemCount()), tradeDescription.getMaxUses(), tradeDescription.getXP(), tradeDescription.getPriceMultiplier()));
        }
    }

    @Override
    public void customize(WandererTradesEvent event, WandererTrade wandererTrade) {
        WandererTradeDescription tradeDescription = wandererTrade.getTradeDescription();
        TradingItemHolder itemStack1 = wandererTrade.getHolder1();
        TradingItemHolder itemStack2 = wandererTrade.getHolder2();
        if (tradeDescription.getTradeRarity() == WandererTradeDescription.TradeRarity.GENERIC) {
            event.getGenericTrades().add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)itemStack1.getItem(), itemStack1.getItemCount()), new ItemStack((ItemLike)itemStack2.getItem(), itemStack2.getItemCount()), tradeDescription.getMaxUses(), tradeDescription.getXP(), tradeDescription.getPriceMultiplier()));
        } else {
            event.getRareTrades().add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)itemStack1.getItem(), itemStack1.getItemCount()), new ItemStack((ItemLike)itemStack2.getItem(), itemStack2.getItemCount()), tradeDescription.getMaxUses(), tradeDescription.getXP(), tradeDescription.getPriceMultiplier()));
        }
    }
}

