/*
 * Decompiled with CFR 0.152.
 */
package com.temporal.api.core.engine;

import com.temporal.api.ApiMod;
import com.temporal.api.core.engine.EngineLayer;
import com.temporal.api.core.engine.IOLayer;
import com.temporal.api.core.engine.MetadataLayer;
import java.util.ArrayList;
import java.util.List;

public class LayerContainer {
    private static volatile LayerContainer instance;
    private final List<EngineLayer> LAYERS = new ArrayList<EngineLayer>();

    private LayerContainer() {
        this.add(new IOLayer());
        this.add(new MetadataLayer());
    }

    public void processAll(Class<?> modClass) {
        this.LAYERS.forEach(engineLayer -> {
            ApiMod.LOGGER.info("{} engine has started initialization!", (Object)engineLayer.getClass().getSimpleName().toUpperCase());
            engineLayer.processAllTasks(modClass);
            ApiMod.LOGGER.info("{} engine has finished initialization!", (Object)engineLayer.getClass().getSimpleName().toUpperCase());
        });
    }

    public void add(EngineLayer engineLayer) {
        this.LAYERS.add(engineLayer);
    }

    public void putAll(List<EngineLayer> engineLayers) {
        this.LAYERS.addAll(engineLayers);
    }

    public EngineLayer getLayer(Integer id) {
        return this.LAYERS.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LayerContainer getInstance() {
        if (instance != null) return instance;
        Class<LayerContainer> clazz = LayerContainer.class;
        synchronized (LayerContainer.class) {
            if (instance != null) return instance;
            instance = new LayerContainer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

