/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.screens.piece_figure.util;

import andrews.table_top_craft.screens.piece_figure.util.IColorPicker;
import andrews.table_top_craft.screens.piece_figure.util.IColorPickerExtended;
import andrews.table_top_craft.util.Color;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class TTCColorPicker
extends AbstractSliderButton {
    private static final ResourceLocation COLOR_CHART = new ResourceLocation("table_top_craft:textures/gui/color_picker/color_chart.png");
    private static final ResourceLocation SATURATION_CHART = new ResourceLocation("table_top_craft:textures/gui/color_picker/saturation_chart.png");
    private final Screen screen;
    private final Color color;
    private double valueY;

    public TTCColorPicker(int xPos, int yPos, Screen screen, double valueX, double valueY) {
        super(xPos, yPos, 128, 128, (Component)Component.m_237113_((String)""), valueX);
        this.screen = screen;
        this.valueY = valueY;
        this.color = new Color(0, 0, 0);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        float f;
        boolean flagY;
        boolean flagX = keyCode == 263;
        boolean bl = flagY = keyCode == 265;
        if (flagX || keyCode == 262) {
            f = flagX ? -1.0f : 1.0f;
            this.f_93577_ = this.snapToNearest(this.f_93577_ + (double)f * 0.0027777777777778);
            this.m_5695_();
            this.updateRGBHSVSliders();
        }
        if (flagY || keyCode == 264) {
            f = flagY ? -1.0f : 1.0f;
            this.valueY = this.snapToNearest(this.valueY + (double)f * 0.0027777777777778);
            this.m_5695_();
            this.updateRGBHSVSliders();
        }
        return false;
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)this.f_93620_, (float)this.f_93621_, 0.0f);
        graphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280218_(COLOR_CHART, 0, 0, 0, 0, 256, 256);
        RenderSystem.enableBlend();
        Screen screen = this.screen;
        if (screen instanceof IColorPicker) {
            IColorPicker colorPicker = (IColorPicker)screen;
            graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f - (float)colorPicker.getSaturationSlider().getValueInt() / 100.0f);
        }
        graphics.m_280218_(SATURATION_CHART, 0, 0, 0, 0, 256, 256);
        RenderSystem.disableBlend();
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280168_().m_85849_();
        int begTexOffset = 1;
        int destTexOffset = 2;
        int xPosition = this.f_93620_ + (int)(this.f_93577_ * (double)(this.f_93618_ - destTexOffset)) - begTexOffset;
        int yPosition = this.f_93621_ + (int)(this.valueY * (double)(this.f_93619_ - destTexOffset)) - begTexOffset;
        int size = 4;
        graphics.m_280027_(f_263683_, xPosition, yPosition, size, size, 2, 3, 200, 20, 0, this.m_198029_() ? 60 : 40);
    }

    public void m_7691_(double pMouseX, double pMouseY) {
    }

    protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        super.m_7212_(mouseX, mouseY, dragX, dragY);
        this.setValueFromMouse(mouseX, mouseY);
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.setSliderValue((mouseX - (double)(this.f_93620_ + 1)) / (double)(this.f_93618_ - 2), (mouseY - (double)(this.f_93621_ + 1)) / (double)(this.f_93619_ - 2));
    }

    protected void m_5695_() {
        this.m_93666_((Component)Component.m_237113_((String)""));
    }

    public void setValueX(double value) {
        this.f_93577_ = this.snapToNearest(value /= 360.0);
        this.m_5695_();
    }

    public Color getColor() {
        float colorHue = (float)(this.f_93577_ * 360.0);
        float colorSaturation = 1.0f;
        Screen screen = this.screen;
        if (screen instanceof IColorPicker) {
            IColorPicker colorPicker = (IColorPicker)screen;
            colorSaturation = (float)colorPicker.getSaturationSlider().getValueInt() / 100.0f;
        }
        float colorValue = 1.0f - (float)this.valueY;
        return this.color.fromHSV(colorHue, colorSaturation, colorValue);
    }

    private void setValueFromMouse(double mouseX, double mouseY) {
        this.setSliderValue((mouseX - (double)(this.f_93620_ + 1)) / (double)(this.f_93618_ - 2), (mouseY - (double)(this.f_93621_ + 1)) / (double)(this.f_93619_ - 2));
    }

    private void setSliderValue(double mouseX, double mouseY) {
        double oldValueX = this.f_93577_;
        double oldValueY = this.valueY;
        this.f_93577_ = this.snapToNearest(mouseX);
        if (!Mth.m_14082_((double)oldValueX, (double)this.f_93577_)) {
            this.m_5697_();
        }
        this.valueY = this.snapToNearest(mouseY);
        if (!Mth.m_14082_((double)oldValueY, (double)this.valueY)) {
            this.m_5697_();
        }
        this.m_5695_();
        this.updateRGBHSVSliders();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateRGBHSVSliders() {
        Color color = this.getColor();
        Screen screen = this.screen;
        if (screen instanceof IColorPicker) {
            IColorPicker colorPicker = (IColorPicker)screen;
            screen = this.screen;
            if (screen instanceof IColorPickerExtended) {
                IColorPickerExtended colorPickerExtended = (IColorPickerExtended)screen;
                if (colorPicker.isColorPickerActive()) {
                    colorPicker.getRedSlider().m_93611_((double)color.getRed());
                    colorPicker.getGreenSlider().m_93611_((double)color.getGreen());
                    colorPicker.getBlueSlider().m_93611_((double)color.getBlue());
                }
                if (!colorPickerExtended.isOptionalColorPickerActive()) return;
                colorPickerExtended.getOptionalRedSlider().m_93611_((double)color.getRed());
                colorPickerExtended.getOptionalGreenSlider().m_93611_((double)color.getGreen());
                colorPickerExtended.getOptionalBlueSlider().m_93611_((double)color.getBlue());
                return;
            }
        }
        if (!((screen = this.screen) instanceof IColorPicker)) return;
        IColorPicker colorPicker = (IColorPicker)screen;
        colorPicker.getRedSlider().m_93611_((double)color.getRed());
        colorPicker.getGreenSlider().m_93611_((double)color.getGreen());
        colorPicker.getBlueSlider().m_93611_((double)color.getBlue());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateColorPickerFromSliders() {
        Screen red2;
        Screen screen = this.screen;
        if (screen instanceof IColorPicker) {
            IColorPicker colorPicker = (IColorPicker)screen;
            screen = this.screen;
            if (screen instanceof IColorPickerExtended) {
                IColorPickerExtended colorPickerExtended = (IColorPickerExtended)screen;
                int red2 = colorPicker.getRedSlider().getValueInt();
                int green = colorPicker.getGreenSlider().getValueInt();
                int blue = colorPicker.getBlueSlider().getValueInt();
                if (colorPickerExtended.isOptionalColorPickerActive()) {
                    red2 = colorPickerExtended.getOptionalRedSlider().getValueInt();
                    green = colorPickerExtended.getOptionalGreenSlider().getValueInt();
                    blue = colorPickerExtended.getOptionalBlueSlider().getValueInt();
                }
                Color color = new Color(red2, green, blue);
                this.setValueX(color.getHue());
                this.setValueY(1.0f - color.getValue());
                colorPicker.getSaturationSlider().m_93611_((double)(color.getSaturation() * 100.0f));
                return;
            }
        }
        if (!((red2 = this.screen) instanceof IColorPicker)) return;
        IColorPicker colorPicker = (IColorPicker)red2;
        int red2 = colorPicker.getRedSlider().getValueInt();
        int green = colorPicker.getGreenSlider().getValueInt();
        int blue = colorPicker.getBlueSlider().getValueInt();
        Color color = new Color(red2, green, blue);
        this.setValueX(color.getHue());
        this.setValueY(1.0f - color.getValue());
        colorPicker.getSaturationSlider().m_93611_((double)(color.getSaturation() * 100.0f));
    }

    private double snapToNearest(double value) {
        double stepSize = 0.0027777777777778;
        double minValue = 0.0;
        double maxValue = 1.0;
        value = Mth.m_14139_((double)Mth.m_14008_((double)value, (double)0.0, (double)1.0), (double)minValue, (double)maxValue);
        value = stepSize * (double)Math.round(value / stepSize);
        value = Mth.m_14008_((double)value, (double)minValue, (double)maxValue);
        return Mth.m_144914_((double)value, (double)minValue, (double)maxValue, (double)0.0, (double)1.0);
    }

    public void setValueY(double value) {
        this.valueY = this.snapToNearest(value);
        this.m_5695_();
    }

    protected void m_5697_() {
    }
}

