/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.screens.chess.menus.color_selection;

import andrews.table_top_craft.block_entities.ChessBlockEntity;
import andrews.table_top_craft.screens.base.BaseScreen;
import andrews.table_top_craft.screens.chess.buttons.ChessCancelButton;
import andrews.table_top_craft.screens.chess.buttons.colors.ChessConfirmColorButton;
import andrews.table_top_craft.screens.chess.buttons.colors.ChessRandomColorButton;
import andrews.table_top_craft.screens.chess.buttons.colors.ChessResetColorButton;
import andrews.table_top_craft.screens.chess.sliders.ChessAlphaColorSlider;
import andrews.table_top_craft.screens.chess.sliders.ChessBlueColorSlider;
import andrews.table_top_craft.screens.chess.sliders.ChessGreenColorSlider;
import andrews.table_top_craft.screens.chess.sliders.ChessRedColorSlider;
import andrews.table_top_craft.screens.piece_figure.util.ColorPickerToggleButton;
import andrews.table_top_craft.screens.piece_figure.util.IColorPicker;
import andrews.table_top_craft.screens.piece_figure.util.SaturationSlider;
import andrews.table_top_craft.screens.piece_figure.util.TTCColorPicker;
import andrews.table_top_craft.util.Color;
import andrews.table_top_craft.util.NBTColorSaving;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.gui.widget.ForgeSlider;

public class ChessBoardInvalidMoveColorScreen
extends BaseScreen
implements IColorPicker {
    private static final ResourceLocation TEXTURE = new ResourceLocation("table_top_craft", "textures/gui/menus/medium_chess_menu.png");
    private static final ResourceLocation PREVIEW_TEXTURE = new ResourceLocation("table_top_craft", "textures/gui/menus/preview_color.png");
    private static final ResourceLocation COLOR_PICKER_FRAME_TEXTURE = new ResourceLocation("table_top_craft", "textures/gui/color_picker/color_picker_frame.png");
    private static final Component TITLE = Component.m_237115_((String)"gui.table_top_craft.chess.color.invalid_move");
    private static final Component PREVIEW_COLOR_TXT = Component.m_237115_((String)"gui.table_top_craft.chess.color.color_preview");
    private final ChessBlockEntity chessBlockEntity;
    private final boolean isColorPickerActive;
    private ChessAlphaColorSlider alphaColorSlider;
    private ChessRedColorSlider redColorSlider;
    private ChessGreenColorSlider greenColorSlider;
    private ChessBlueColorSlider blueColorSlider;
    private TTCColorPicker colorPicker;
    private SaturationSlider saturationSlider;

    public ChessBoardInvalidMoveColorScreen(ChessBlockEntity chessBlockEntity, boolean isColorPickerActive) {
        super(TEXTURE, 177, 131, TITLE);
        this.chessBlockEntity = chessBlockEntity;
        this.isColorPickerActive = isColorPickerActive;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new ColorPickerToggleButton(this.chessBlockEntity, this, false, this.x + 48, this.y + 47));
        this.redColorSlider = new ChessRedColorSlider(this.x + 5, this.y + 61, 167, 12, NBTColorSaving.getRed(this.chessBlockEntity.getInvalidMoveColor()), this);
        this.m_142416_((GuiEventListener)this.redColorSlider);
        this.greenColorSlider = new ChessGreenColorSlider(this.x + 5, this.y + 74, 167, 12, NBTColorSaving.getGreen(this.chessBlockEntity.getInvalidMoveColor()), this);
        this.m_142416_((GuiEventListener)this.greenColorSlider);
        this.blueColorSlider = new ChessBlueColorSlider(this.x + 5, this.y + 87, 167, 12, NBTColorSaving.getBlue(this.chessBlockEntity.getInvalidMoveColor()), this);
        this.m_142416_((GuiEventListener)this.blueColorSlider);
        this.alphaColorSlider = new ChessAlphaColorSlider(this.x + 5, this.y + 100, 167, 12, NBTColorSaving.getAlpha(this.chessBlockEntity.getInvalidMoveColor()));
        this.m_142416_((GuiEventListener)this.alphaColorSlider);
        this.m_142416_((GuiEventListener)new ChessRandomColorButton(this, this.x + 69, this.y + 33));
        this.m_142416_((GuiEventListener)new ChessResetColorButton(ChessResetColorButton.DefaultColorType.INVALID_MOVE, this, this.x + 69, this.y + 47));
        this.m_142416_((GuiEventListener)new ChessCancelButton(this.chessBlockEntity, ChessCancelButton.ChessCancelMenuTarget.CHESS_BOARD_COLORS, ChessCancelButton.ChessCancelButtonText.CANCEL, this.x + 5, this.y + 113));
        this.m_142416_((GuiEventListener)new ChessConfirmColorButton(ChessConfirmColorButton.ColorMenuType.INVALID_MOVE, this.chessBlockEntity, this.redColorSlider, this.greenColorSlider, this.blueColorSlider, this.alphaColorSlider, this.x + 90, this.y + 113));
        if (this.isColorPickerActive) {
            Color color = new Color(this.redColorSlider.getValueInt(), this.greenColorSlider.getValueInt(), this.blueColorSlider.getValueInt());
            this.colorPicker = new TTCColorPicker(this.x - 131, this.y - 5, this, color.getHue() / 360.0f, 1.0f - color.getValue());
            this.m_142416_((GuiEventListener)this.colorPicker);
            float saturation = color.getSaturation() * 100.0f;
            this.saturationSlider = new SaturationSlider(this.x - 132, this.y + 125, 130, 12, Math.round(saturation), this);
            this.m_142416_((GuiEventListener)this.saturationSlider);
        }
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.isColorPickerActive) {
            graphics.m_280218_(COLOR_PICKER_FRAME_TEXTURE, this.x - 136, this.y - 10, 0, 0, 139, 151);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    @Override
    public void renderScreenContents(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.m_280218_(TEXTURE, this.x + 5, this.y + 18, 0, 131, 42, 42);
        graphics.m_280168_().m_85836_();
        graphics.m_280246_(0.003921569f * (float)this.redColorSlider.getValueInt(), 0.003921569f * (float)this.greenColorSlider.getValueInt(), 0.003921569f * (float)this.blueColorSlider.getValueInt(), 0.003921569f * (float)this.alphaColorSlider.getValueInt());
        graphics.m_280168_().m_252880_((float)(this.x + 6), (float)(this.y + 19), 0.0f);
        graphics.m_280168_().m_85841_(2.5f, 2.5f, 2.5f);
        graphics.m_280218_(PREVIEW_TEXTURE, 0, 0, 0, 0, 16, 16);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280168_().m_85849_();
        this.drawCenteredString(TITLE, this.f_96543_ / 2 + (this.isColorPickerActive ? 68 : 0), this.y + 6, 0x404040, false, graphics);
        graphics.m_280614_(this.f_96547_, PREVIEW_COLOR_TXT, this.x + 49, this.y + 18, 0, false);
    }

    @Override
    public int offsetX() {
        return this.isColorPickerActive ? 136 : super.offsetX();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        super.m_7933_(keyCode, scanCode, modifiers);
        if (this.getMinecraft().f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            this.m_7379_();
        }
        return true;
    }

    public boolean m_7043_() {
        return false;
    }

    @Override
    public TTCColorPicker getColorPicker() {
        return this.colorPicker;
    }

    @Override
    public ForgeSlider getRedSlider() {
        return this.redColorSlider;
    }

    @Override
    public ForgeSlider getGreenSlider() {
        return this.greenColorSlider;
    }

    @Override
    public ForgeSlider getBlueSlider() {
        return this.blueColorSlider;
    }

    @Override
    public ForgeSlider getSaturationSlider() {
        return this.saturationSlider;
    }

    @Override
    public boolean isColorPickerActive() {
        return this.isColorPickerActive;
    }
}

