/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.screens.chess.buttons.pieces;

import andrews.table_top_craft.block_entities.ChessBlockEntity;
import andrews.table_top_craft.block_entities.ChessPieceFigureBlockEntity;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import andrews.table_top_craft.registry.TTCBlocks;
import andrews.table_top_craft.util.NetworkUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class ChessBoardPieceModelSelectionButton
extends AbstractButton {
    private static final ResourceLocation TEXTURE = new ResourceLocation("table_top_craft:textures/gui/buttons/piece_model_selection_buttons.png");
    private static final Component DEFAULT_BTN_TXT = Component.m_237115_((String)"tooltip.table_top_craft.chess.piece_type.standard");
    private static final Component CLASSIC_BTN_TXT = Component.m_237115_((String)"tooltip.table_top_craft.chess.piece_type.classic");
    private static final Component PANDORAS_BTN_TXT = Component.m_237115_((String)"tooltip.table_top_craft.chess.piece_type.pandoras_creatures");
    private final ChessBlockEntity blockEntity;
    private final ChessPieceFigureBlockEntity chessPieceFigureBlockEntity;
    private final ItemStack chessPieceStack;
    private final BasePiece.PieceModelSet pieceModelSet;
    private final HashMap<BasePiece.PieceModelSet, Boolean> pieceSets = new HashMap();

    public ChessBoardPieceModelSelectionButton(ChessBlockEntity blockEntity, BasePiece.PieceModelSet pieceModelSet, boolean standardUnlocked, boolean classicUnlocked, boolean pandorasUnlocked, int pX, int pY) {
        super(pX, pY, 167, 37, (Component)Component.m_237113_((String)""));
        this.blockEntity = blockEntity;
        this.chessPieceFigureBlockEntity = new ChessPieceFigureBlockEntity(BlockPos.f_121853_, ((Block)TTCBlocks.CHESS_PIECE_FIGURE.get()).m_49966_());
        this.chessPieceStack = new ItemStack((ItemLike)((Block)TTCBlocks.CHESS_PIECE_FIGURE.get()).m_5456_());
        this.pieceModelSet = pieceModelSet;
        this.pieceSets.put(BasePiece.PieceModelSet.STANDARD, standardUnlocked);
        this.pieceSets.put(BasePiece.PieceModelSet.CLASSIC, classicUnlocked);
        this.pieceSets.put(BasePiece.PieceModelSet.PANDORAS_CREATURES, pandorasUnlocked);
        this.f_93623_ = !this.shouldButtonBeLocked();
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int u = 0;
        int v = this.m_198029_() && !this.shouldButtonBeLocked() ? 37 : 0;
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.enableBlend();
        graphics.m_280218_(TEXTURE, this.f_93620_, this.f_93621_, u, v, this.f_93618_, this.f_93619_);
        switch (this.pieceModelSet) {
            case STANDARD: {
                if (this.blockEntity.getPieceSet() != 0) break;
                graphics.m_280218_(TEXTURE, this.f_93620_ - 1, this.f_93621_ - 1, 0, 74, this.f_93618_ + 2, this.f_93619_ + 2);
                break;
            }
            case CLASSIC: {
                if (this.blockEntity.getPieceSet() != 1) break;
                graphics.m_280218_(TEXTURE, this.f_93620_ - 1, this.f_93621_ - 1, 0, 74, this.f_93618_ + 2, this.f_93619_ + 2);
                break;
            }
            case PANDORAS_CREATURES: {
                if (this.blockEntity.getPieceSet() != 2) break;
                graphics.m_280218_(TEXTURE, this.f_93620_ - 1, this.f_93621_ - 1, 0, 74, this.f_93618_ + 2, this.f_93619_ + 2);
            }
        }
        RenderSystem.disableBlend();
        switch (this.pieceModelSet) {
            case STANDARD: {
                graphics.m_280557_(Minecraft.m_91087_().f_91062_, DEFAULT_BTN_TXT, this.f_93620_ - 8 + (this.f_93618_ / 2 - (Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)DEFAULT_BTN_TXT) + 8) / 2), this.f_93621_ + 1);
                this.chessPieceFigureBlockEntity.setPieceSet(1);
                break;
            }
            case CLASSIC: {
                graphics.m_280557_(Minecraft.m_91087_().f_91062_, CLASSIC_BTN_TXT, this.f_93620_ - 8 + (this.f_93618_ / 2 - (Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)CLASSIC_BTN_TXT) + 8) / 2), this.f_93621_ + 1);
                this.chessPieceFigureBlockEntity.setPieceSet(2);
                break;
            }
            case PANDORAS_CREATURES: {
                graphics.m_280557_(Minecraft.m_91087_().f_91062_, PANDORAS_BTN_TXT, this.f_93620_ - 8 + (this.f_93618_ / 2 - (Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)PANDORAS_BTN_TXT) + 8) / 2), this.f_93621_ + 1);
                this.chessPieceFigureBlockEntity.setPieceSet(3);
            }
        }
        this.chessPieceFigureBlockEntity.setRotateChessPieceFigure(true);
        int scale = 32;
        for (int i = 0; i < 6; ++i) {
            this.chessPieceFigureBlockEntity.setPieceType(i + 1);
            this.chessPieceFigureBlockEntity.m_187476_(this.chessPieceStack);
            this.renderChessPiece(graphics.m_280168_(), this.chessPieceStack, this.f_93620_ + 16 + 27 * i, this.f_93621_ + 16, scale);
        }
        if (this.shouldButtonBeLocked()) {
            RenderSystem.enableBlend();
            graphics.m_280246_(1.0f, 1.0f, 1.0f, 0.85f);
            graphics.m_280218_(TEXTURE, this.f_93620_ + 1, this.f_93621_ + 11, 0, 113, 165, 15);
            graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.disableBlend();
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
            MutableComponent text = Component.m_237113_((String)"Locked");
            graphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)text, this.f_93620_ + this.f_93618_ / 4 - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)text) / 2, this.f_93621_ + 15, 0xFFFFFF, false);
            graphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)text, this.f_93620_ + this.f_93618_ / 4 * 3 - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)text) / 2, this.f_93621_ + 15, 0xFFFFFF, false);
            graphics.m_280168_().m_85849_();
        }
    }

    private void renderChessPiece(PoseStack poseStack, ItemStack itemStack, int pX, int pY, int size) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        BakedModel itemBakedModel = itemRenderer.m_174264_(itemStack, null, null, 0);
        Minecraft.m_91087_().m_91097_().m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85836_();
        poseStack.m_252880_((float)pX, (float)pY, 100.0f);
        poseStack.m_85841_(1.0f, -1.0f, 1.0f);
        poseStack.m_85841_((float)size, (float)size, (float)size);
        RenderSystem.applyModelViewMatrix();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        Lighting.m_84930_();
        itemRenderer.m_115143_(itemStack, ItemDisplayContext.GUI, false, poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, itemBakedModel);
        bufferSource.m_109911_();
        poseStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    public void m_5691_() {
        switch (this.pieceModelSet) {
            case STANDARD: {
                NetworkUtil.setChessPieceSet(this.blockEntity.m_58899_(), 0);
                break;
            }
            case CLASSIC: {
                NetworkUtil.setChessPieceSet(this.blockEntity.m_58899_(), 1);
                break;
            }
            case PANDORAS_CREATURES: {
                NetworkUtil.setChessPieceSet(this.blockEntity.m_58899_(), 2);
            }
        }
    }

    protected void m_168797_(NarrationElementOutput output) {
        this.m_168802_(output);
    }

    private boolean shouldButtonBeLocked() {
        if (Minecraft.m_91087_().f_91074_ != null && !Minecraft.m_91087_().f_91074_.m_7500_()) {
            return this.pieceSets.get((Object)this.pieceModelSet) == false;
        }
        return false;
    }
}

