/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.objects.blocks;

import andrews.table_top_craft.block_entities.ChessBlockEntity;
import andrews.table_top_craft.screens.chess.menus.ChessBoardSettingsScreen;
import andrews.table_top_craft.screens.chess.menus.ChessPawnPromotionScreen;
import andrews.table_top_craft.util.NetworkUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChessBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty SHOW_PLATE = BooleanProperty.m_61465_((String)"show_plate");
    private static final VoxelShape TOP_PLATE = Block.m_49796_((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape LEG1 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)4.0, (double)2.0);
    private static final VoxelShape LEG2 = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)2.0);
    private static final VoxelShape LEG3 = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)4.0, (double)16.0);
    private static final VoxelShape LEG4 = Block.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)4.0, (double)16.0);
    private static final VoxelShape X_SIDE1 = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)6.0, (double)11.0, (double)1.0);
    private static final VoxelShape X_SIDE2 = Block.m_49796_((double)10.0, (double)4.0, (double)0.0, (double)16.0, (double)11.0, (double)1.0);
    private static final VoxelShape X_BAR1 = Block.m_49796_((double)6.0, (double)4.0, (double)0.0, (double)10.0, (double)5.0, (double)1.0);
    private static final VoxelShape X_SIDE3 = Block.m_49796_((double)0.0, (double)4.0, (double)15.0, (double)6.0, (double)11.0, (double)16.0);
    private static final VoxelShape X_SIDE4 = Block.m_49796_((double)10.0, (double)4.0, (double)15.0, (double)16.0, (double)11.0, (double)16.0);
    private static final VoxelShape X_BAR2 = Block.m_49796_((double)6.0, (double)4.0, (double)15.0, (double)10.0, (double)5.0, (double)16.0);
    private static final VoxelShape X_STORAGE1 = Block.m_49796_((double)0.0, (double)4.0, (double)1.0, (double)6.0, (double)5.0, (double)15.0);
    private static final VoxelShape X_STORAGE2 = Block.m_49796_((double)10.0, (double)4.0, (double)1.0, (double)16.0, (double)5.0, (double)15.0);
    private static final VoxelShape X_INSIDE_WALL1 = Block.m_49796_((double)5.0, (double)5.0, (double)1.0, (double)6.0, (double)11.0, (double)15.0);
    private static final VoxelShape X_INSIDE_WALL2 = Block.m_49796_((double)10.0, (double)5.0, (double)1.0, (double)11.0, (double)11.0, (double)15.0);
    private static final VoxelShape X_LIP1 = Block.m_49796_((double)0.0, (double)5.0, (double)1.0, (double)1.0, (double)6.0, (double)15.0);
    private static final VoxelShape X_LIP2 = Block.m_49796_((double)15.0, (double)5.0, (double)1.0, (double)16.0, (double)6.0, (double)15.0);
    private static final VoxelShape Y_SIDE1 = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)1.0, (double)11.0, (double)6.0);
    private static final VoxelShape Y_SIDE2 = Block.m_49796_((double)0.0, (double)4.0, (double)10.0, (double)1.0, (double)11.0, (double)16.0);
    private static final VoxelShape Y_BAR1 = Block.m_49796_((double)0.0, (double)4.0, (double)6.0, (double)1.0, (double)5.0, (double)10.0);
    private static final VoxelShape Y_SIDE3 = Block.m_49796_((double)15.0, (double)4.0, (double)0.0, (double)16.0, (double)11.0, (double)6.0);
    private static final VoxelShape Y_SIDE4 = Block.m_49796_((double)15.0, (double)4.0, (double)10.0, (double)16.0, (double)11.0, (double)16.0);
    private static final VoxelShape Y_BAR2 = Block.m_49796_((double)15.0, (double)4.0, (double)6.0, (double)16.0, (double)5.0, (double)10.0);
    private static final VoxelShape Y_STORAGE1 = Block.m_49796_((double)1.0, (double)4.0, (double)0.0, (double)15.0, (double)5.0, (double)6.0);
    private static final VoxelShape Y_STORAGE2 = Block.m_49796_((double)1.0, (double)4.0, (double)10.0, (double)15.0, (double)5.0, (double)16.0);
    private static final VoxelShape Y_INSIDE_WALL1 = Block.m_49796_((double)1.0, (double)5.0, (double)5.0, (double)15.0, (double)11.0, (double)6.0);
    private static final VoxelShape Y_INSIDE_WALL2 = Block.m_49796_((double)1.0, (double)5.0, (double)10.0, (double)15.0, (double)11.0, (double)11.0);
    private static final VoxelShape Y_LIP1 = Block.m_49796_((double)1.0, (double)5.0, (double)0.0, (double)15.0, (double)6.0, (double)1.0);
    private static final VoxelShape Y_LIP2 = Block.m_49796_((double)1.0, (double)5.0, (double)15.0, (double)15.0, (double)6.0, (double)16.0);
    private static final VoxelShape X_AXIS_AABB = Shapes.m_83124_((VoxelShape)TOP_PLATE, (VoxelShape[])new VoxelShape[]{LEG1, LEG2, LEG3, LEG4, X_SIDE1, X_SIDE2, X_BAR1, X_SIDE3, X_SIDE4, X_BAR2, X_STORAGE1, X_STORAGE2, X_INSIDE_WALL1, X_INSIDE_WALL2, X_LIP1, X_LIP2});
    private static final VoxelShape Y_AXIS_AABB = Shapes.m_83124_((VoxelShape)TOP_PLATE, (VoxelShape[])new VoxelShape[]{LEG1, LEG2, LEG3, LEG4, Y_SIDE1, Y_SIDE2, Y_BAR1, Y_SIDE3, Y_SIDE4, Y_BAR2, Y_INSIDE_WALL1, Y_INSIDE_WALL2, Y_STORAGE1, Y_STORAGE2, Y_LIP1, Y_LIP2});

    public ChessBlock(MapColor mapColor, SoundType soundType) {
        super(ChessBlock.getProperties(mapColor, soundType));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SHOW_PLATE, (Comparable)Boolean.valueOf(true)));
    }

    private static BlockBehaviour.Properties getProperties(MapColor mapColor, SoundType soundType) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_();
        properties.m_284180_(mapColor);
        properties.m_60918_(soundType);
        properties.m_60978_(2.0f);
        properties.m_60955_();
        return properties;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_((Property)SHOW_PLATE, (Comparable)Boolean.valueOf(true));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        ChessBlockEntity chessBlockEntity;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ChessBlockEntity && (chessBlockEntity = (ChessBlockEntity)blockEntity).getUseCustomPlate()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)SHOW_PLATE, (Comparable)Boolean.valueOf(false)));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SHOW_PLATE});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> X_AXIS_AABB;
            case Direction.NORTH, Direction.SOUTH -> Y_AXIS_AABB;
        };
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_6144_()) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ChessBlockEntity) {
                ChessBlockEntity chessBlockEntity = (ChessBlockEntity)blockEntity;
                if (level.f_46443_) {
                    ChessBoardSettingsScreen.open(chessBlockEntity);
                }
            }
        } else {
            ChessBlockEntity chessBlockEntity;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ChessBlockEntity && (chessBlockEntity = (ChessBlockEntity)blockEntity).getWaitingForPromotion()) {
                if (level.m_5776_()) {
                    ChessPawnPromotionScreen.open(chessBlockEntity, chessBlockEntity.getBoard().getCurrentChessPlayer().getOpponent().getPieceColor().isWhite());
                }
            } else {
                Direction face = hit.m_82434_();
                if (face.equals((Object)Direction.UP) && hit.m_82450_().f_82480_ - (double)pos.m_123342_() > 0.7) {
                    Direction facing = (Direction)state.m_61143_((Property)FACING);
                    int chessRank = this.getChessRank(hit.m_82450_(), facing) + 1;
                    int chessColumn = this.getChessColumn(hit.m_82450_(), facing);
                    byte tileCoordinate = (byte)Mth.m_14045_((int)((8 - chessRank) * 8 + chessColumn), (int)0, (int)63);
                    if (level.f_46443_) {
                        NetworkUtil.doChessBoardInteraction(pos, tileCoordinate);
                    }
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ChessBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return (level1, pos, state1, blockEntity) -> ChessBlockEntity.tick(level1, pos, state1, (ChessBlockEntity)blockEntity);
    }

    private int getChessRank(Vec3 vec3d, Direction facing) {
        double value = facing == Direction.NORTH || facing == Direction.SOUTH ? vec3d.f_82481_ : vec3d.f_82479_;
        value -= Math.floor(value);
        value *= 100.0;
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH, Direction.WEST, Direction.DOWN, Direction.UP -> (int)(7.0 - Math.floor(value / 12.5));
            case Direction.SOUTH, Direction.EAST -> (int)Math.floor(value / 12.5);
        };
    }

    private int getChessColumn(Vec3 vec3d, Direction facing) {
        double value = facing == Direction.NORTH || facing == Direction.SOUTH ? vec3d.f_82479_ : vec3d.f_82481_;
        value -= Math.floor(value);
        value *= 100.0;
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH, Direction.DOWN, Direction.UP, Direction.EAST -> (int)Math.floor(value / 12.5);
            case Direction.SOUTH, Direction.WEST -> (int)(7.0 - Math.floor(value / 12.5));
        };
    }
}

