/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.network.server;

import andrews.table_top_craft.block_entities.ChessBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageServerSetColors {
    private final int colorType;
    private final BlockPos pos;
    private final String color;
    private final String color2;

    public MessageServerSetColors(int colorType, BlockPos pos, String color, String color2) {
        this.colorType = colorType;
        this.pos = pos;
        this.color = color;
        this.color2 = color2;
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.writeInt(this.colorType);
        buf.m_130064_(this.pos);
        buf.m_130070_(this.color);
        buf.m_130070_(this.color2);
    }

    public static MessageServerSetColors deserialize(FriendlyByteBuf buf) {
        int colorType = buf.readInt();
        BlockPos pos = buf.m_130135_();
        String color = buf.m_130136_(Short.MAX_VALUE);
        String color2 = buf.m_130136_(Short.MAX_VALUE);
        return new MessageServerSetColors(colorType, pos, color, color2);
    }

    public static void handle(MessageServerSetColors message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        ServerPlayer player = context.getSender();
        BlockPos chessPos = message.pos;
        String color = message.color;
        String color2 = message.color2;
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> MessageServerSetColors.lambda$handle$0((Player)player, chessPos, message, color, color2));
            context.setPacketHandled(true);
        }
    }

    private static /* synthetic */ void lambda$handle$0(Player player, BlockPos chessPos, MessageServerSetColors message, String color, String color2) {
        Level level;
        BlockEntity blockEntity;
        if (player != null && (blockEntity = (level = player.m_9236_()).m_7702_(chessPos)) instanceof ChessBlockEntity) {
            ChessBlockEntity chessBlockEntity = (ChessBlockEntity)blockEntity;
            switch (message.colorType) {
                case 0: {
                    chessBlockEntity.setWhiteTilesColor(color);
                    chessBlockEntity.setBlackTilesColor(color2);
                    break;
                }
                case 1: {
                    chessBlockEntity.setWhitePiecesColor(color);
                    chessBlockEntity.setBlackPiecesColor(color2);
                }
            }
            level.m_7260_(message.pos, level.m_8055_(chessPos), level.m_8055_(chessPos), 2);
            chessBlockEntity.m_6596_();
        }
    }
}

