/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.network.server;

import andrews.table_top_craft.block_entities.ChessBlockEntity;
import andrews.table_top_craft.game_logic.chess.board.Board;
import andrews.table_top_craft.game_logic.chess.board.moves.BaseMove;
import andrews.table_top_craft.game_logic.chess.board.moves.PawnPromotion;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import andrews.table_top_craft.game_logic.chess.pieces.BishopPiece;
import andrews.table_top_craft.game_logic.chess.pieces.KnightPiece;
import andrews.table_top_craft.game_logic.chess.pieces.QueenPiece;
import andrews.table_top_craft.game_logic.chess.pieces.RookPiece;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageServerDoPawnPromotion {
    private final BlockPos pos;
    private byte type;

    public MessageServerDoPawnPromotion(BlockPos pos, byte type) {
        this.pos = pos;
        this.type = type;
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeByte((int)this.type);
    }

    public static MessageServerDoPawnPromotion deserialize(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        byte type = buf.readByte();
        return new MessageServerDoPawnPromotion(pos, type);
    }

    public static void handle(MessageServerDoPawnPromotion message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        ServerPlayer player = context.getSender();
        BlockPos pos = message.pos;
        byte type = message.type;
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> MessageServerDoPawnPromotion.lambda$handle$0((Player)player, pos, type));
            context.setPacketHandled(true);
        }
    }

    private static /* synthetic */ void lambda$handle$0(Player player, BlockPos pos, byte type) {
        ChessBlockEntity chessBlockEntity;
        Level level;
        BlockEntity blockEntity;
        if (player != null && (blockEntity = (level = player.m_9236_()).m_7702_(pos)) instanceof ChessBlockEntity && (chessBlockEntity = (ChessBlockEntity)blockEntity).getWaitingForPromotion()) {
            Board board = chessBlockEntity.getBoard();
            Board.Builder builder = new Board.Builder();
            for (byte i = 0; i < 64; ++i) {
                if (!board.getTile(i).isTileOccupied()) continue;
                if (chessBlockEntity.getPromotionCoordinate() == i) {
                    BasePiece piece = board.getTile(i).getPiece();
                    switch (type) {
                        default: {
                            builder.setPiece(new QueenPiece(piece.getPieceColor(), piece.getPiecePosition()));
                            break;
                        }
                        case 3: {
                            builder.setPiece(new BishopPiece(piece.getPieceColor(), piece.getPiecePosition()));
                            break;
                        }
                        case 4: {
                            builder.setPiece(new KnightPiece(piece.getPieceColor(), piece.getPiecePosition()));
                            break;
                        }
                        case 2: {
                            builder.setPiece(new RookPiece(piece.getPieceColor(), piece.getPiecePosition()));
                            break;
                        }
                    }
                    continue;
                }
                builder.setPiece(board.getTile(i).getPiece());
            }
            builder.setMoveMaker(board.getCurrentChessPlayer().getPieceColor());
            chessBlockEntity.setBoard(builder.build());
            if (chessBlockEntity.getMoveLog().getMoves().get(chessBlockEntity.getMoveLog().getMoves().size() - 1).isPawnPromotion()) {
                BaseMove move = chessBlockEntity.getMoveLog().getMoves().get(chessBlockEntity.getMoveLog().getMoves().size() - 1);
                switch (type) {
                    default: {
                        chessBlockEntity.getMoveLog().getMoves().set(chessBlockEntity.getMoveLog().getMoves().size() - 1, new PawnPromotion(move, "Q"));
                        break;
                    }
                    case 3: {
                        chessBlockEntity.getMoveLog().getMoves().set(chessBlockEntity.getMoveLog().getMoves().size() - 1, new PawnPromotion(move, "B"));
                        break;
                    }
                    case 4: {
                        chessBlockEntity.getMoveLog().getMoves().set(chessBlockEntity.getMoveLog().getMoves().size() - 1, new PawnPromotion(move, "N"));
                        break;
                    }
                    case 2: {
                        chessBlockEntity.getMoveLog().getMoves().set(chessBlockEntity.getMoveLog().getMoves().size() - 1, new PawnPromotion(move, "R"));
                    }
                }
            }
            chessBlockEntity.setWaitingForPromotion(false);
            chessBlockEntity.setPromotionCoordinate((byte)-1);
            level.m_7260_(pos, level.m_8055_(pos), level.m_8055_(pos), 2);
            chessBlockEntity.m_6596_();
        }
    }
}

