/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.network.client.util;

import andrews.table_top_craft.animation.system.core.AdvancedAnimationState;
import andrews.table_top_craft.animation.system.core.Animation;
import andrews.table_top_craft.animation.system.core.BasicKeyframe;
import andrews.table_top_craft.animation.system.core.KeyframeGroup;
import andrews.table_top_craft.animation.system.core.bulders.AnimationBuilder;
import andrews.table_top_craft.animation.system.core.bulders.EasingBuilder;
import andrews.table_top_craft.animation.system.core.types.EasingTypes;
import andrews.table_top_craft.animation.system.core.types.TransformTypes;
import andrews.table_top_craft.animation.system.core.types.util.EasingType;
import andrews.table_top_craft.block_entities.ChessBlockEntity;
import andrews.table_top_craft.block_entities.ConnectFourBlockEntity;
import andrews.table_top_craft.game_logic.chess.board.Board;
import andrews.table_top_craft.network.client.MessageClientChessAnimationState;
import andrews.table_top_craft.network.client.MessageClientChessParticles;
import andrews.table_top_craft.network.client.MessageClientConnectFourAnimationState;
import andrews.table_top_craft.network.client.MessageClientOpenChessPieceSelectionScreen;
import andrews.table_top_craft.network.client.MessageClientOpenChessPromotionScreen;
import andrews.table_top_craft.network.client.MessageClientPlayChessTimerSound;
import andrews.table_top_craft.objects.blocks.ChessBlock;
import andrews.table_top_craft.particles.options.ChessShatterParticleOptions;
import andrews.table_top_craft.registry.TTCParticles;
import andrews.table_top_craft.screens.chess.menus.ChessPawnPromotionScreen;
import andrews.table_top_craft.screens.chess.menus.ChessPieceSelectionScreen;
import andrews.table_top_craft.util.NBTColorSaving;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.NetworkEvent;

public class ClientPacketHandlerClass {
    public static void handleOpenChessPieceSelectionPacket(MessageClientOpenChessPieceSelectionScreen msg, Supplier<NetworkEvent.Context> ctx) {
        BlockEntity blockEntity;
        BlockPos pos = msg.pos;
        boolean isStandardSetUnlocked = msg.isStandardSetUnlocked;
        boolean isClassicSetUnlocked = msg.isClassicSetUnlocked;
        boolean isPandorasCreaturesSetUnlocked = msg.isPandorasCreaturesSetUnlocked;
        if (Minecraft.m_91087_().f_91074_.m_9236_().m_7702_(pos) != null && (blockEntity = Minecraft.m_91087_().f_91074_.m_9236_().m_7702_(pos)) instanceof ChessBlockEntity) {
            ChessBlockEntity chessBlockEntity = (ChessBlockEntity)blockEntity;
            Minecraft.m_91087_().m_91152_((Screen)new ChessPieceSelectionScreen(chessBlockEntity, isStandardSetUnlocked, isClassicSetUnlocked, isPandorasCreaturesSetUnlocked));
        }
    }

    public static void handleOpenChessPromotionPacket(MessageClientOpenChessPromotionScreen msg, Supplier<NetworkEvent.Context> ctx) {
        BlockEntity blockEntity;
        BlockPos pos = msg.pos;
        boolean isWhite = msg.isWhite;
        if (Minecraft.m_91087_().f_91074_.m_9236_().m_7702_(pos) != null && (blockEntity = Minecraft.m_91087_().f_91074_.m_9236_().m_7702_(pos)) instanceof ChessBlockEntity) {
            ChessBlockEntity chessBlockEntity = (ChessBlockEntity)blockEntity;
            Minecraft.m_91087_().m_91152_((Screen)new ChessPawnPromotionScreen(chessBlockEntity, isWhite));
        }
    }

    public static void handlePlayChessTimerSoundPacket(MessageClientPlayChessTimerSound msg, Supplier<NetworkEvent.Context> ctx) {
        BlockPos pos = msg.pos;
        byte id = msg.id;
        if (Minecraft.m_91087_().f_91073_ != null) {
            switch (id) {
                case 0: {
                    Minecraft.m_91087_().f_91073_.m_245747_(pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 1.0f, 0.6f, false);
                    break;
                }
                case 1: {
                    Minecraft.m_91087_().f_91073_.m_245747_(pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 1.0f, 0.6f, false);
                    Minecraft.m_91087_().f_91073_.m_245747_(pos, SoundEvents.f_144242_, SoundSource.BLOCKS, 3.0f, 1.2f, false);
                }
            }
        }
    }

    public static void handlePlayChessParticlesPacket(MessageClientChessParticles msg, Supplier<NetworkEvent.Context> ctx) {
        BlockPos pos = msg.pos;
        byte destCord = msg.destCord;
        boolean isWhite = msg.isWhite;
        float xSpeed = msg.xSpeed;
        float ySpeed = msg.ySpeed;
        float zSpeed = msg.zSpeed;
        if (Minecraft.m_91087_().f_91073_ != null) {
            double xOffset = 0.0;
            double zOffset = 0.0;
            switch ((Direction)Minecraft.m_91087_().f_91073_.m_8055_(pos).m_61143_((Property)ChessBlock.FACING)) {
                case NORTH: {
                    xOffset = (double)(destCord % 8) * 0.125 + 0.0625;
                    zOffset = (double)(destCord / 8) * 0.125 + 0.0625;
                    break;
                }
                case SOUTH: {
                    xOffset = 1.0 - (double)(destCord % 8) * 0.125 - 0.0625;
                    zOffset = 1.0 - (double)(destCord / 8) * 0.125 - 0.0625;
                    break;
                }
                case WEST: {
                    zOffset = 1.0 - (double)(destCord % 8) * 0.125 - 0.0625;
                    xOffset = (double)(destCord / 8) * 0.125 + 0.0625;
                    break;
                }
                case EAST: {
                    zOffset = (double)(destCord % 8) * 0.125 + 0.0625;
                    xOffset = 1.0 - (double)(destCord / 8) * 0.125 - 0.0625;
                }
            }
            BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(pos);
            if (blockEntity instanceof ChessBlockEntity) {
                int i;
                ChessBlockEntity blockEntity2 = (ChessBlockEntity)blockEntity;
                String color = isWhite ? blockEntity2.getWhitePiecesColor() : blockEntity2.getBlackPiecesColor();
                int red = NBTColorSaving.getRed(color);
                int green = NBTColorSaving.getGreen(color);
                int blue = NBTColorSaving.getBlue(color);
                for (i = 0; i < 10; ++i) {
                    Minecraft.m_91087_().f_91073_.m_7106_((ParticleOptions)TTCParticles.TINY_POOF.get(), (double)pos.m_123341_() + xOffset, (double)((float)pos.m_123342_() + 0.84375f), (double)pos.m_123343_() + zOffset, 0.0, 0.0, 0.0);
                }
                for (i = 0; i < 14; ++i) {
                    Minecraft.m_91087_().f_91073_.m_7106_((ParticleOptions)new ChessShatterParticleOptions(red, green, blue), (double)pos.m_123341_() + xOffset, (double)((float)pos.m_123342_() + 0.78125f), (double)pos.m_123343_() + zOffset, (double)xSpeed, (double)ySpeed, (double)zSpeed);
                }
            }
        }
    }

    public static void handleChessAnimationPacket(MessageClientChessAnimationState msg, Supplier<NetworkEvent.Context> ctx) {
        BlockPos pos = msg.pos;
        byte actionType = msg.actionType;
        BlockEntity blockEntity = Minecraft.m_91087_().f_91074_.m_9236_().m_7702_(pos);
        if (blockEntity instanceof ChessBlockEntity) {
            ChessBlockEntity chessBlockEntity = (ChessBlockEntity)blockEntity;
            if (actionType == 0) {
                chessBlockEntity.placedState.m_216977_(chessBlockEntity.getTicksExisted());
                chessBlockEntity.moveState = null;
                chessBlockEntity.clearMoveTransitionsCache();
                chessBlockEntity.setCachedPiece(null);
            } else if (actionType == 1) {
                chessBlockEntity.placedState.m_216973_();
                chessBlockEntity.placedState.interpolateAndStart(0.2f, EasingBuilder.type(EasingType.EASE_OUT_QUAD).argument(0.2f).build(), false, chessBlockEntity.getTicksExisted());
            } else if (actionType == 2) {
                chessBlockEntity.currentCord = msg.currentCord;
                chessBlockEntity.destCord = msg.destCord;
                Animation animation = ClientPacketHandlerClass.generateAnimation(chessBlockEntity, chessBlockEntity.currentCord, chessBlockEntity.destCord);
                chessBlockEntity.moveState = new AdvancedAnimationState(new AtomicReference<Animation>(animation));
                chessBlockEntity.moveState.m_216977_(chessBlockEntity.getTicksExisted());
            }
        }
    }

    public static void handleConnectFourAnimationPacket(MessageClientConnectFourAnimationState msg, Supplier<NetworkEvent.Context> ctx) {
        BlockPos pos = msg.pos;
        byte destCord = msg.destCord;
        BlockEntity blockEntity = Minecraft.m_91087_().f_91074_.m_9236_().m_7702_(pos);
        if (blockEntity instanceof ConnectFourBlockEntity) {
            ConnectFourBlockEntity blockEntity2 = (ConnectFourBlockEntity)blockEntity;
            blockEntity2.movingPiece = destCord;
            int heightMod = destCord % 6;
            float animLength = 1.0f - (float)heightMod * 0.1f;
            AnimationBuilder builder = AnimationBuilder.withLength(animLength);
            builder.addAnimation("root", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(0.2f, KeyframeAnimations.m_253126_((float)0.0f, (float)(13.0f - (float)(heightMod * 2)), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(animLength, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), EasingBuilder.type(EasingType.EASE_IN_BOUNCE).argument(0.2f - 0.2f * ((float)heightMod * 0.15f)).build())));
            builder.addAnimation("root", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)90.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(0.3f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR)));
            builder.addAnimation("root", new KeyframeGroup(TransformTypes.SCALE, new BasicKeyframe(0.0f, KeyframeAnimations.m_253004_((double)0.1f, (double)0.1f, (double)0.1f), EasingTypes.LINEAR), new BasicKeyframe(0.3f, KeyframeAnimations.m_253004_((double)1.0, (double)1.0, (double)1.0), EasingTypes.LINEAR)));
            Animation animation = builder.build();
            blockEntity2.moveState = new AdvancedAnimationState(new AtomicReference<Animation>(animation));
            blockEntity2.moveState.m_216977_(blockEntity2.getTicksExisted());
        }
    }

    public static Animation generateAnimation(ChessBlockEntity blockEntity, byte currentCord, byte destCord) {
        Board board = blockEntity.getBoard();
        int startX = currentCord % 8;
        int startY = currentCord / 8;
        int destX = destCord % 8;
        int destY = destCord / 8;
        int deltaY = startY - destY;
        deltaY = board.getTile(currentCord).getPiece().getPieceColor().isWhite() ? deltaY : -deltaY;
        int deltaX = startX - destX;
        deltaX = board.getTile(currentCord).getPiece().getPieceColor().isWhite() ? -deltaX : deltaX;
        float time = 1.0f;
        switch (board.getTile(currentCord).getPiece().getPieceType()) {
            case PAWN: {
                float f = time = deltaY == 2 || deltaY == -2 ? 1.0f : 0.75f;
                if ((board.getTile(currentCord).getPiece().getPieceColor().isWhite() && startY == 3 || board.getTile(currentCord).getPiece().getPieceColor().isBlack() && startY == 4) && (deltaX == -1 || deltaX == 1) && board.getTile(destCord).getPiece() == null) {
                    time = 1.0f;
                    AnimationBuilder builder = AnimationBuilder.withLength(time);
                    builder.addAnimation("moved", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(0.2f, KeyframeAnimations.m_253126_((float)0.0f, (float)1.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.5f, KeyframeAnimations.m_253126_((float)((float)deltaX * 2.0f), (float)1.0f, (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 3.0f, KeyframeAnimations.m_253126_((float)((float)deltaX * 2.0f), (float)1.0f, (float)((float)deltaY * -0.2f)), EasingTypes.EASE_OUT_CUBIC), new BasicKeyframe(time, KeyframeAnimations.m_253126_((float)((float)deltaX * 2.0f), (float)0.0f, (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR)));
                    builder.addAnimation("moved", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 3.0f, KeyframeAnimations.m_253186_((float)-60.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR)));
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(time / 4.0f * 2.7f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253126_((float)0.0f, (float)8.0f, (float)8.0f), EasingTypes.LINEAR)));
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(time / 4.0f * 2.7f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253186_((float)-300.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR)));
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.SCALE, new BasicKeyframe(time / 4.0f * 3.5f, KeyframeAnimations.m_253004_((double)1.0, (double)1.0, (double)1.0), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253004_((double)0.0, (double)0.0, (double)0.0), EasingTypes.LINEAR)));
                    return builder.build();
                }
                AnimationBuilder builder = AnimationBuilder.withLength(time);
                builder.addAnimation("moved", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(0.2f, KeyframeAnimations.m_253126_((float)0.0f, (float)1.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 3.0f * 2.0f, KeyframeAnimations.m_253126_((float)((float)deltaX * 2.0f), (float)(board.getTile(destCord).getPiece() != null ? 2.5f : 1.0f), (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253126_((float)((float)deltaX * 2.0f), (float)0.0f, (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR)));
                builder.addAnimation("moved", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 3.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR)));
                builder.addAnimation("affected", new KeyframeGroup(TransformTypes.SCALE, new BasicKeyframe(time / 4.0f * 3.0f, KeyframeAnimations.m_253004_((double)1.0, (double)1.0, (double)1.0), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253004_((double)1.0, (double)0.1f, (double)1.0), EasingTypes.LINEAR)));
                return builder.build();
            }
            case BISHOP: {
                time = Math.abs(deltaX) == 1 ? 0.75f : (Math.abs(deltaX) > 3 ? 1.25f : time);
                AnimationBuilder builder = AnimationBuilder.withLength(time);
                if (Math.abs(deltaX) >= 4 && board.getTile(destCord).getPiece() != null) {
                    builder.addAnimation("moved", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(0.2f, KeyframeAnimations.m_253126_((float)0.0f, (float)1.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 3.0f * 2.0f, KeyframeAnimations.m_253126_((float)((float)deltaX * 2.0f), (float)1.0f, (float)((float)deltaY * 2.0f)), EasingTypes.EASE_IN_CUBIC), new BasicKeyframe(time, KeyframeAnimations.m_253126_((float)((float)deltaX * 2.0f), (float)0.0f, (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR)));
                    builder.addAnimation("moved", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.5f, KeyframeAnimations.m_253186_((float)ClientPacketHandlerClass.getRookSlamRotation(deltaX, deltaY, 40.0f), (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.8f, KeyframeAnimations.m_253186_((float)ClientPacketHandlerClass.getRookSlamRotation(deltaX, deltaY, -60.0f), (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR)));
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(time / 4.0f * 2.5f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253126_((float)(deltaX == 0 ? 0.0f : (deltaX > 0 ? -10.0f : 10.0f)), (float)7.0f, (float)(deltaY == 0 ? 0.0f : (deltaY > 0 ? -10.0f : 10.0f))), EasingTypes.LINEAR)));
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(time / 4.0f * 2.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253186_((float)(deltaY != 0 ? -300.0f : 0.0f), (float)0.0f, (float)(deltaX != 0 ? -300.0f : 0.0f)), EasingTypes.LINEAR)));
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.SCALE, new BasicKeyframe(time / 4.0f * 3.5f, KeyframeAnimations.m_253004_((double)1.0, (double)1.0, (double)1.0), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253004_((double)0.0, (double)0.0, (double)0.0), EasingTypes.LINEAR)));
                    return builder.build();
                }
                builder.addAnimation("moved", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(0.2f, KeyframeAnimations.m_253126_((float)0.0f, (float)1.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 3.0f * 2.0f, KeyframeAnimations.m_253126_((float)((float)deltaX * 2.0f), (float)(board.getTile(destCord).getPiece() != null ? 2.5f : 1.0f), (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253126_((float)((float)deltaX * 2.0f), (float)0.0f, (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR)));
                builder.addAnimation("moved", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 3.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR)));
                builder.addAnimation("affected", new KeyframeGroup(TransformTypes.SCALE, new BasicKeyframe(time / 4.0f * 3.0f, KeyframeAnimations.m_253004_((double)1.0, (double)1.0, (double)1.0), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253004_((double)1.0, (double)0.1f, (double)1.0), EasingTypes.LINEAR)));
                return builder.build();
            }
            case KNIGHT: {
                AnimationBuilder builder = AnimationBuilder.withLength(time);
                builder.addAnimation("moved", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)2.5f, (float)0.0f), EasingTypes.CATMULLROM), new BasicKeyframe(time / 4.0f * 3.0f, KeyframeAnimations.m_253126_((float)((float)deltaX * 2.0f), (float)2.5f, (float)((float)deltaY * 2.0f)), EasingTypes.CATMULLROM), new BasicKeyframe(time, KeyframeAnimations.m_253126_((float)((float)deltaX * 2.0f), (float)0.0f, (float)((float)deltaY * 2.0f)), EasingTypes.CATMULLROM)));
                builder.addAnimation("moved", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)ClientPacketHandlerClass.getKnightRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 3.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)ClientPacketHandlerClass.getKnightRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR)));
                builder.addAnimation("affected", new KeyframeGroup(TransformTypes.SCALE, new BasicKeyframe(time / 4.0f * 3.0f, KeyframeAnimations.m_253004_((double)1.0, (double)1.0, (double)1.0), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253004_((double)1.0, (double)0.1f, (double)1.0), EasingTypes.LINEAR)));
                return builder.build();
            }
            case KING: {
                time = deltaX == 2 || deltaX == -2 ? 1.0f : 0.75f;
                AnimationBuilder builder = AnimationBuilder.withLength(time);
                builder.addAnimation("moved", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(0.2f, KeyframeAnimations.m_253126_((float)0.0f, (float)1.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 3.0f, KeyframeAnimations.m_253126_((float)((float)deltaX * 2.0f), (float)(board.getTile(destCord).getPiece() != null ? 2.5f : 1.0f), (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253126_((float)((float)deltaX * 2.0f), (float)0.0f, (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR)));
                builder.addAnimation("moved", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 3.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR)));
                if (board.getTile(destCord).getPiece() != null) {
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.SCALE, new BasicKeyframe(time / 4.0f * 3.0f, KeyframeAnimations.m_253004_((double)1.0, (double)1.0, (double)1.0), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253004_((double)1.0, (double)0.1f, (double)1.0), EasingTypes.LINEAR)));
                }
                if (deltaX == 2 || deltaX == -2) {
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)2.5f, (float)0.0f), EasingTypes.CATMULLROM), new BasicKeyframe(time / 4.0f * 3.0f, KeyframeAnimations.m_253126_((float)((float)(-deltaX) * (destX == 2 ? 3.0f : 2.0f)), (float)2.5f, (float)0.0f), EasingTypes.CATMULLROM), new BasicKeyframe(time, KeyframeAnimations.m_253126_((float)((float)(-deltaX) * (destX == 2 ? 3.0f : 2.0f)), (float)0.0f, (float)0.0f), EasingTypes.CATMULLROM)));
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(-deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 3.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(-deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR)));
                }
                return builder.build();
            }
            case QUEEN: {
                time = Math.abs(deltaX) == 1 || Math.abs(deltaY) == 1 ? 0.75f : (Math.abs(deltaX) > 3 || Math.abs(deltaY) > 3 ? 1.25f : time);
                AnimationBuilder builder = AnimationBuilder.withLength(time);
                if ((Math.abs(deltaX) >= 4 && Math.abs(deltaY) == 0 || Math.abs(deltaY) >= 4 && Math.abs(deltaX) == 0 || Math.abs(deltaX) >= 4 && Math.abs(deltaY) >= 4) && board.getTile(destCord).getPiece() != null) {
                    builder.addAnimation("moved", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(0.2f, KeyframeAnimations.m_253126_((float)0.0f, (float)1.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 3.0f * 2.0f, KeyframeAnimations.m_253126_((float)((float)deltaX * 2.0f), (float)1.0f, (float)((float)deltaY * 2.0f)), EasingTypes.EASE_IN_CUBIC), new BasicKeyframe(time, KeyframeAnimations.m_253126_((float)((float)deltaX * 2.0f), (float)0.0f, (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR)));
                    builder.addAnimation("moved", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.5f, KeyframeAnimations.m_253186_((float)ClientPacketHandlerClass.getRookSlamRotation(deltaX, deltaY, 40.0f), (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.8f, KeyframeAnimations.m_253186_((float)ClientPacketHandlerClass.getRookSlamRotation(deltaX, deltaY, -60.0f), (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR)));
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(time / 4.0f * 2.5f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253126_((float)(deltaX == 0 ? 0.0f : (deltaX > 0 ? -10.0f : 10.0f)), (float)7.0f, (float)(deltaY == 0 ? 0.0f : (deltaY > 0 ? -10.0f : 10.0f))), EasingTypes.LINEAR)));
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(time / 4.0f * 2.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253186_((float)(deltaY != 0 ? -300.0f : 0.0f), (float)0.0f, (float)(deltaX != 0 ? -300.0f : 0.0f)), EasingTypes.LINEAR)));
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.SCALE, new BasicKeyframe(time / 4.0f * 3.5f, KeyframeAnimations.m_253004_((double)1.0, (double)1.0, (double)1.0), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253004_((double)0.0, (double)0.0, (double)0.0), EasingTypes.LINEAR)));
                    return builder.build();
                }
                builder.addAnimation("moved", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(0.2f, KeyframeAnimations.m_253126_((float)0.0f, (float)1.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 3.0f * 2.0f, KeyframeAnimations.m_253126_((float)((float)deltaX * 2.0f), (float)(board.getTile(destCord).getPiece() != null ? 2.5f : 1.0f), (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253126_((float)((float)deltaX * 2.0f), (float)0.0f, (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR)));
                builder.addAnimation("moved", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 3.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR)));
                builder.addAnimation("affected", new KeyframeGroup(TransformTypes.SCALE, new BasicKeyframe(time / 4.0f * 3.0f, KeyframeAnimations.m_253004_((double)1.0, (double)1.0, (double)1.0), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253004_((double)1.0, (double)0.1f, (double)1.0), EasingTypes.LINEAR)));
                return builder.build();
            }
            case ROOK: {
                time = Math.abs(deltaX) == 1 || Math.abs(deltaY) == 1 ? 0.75f : (Math.abs(deltaX) > 3 || Math.abs(deltaY) > 3 ? 1.25f : time);
                AnimationBuilder builder = AnimationBuilder.withLength(time);
                if ((Math.abs(deltaX) >= 5 || Math.abs(deltaY) >= 5) && board.getTile(destCord).getPiece() != null) {
                    builder.addAnimation("moved", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(0.2f, KeyframeAnimations.m_253126_((float)0.0f, (float)1.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 3.0f * 2.0f, KeyframeAnimations.m_253126_((float)((float)deltaX * 2.0f), (float)1.0f, (float)((float)deltaY * 2.0f)), EasingTypes.EASE_IN_CUBIC), new BasicKeyframe(time, KeyframeAnimations.m_253126_((float)((float)deltaX * 2.0f), (float)0.0f, (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR)));
                    builder.addAnimation("moved", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.5f, KeyframeAnimations.m_253186_((float)ClientPacketHandlerClass.getRookSlamRotation(deltaX, deltaY, 40.0f), (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 2.8f, KeyframeAnimations.m_253186_((float)ClientPacketHandlerClass.getRookSlamRotation(deltaX, deltaY, -60.0f), (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR)));
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(time / 4.0f * 2.5f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253126_((float)(deltaX == 0 ? 0.0f : (deltaX > 0 ? -10.0f : 10.0f)), (float)7.0f, (float)(deltaY == 0 ? 0.0f : (deltaY > 0 ? -10.0f : 10.0f))), EasingTypes.LINEAR)));
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(time / 4.0f * 2.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253186_((float)(deltaY != 0 ? -300.0f : 0.0f), (float)0.0f, (float)(deltaX != 0 ? -300.0f : 0.0f)), EasingTypes.LINEAR)));
                    builder.addAnimation("affected", new KeyframeGroup(TransformTypes.SCALE, new BasicKeyframe(time / 4.0f * 3.5f, KeyframeAnimations.m_253004_((double)1.0, (double)1.0, (double)1.0), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253004_((double)0.0, (double)0.0, (double)0.0), EasingTypes.LINEAR)));
                    return builder.build();
                }
                builder.addAnimation("moved", new KeyframeGroup(TransformTypes.POSITION, new BasicKeyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(0.2f, KeyframeAnimations.m_253126_((float)0.0f, (float)1.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 3.0f * 2.0f, KeyframeAnimations.m_253126_((float)((float)deltaX * 2.0f), (float)(board.getTile(destCord).getPiece() != null ? 2.5f : 1.0f), (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253126_((float)((float)deltaX * 2.0f), (float)0.0f, (float)((float)deltaY * 2.0f)), EasingTypes.LINEAR)));
                builder.addAnimation("moved", new KeyframeGroup(TransformTypes.ROTATION, new BasicKeyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time / 4.0f * 3.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)ClientPacketHandlerClass.getKingRotation(deltaX, deltaY), (float)0.0f), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), EasingTypes.LINEAR)));
                builder.addAnimation("affected", new KeyframeGroup(TransformTypes.SCALE, new BasicKeyframe(time / 4.0f * 3.0f, KeyframeAnimations.m_253004_((double)1.0, (double)1.0, (double)1.0), EasingTypes.LINEAR), new BasicKeyframe(time, KeyframeAnimations.m_253004_((double)1.0, (double)0.1f, (double)1.0), EasingTypes.LINEAR)));
                return builder.build();
            }
        }
        return null;
    }

    private static float getRookSlamRotation(int deltaX, int deltaY, float rotation) {
        if (deltaY != 0) {
            return deltaY > 0 ? -rotation : rotation;
        }
        if (deltaX != 0) {
            return -rotation;
        }
        return 0.0f;
    }

    private static float getKnightRotation(int deltaX, int deltaY) {
        if (deltaX > 0 && deltaY > 0) {
            return deltaX == 2 ? 53.0f : 26.5f;
        }
        if (deltaX < 0 && deltaY > 0) {
            return deltaX == -2 ? -53.0f : -26.5f;
        }
        if (deltaX < 0 && deltaY < 0) {
            return deltaX == -2 ? 53.0f : 26.5f;
        }
        if (deltaX > 0 && deltaY < 0) {
            return deltaX == 2 ? -53.0f : -26.5f;
        }
        return 0.0f;
    }

    private static float getKingRotation(int deltaX, int deltaY) {
        if (deltaX > 0 && deltaY > 0) {
            return 45.0f;
        }
        if (deltaX > 0 && deltaY == 0) {
            return 90.0f;
        }
        if (deltaX < 0 && deltaY > 0) {
            return -45.0f;
        }
        if (deltaX < 0 && deltaY == 0) {
            return -90.0f;
        }
        if (deltaX < 0) {
            return 45.0f;
        }
        if (deltaX > 0) {
            return -45.0f;
        }
        return 0.0f;
    }
}

