/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.game_logic.chess.pieces;

import andrews.table_top_craft.game_logic.chess.PieceColor;
import andrews.table_top_craft.game_logic.chess.board.Board;
import andrews.table_top_craft.game_logic.chess.board.BoardUtils;
import andrews.table_top_craft.game_logic.chess.board.moves.BaseMove;
import andrews.table_top_craft.game_logic.chess.board.moves.MajorAttackMove;
import andrews.table_top_craft.game_logic.chess.board.moves.MajorMove;
import andrews.table_top_craft.game_logic.chess.board.tiles.BaseChessTile;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;

public class KingPiece
extends BasePiece {
    private static final int[] CANDIDATE_MOVE_COORDINATES = new int[]{-9, -8, -7, -1, 1, 7, 8, 9};
    private final boolean isCastled;
    private final boolean kingSideCastleCapable;
    private final boolean queenSideCastleCapable;

    public KingPiece(PieceColor pieceColor, int piecePosition, boolean kingSideCastleCapable, boolean queenSideCastleCapable) {
        super(BasePiece.PieceType.KING, piecePosition, pieceColor, true);
        this.isCastled = false;
        this.kingSideCastleCapable = kingSideCastleCapable;
        this.queenSideCastleCapable = queenSideCastleCapable;
    }

    public KingPiece(PieceColor pieceColor, int piecePosition, boolean isFirstMove, boolean isCastled, boolean kingSideCastleCapable, boolean queenSideCastleCapable) {
        super(BasePiece.PieceType.KING, piecePosition, pieceColor, isFirstMove);
        this.isCastled = isCastled;
        this.kingSideCastleCapable = kingSideCastleCapable;
        this.queenSideCastleCapable = queenSideCastleCapable;
    }

    public boolean isCastled() {
        return this.isCastled;
    }

    public boolean isKingSideCastleCapable() {
        return this.kingSideCastleCapable;
    }

    public boolean isQueenSideCastleCapable() {
        return this.queenSideCastleCapable;
    }

    @Override
    public Collection<BaseMove> calculateLegalMoves(Board board) {
        ArrayList<BaseMove> legalMoves = new ArrayList<BaseMove>();
        for (int currentCandidateOffset : CANDIDATE_MOVE_COORDINATES) {
            int candidateDestinationCoordinate = this.piecePosition + currentCandidateOffset;
            if (KingPiece.isFirstColumnExclusion(this.piecePosition, currentCandidateOffset) || KingPiece.isEighthColumnExclusion(this.piecePosition, currentCandidateOffset) || !BoardUtils.isValidTileCoordinate(candidateDestinationCoordinate)) continue;
            BaseChessTile candidateDestinationTile = board.getTile(candidateDestinationCoordinate);
            if (!candidateDestinationTile.isTileOccupied()) {
                legalMoves.add(new MajorMove(board, this, candidateDestinationCoordinate));
                continue;
            }
            BasePiece pieceAtDestination = candidateDestinationTile.getPiece();
            PieceColor pieceColor = pieceAtDestination.getPieceColor();
            if (this.pieceColor == pieceColor) continue;
            legalMoves.add(new MajorAttackMove(board, this, candidateDestinationCoordinate, pieceAtDestination));
        }
        return ImmutableList.copyOf(legalMoves);
    }

    public String toString() {
        return BasePiece.PieceType.KING.toString();
    }

    private static boolean isFirstColumnExclusion(int currentPosition, int candidateOffset) {
        return BoardUtils.FIRST_COLUMN[currentPosition] && (candidateOffset == -9 || candidateOffset == -1 || candidateOffset == 7);
    }

    private static boolean isEighthColumnExclusion(int currentPosition, int candidateOffset) {
        return BoardUtils.EIGHTH_COLUMN[currentPosition] && (candidateOffset == -7 || candidateOffset == 1 || candidateOffset == 9);
    }

    @Override
    public int locationBonus() {
        return this.pieceColor.kingBonus(this.piecePosition);
    }

    @Override
    public KingPiece movePiece(BaseMove move) {
        return new KingPiece(move.getMovedPiece().getPieceColor(), move.getDestinationCoordinate(), false, move.isCastlingMove(), false, false);
    }
}

