/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.game_logic.chess.board.tiles;

import andrews.table_top_craft.game_logic.chess.board.tiles.EmptyChessTile;
import andrews.table_top_craft.game_logic.chess.board.tiles.OccupiedChessTile;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseChessTile {
    protected final int tileCoordinate;
    private static final Map<Integer, EmptyChessTile> EMPTY_TILES_CACHE = BaseChessTile.createAllEmptyTiles();

    BaseChessTile(int tileCoordinate) {
        this.tileCoordinate = tileCoordinate;
    }

    public static BaseChessTile createTile(int tileCoordinate, BasePiece piece) {
        return piece != null ? new OccupiedChessTile(tileCoordinate, piece) : (BaseChessTile)EMPTY_TILES_CACHE.get(tileCoordinate);
    }

    private static Map<Integer, EmptyChessTile> createAllEmptyTiles() {
        HashMap<Integer, EmptyChessTile> emptyTileMap = new HashMap<Integer, EmptyChessTile>();
        for (int i = 0; i < 64; ++i) {
            emptyTileMap.put(i, new EmptyChessTile(i));
        }
        return ImmutableMap.copyOf(emptyTileMap);
    }

    public abstract boolean isTileOccupied();

    public abstract BasePiece getPiece();

    public int getTileCoordinate() {
        return this.tileCoordinate;
    }
}

