/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.game_logic.chess.board;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;

public class BoardUtils {
    public static final boolean[] FIRST_COLUMN = BoardUtils.initColumn(0);
    public static final boolean[] SECOND_COLUMN = BoardUtils.initColumn(1);
    public static final boolean[] SEVENTH_COLUMN = BoardUtils.initColumn(6);
    public static final boolean[] EIGHTH_COLUMN = BoardUtils.initColumn(7);
    public static final boolean[] EIGHTH_RANK = BoardUtils.initRow(0);
    public static final boolean[] SEVENTH_RANK = BoardUtils.initRow(8);
    public static final boolean[] SIXTH_RANK = BoardUtils.initRow(16);
    public static final boolean[] FIFTH_RANK = BoardUtils.initRow(24);
    public static final boolean[] FOURTH_RANK = BoardUtils.initRow(32);
    public static final boolean[] THIRD_RANK = BoardUtils.initRow(40);
    public static final boolean[] SECOND_RANK = BoardUtils.initRow(48);
    public static final boolean[] FIRST_RANK = BoardUtils.initRow(56);
    public static final String[] ALGEBRAIC_NOTATION = BoardUtils.initializeAlgebraicNotation();
    public static final Map<String, Integer> POSITION_TO_COORDINATE = BoardUtils.initializePositionToCoordinateMap();
    public static final int NUM_TILES = 64;
    public static final int NUM_TILES_PER_ROW = 8;

    private static String[] initializeAlgebraicNotation() {
        return new String[]{"a8", "b8", "c8", "d8", "e8", "f8", "g8", "h8", "a7", "b7", "c7", "d7", "e7", "f7", "g7", "h7", "a6", "b6", "c6", "d6", "e6", "f6", "g6", "h6", "a5", "b5", "c5", "d5", "e5", "f5", "g5", "h5", "a4", "b4", "c4", "d4", "e4", "f4", "g4", "h4", "a3", "b3", "c3", "d3", "e3", "f3", "g3", "h3", "a2", "b2", "c2", "d2", "e2", "f2", "g2", "h2", "a1", "b1", "c1", "d1", "e1", "f1", "g1", "h1"};
    }

    private static Map<String, Integer> initializePositionToCoordinateMap() {
        HashMap<String, Integer> positionToCoordinate = new HashMap<String, Integer>();
        for (int i = 0; i < 64; ++i) {
            positionToCoordinate.put(ALGEBRAIC_NOTATION[i], i);
        }
        return ImmutableMap.copyOf(positionToCoordinate);
    }

    public static boolean isValidTileCoordinate(int coordinate) {
        return coordinate >= 0 && coordinate < 64;
    }

    private static boolean[] initColumn(int columnNumber) {
        boolean[] column = new boolean[64];
        do {
            column[columnNumber] = true;
        } while ((columnNumber += 8) < 64);
        return column;
    }

    private static boolean[] initRow(int rowNumber) {
        boolean[] row = new boolean[64];
        do {
            row[rowNumber] = true;
        } while (++rowNumber % 8 != 0);
        return row;
    }

    public static int getCoordinateAtPosition(String position) {
        return POSITION_TO_COORDINATE.get(position);
    }

    public static String getPositionAtCoordinate(int coordinate) {
        return ALGEBRAIC_NOTATION[coordinate];
    }
}

