/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.game_logic.chess.board;

import andrews.table_top_craft.game_logic.chess.PieceColor;
import andrews.table_top_craft.game_logic.chess.board.moves.BaseMove;
import andrews.table_top_craft.game_logic.chess.board.tiles.BaseChessTile;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import andrews.table_top_craft.game_logic.chess.pieces.BishopPiece;
import andrews.table_top_craft.game_logic.chess.pieces.KingPiece;
import andrews.table_top_craft.game_logic.chess.pieces.KnightPiece;
import andrews.table_top_craft.game_logic.chess.pieces.PawnPiece;
import andrews.table_top_craft.game_logic.chess.pieces.QueenPiece;
import andrews.table_top_craft.game_logic.chess.pieces.RookPiece;
import andrews.table_top_craft.game_logic.chess.player.BaseChessPlayer;
import andrews.table_top_craft.game_logic.chess.player.BlackChessPlayer;
import andrews.table_top_craft.game_logic.chess.player.WhiteChessPlayer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Board {
    private final List<BaseChessTile> gameBoard;
    private final Collection<BasePiece> whitePieces;
    private final Collection<BasePiece> blackPieces;
    private final WhiteChessPlayer whiteChessPlayer;
    private final BlackChessPlayer blackChessPlayer;
    private final BaseChessPlayer currentPlayer;
    private final PawnPiece enPassantPawn;

    private Board(Builder builder) {
        this.gameBoard = Board.createGameBoard(builder);
        this.whitePieces = Board.calculateActivePieces(this.gameBoard, PieceColor.WHITE);
        this.blackPieces = Board.calculateActivePieces(this.gameBoard, PieceColor.BLACK);
        this.enPassantPawn = builder.enPassantPawn;
        Collection<BaseMove> whiteStandardLegalMoves = this.calculateLegalMoves(this.whitePieces);
        Collection<BaseMove> blackStandardLegalMoves = this.calculateLegalMoves(this.blackPieces);
        this.whiteChessPlayer = new WhiteChessPlayer(this, whiteStandardLegalMoves, blackStandardLegalMoves);
        this.blackChessPlayer = new BlackChessPlayer(this, whiteStandardLegalMoves, blackStandardLegalMoves);
        this.currentPlayer = builder.nextMoveMaker.chooseChessPlayer(this.whiteChessPlayer, this.blackChessPlayer);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 64; ++i) {
            String tileText = this.gameBoard.get(i).toString();
            builder.append(String.format("%3s", tileText));
            if ((i + 1) % 8 != 0) continue;
            builder.append("\n");
        }
        return builder.toString();
    }

    public BaseChessPlayer getWhiteChessPlayer() {
        return this.whiteChessPlayer;
    }

    public BaseChessPlayer getBlackChessPlayer() {
        return this.blackChessPlayer;
    }

    public BaseChessPlayer getCurrentChessPlayer() {
        return this.currentPlayer;
    }

    public PawnPiece getEnPassantPawn() {
        return this.enPassantPawn;
    }

    public Collection<BasePiece> getWhitePieces() {
        return this.whitePieces;
    }

    public Collection<BasePiece> getBlackPieces() {
        return this.blackPieces;
    }

    private Collection<BaseMove> calculateLegalMoves(Collection<BasePiece> pieces) {
        ArrayList<BaseMove> legalMoves = new ArrayList<BaseMove>();
        for (BasePiece piece : pieces) {
            legalMoves.addAll(piece.calculateLegalMoves(this));
        }
        return ImmutableList.copyOf(legalMoves);
    }

    private static Collection<BasePiece> calculateActivePieces(List<BaseChessTile> gameBoard, PieceColor pieceColor) {
        ArrayList<BasePiece> activePieces = new ArrayList<BasePiece>();
        for (BaseChessTile tile : gameBoard) {
            BasePiece piece;
            if (!tile.isTileOccupied() || (piece = tile.getPiece()).getPieceColor() != pieceColor) continue;
            activePieces.add(piece);
        }
        return ImmutableList.copyOf(activePieces);
    }

    public BaseChessTile getTile(int tileCoordinate) {
        return this.gameBoard.get(tileCoordinate);
    }

    private static List<BaseChessTile> createGameBoard(Builder builder) {
        Object[] tiles = new BaseChessTile[64];
        for (int i = 0; i < 64; ++i) {
            tiles[i] = BaseChessTile.createTile(i, builder.boardConfig.get(i));
        }
        return ImmutableList.copyOf((Object[])tiles);
    }

    public static Board createStandardBoard() {
        Builder builder = new Builder();
        builder.setPiece(new RookPiece(PieceColor.BLACK, 0));
        builder.setPiece(new KnightPiece(PieceColor.BLACK, 1));
        builder.setPiece(new BishopPiece(PieceColor.BLACK, 2));
        builder.setPiece(new QueenPiece(PieceColor.BLACK, 3));
        builder.setPiece(new KingPiece(PieceColor.BLACK, 4, true, true));
        builder.setPiece(new BishopPiece(PieceColor.BLACK, 5));
        builder.setPiece(new KnightPiece(PieceColor.BLACK, 6));
        builder.setPiece(new RookPiece(PieceColor.BLACK, 7));
        builder.setPiece(new PawnPiece(PieceColor.BLACK, 8));
        builder.setPiece(new PawnPiece(PieceColor.BLACK, 9));
        builder.setPiece(new PawnPiece(PieceColor.BLACK, 10));
        builder.setPiece(new PawnPiece(PieceColor.BLACK, 11));
        builder.setPiece(new PawnPiece(PieceColor.BLACK, 12));
        builder.setPiece(new PawnPiece(PieceColor.BLACK, 13));
        builder.setPiece(new PawnPiece(PieceColor.BLACK, 14));
        builder.setPiece(new PawnPiece(PieceColor.BLACK, 15));
        builder.setPiece(new PawnPiece(PieceColor.WHITE, 48));
        builder.setPiece(new PawnPiece(PieceColor.WHITE, 49));
        builder.setPiece(new PawnPiece(PieceColor.WHITE, 50));
        builder.setPiece(new PawnPiece(PieceColor.WHITE, 51));
        builder.setPiece(new PawnPiece(PieceColor.WHITE, 52));
        builder.setPiece(new PawnPiece(PieceColor.WHITE, 53));
        builder.setPiece(new PawnPiece(PieceColor.WHITE, 54));
        builder.setPiece(new PawnPiece(PieceColor.WHITE, 55));
        builder.setPiece(new RookPiece(PieceColor.WHITE, 56));
        builder.setPiece(new KnightPiece(PieceColor.WHITE, 57));
        builder.setPiece(new BishopPiece(PieceColor.WHITE, 58));
        builder.setPiece(new QueenPiece(PieceColor.WHITE, 59));
        builder.setPiece(new KingPiece(PieceColor.WHITE, 60, true, true));
        builder.setPiece(new BishopPiece(PieceColor.WHITE, 61));
        builder.setPiece(new KnightPiece(PieceColor.WHITE, 62));
        builder.setPiece(new RookPiece(PieceColor.WHITE, 63));
        builder.setMoveMaker(PieceColor.WHITE);
        return builder.build();
    }

    public Iterable<BaseMove> getAllLegalMoves() {
        return Iterables.unmodifiableIterable((Iterable)Iterables.concat(this.whiteChessPlayer.getLegalMoves(), this.blackChessPlayer.getLegalMoves()));
    }

    public static class Builder {
        Map<Integer, BasePiece> boardConfig = new HashMap<Integer, BasePiece>();
        PieceColor nextMoveMaker;
        PawnPiece enPassantPawn;

        public Builder setPiece(BasePiece piece) {
            this.boardConfig.put(piece.getPiecePosition(), piece);
            return this;
        }

        public Builder setMoveMaker(PieceColor nextMoveMaker) {
            this.nextMoveMaker = nextMoveMaker;
            return this;
        }

        public void setEnPassantPawn(PawnPiece enPassantPawn) {
            this.enPassantPawn = enPassantPawn;
        }

        public Board build() {
            return new Board(this);
        }
    }
}

