/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.animation.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class AdvancedModelPart
extends ModelPart {
    private final float MC_SCALE = 0.0625f;
    private final String name;
    private AdvancedModelPart parent;

    public AdvancedModelPart(List<ModelPart.Cube> cubes, Map<String, ModelPart> children, String name) {
        super(cubes, children);
        this.name = name;
        for (ModelPart childModel : children.values()) {
            if (!(childModel instanceof AdvancedModelPart)) continue;
            AdvancedModelPart advancedModelPart = (AdvancedModelPart)childModel;
            advancedModelPart.parent = this;
        }
    }

    public AdvancedModelPart(ModelPart modelPart) {
        this(modelPart.f_104212_, modelPart.f_104213_, null);
    }

    public AdvancedModelPart getChild(String pName) {
        ModelPart modelpart = (ModelPart)this.f_104213_.get(pName);
        if (modelpart != null) {
            return modelpart instanceof AdvancedModelPart ? (AdvancedModelPart)modelpart : new AdvancedModelPart(modelpart);
        }
        throw new NoSuchElementException("Can't find part " + pName);
    }

    public Vector3f getTotalRotation() {
        Vector3f vec = new Vector3f();
        this.addRotations(vec, this);
        return vec;
    }

    private void addRotations(Vector3f rotation, AdvancedModelPart part) {
        if (part.hasParent()) {
            this.addRotations(rotation, part.getParent());
        }
        rotation.add(part.f_104203_, part.f_104204_, part.f_104205_);
    }

    public Matrix4f getMatrix4f(Entity entity) {
        PoseStack poseStack = new PoseStack();
        if (entity != null) {
            poseStack.m_252781_(Axis.f_252392_.m_252977_(Mth.m_14179_((float)Minecraft.m_91087_().getPartialTick(), (float)((LivingEntity)entity).f_20884_, (float)((LivingEntity)entity).f_20883_)));
        }
        poseStack.m_252880_(0.0f, 1.5f, 0.0f);
        poseStack.m_85841_(1.0f, -1.0f, -1.0f);
        this.getTransformForPart(poseStack, this);
        return poseStack.m_85850_().m_252922_();
    }

    public Vector3f getModelSpace(Entity entity) {
        PoseStack poseStack = new PoseStack();
        if (entity != null) {
            poseStack.m_252781_(Axis.f_252392_.m_252977_(Mth.m_14179_((float)Minecraft.m_91087_().getPartialTick(), (float)((LivingEntity)entity).f_20884_, (float)((LivingEntity)entity).f_20883_)));
        }
        poseStack.m_252880_(0.0f, 1.5f, 0.0f);
        poseStack.m_85841_(1.0f, -1.0f, -1.0f);
        this.getTransformForPart(poseStack, this);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Vector4f vec = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        vec.mul((Matrix4fc)matrix4f);
        return new Vector3f(vec.x(), vec.y(), vec.z());
    }

    private void getTransformForPart(PoseStack poseStack, AdvancedModelPart advancedModelPart) {
        if (advancedModelPart.hasParent()) {
            this.getTransformForPart(poseStack, advancedModelPart.getParent());
        }
        poseStack.m_252880_(0.0625f * advancedModelPart.f_104200_, 0.0625f * advancedModelPart.f_104201_, 0.0625f * advancedModelPart.f_104202_);
        if (advancedModelPart.f_104203_ != 0.0f || advancedModelPart.f_104204_ != 0.0f || advancedModelPart.f_104205_ != 0.0f) {
            poseStack.m_252781_(new Quaternionf().rotationZYX(advancedModelPart.f_104205_, advancedModelPart.f_104204_, advancedModelPart.f_104203_));
        }
        if (advancedModelPart.f_233553_ != 1.0f || advancedModelPart.f_233554_ != 1.0f || advancedModelPart.f_233555_ != 1.0f) {
            poseStack.m_85841_(advancedModelPart.f_233553_, advancedModelPart.f_233554_, advancedModelPart.f_233555_);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public AdvancedModelPart getParent() {
        return this.parent;
    }
}

