/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.dynamicpack;

import com.google.gson.JsonParser;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.GlobeManager;
import net.mehvahdjukaar.supplementaries.client.renderers.color.ColorHelper;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ClientDynamicResourcesGenerator
extends DynClientResourcesGenerator {
    public static final ClientDynamicResourcesGenerator INSTANCE = new ClientDynamicResourcesGenerator();

    public ClientDynamicResourcesGenerator() {
        super(new DynamicTexturePack(Supplementaries.res("generated_pack")));
        ((DynamicTexturePack)this.dynamicPack).addNamespaces(new String[]{"minecraft"});
        ((DynamicTexturePack)this.dynamicPack).setGenerateDebugResources(PlatHelper.isDev() || CommonConfigs.General.DEBUG_RESOURCES.get() != false);
    }

    public Logger getLogger() {
        return Supplementaries.LOGGER;
    }

    public boolean dependsOnLoadedPacks() {
        return true;
    }

    public void regenerateDynamicAssets(ResourceManager manager) {
        Respriter respriter;
        TextureImage template;
        GlobeManager.refreshColorsAndTextures(manager);
        ColorHelper.refreshBubbleColors(manager);
        if (CommonConfigs.Redstone.ENDERMAN_HEAD_ENABLED.get().booleanValue()) {
            try (TextureImage text2 = TextureImage.open((ResourceManager)manager, (ResourceLocation)new ResourceLocation("entity/enderman/enderman"));
                 TextureImage eyeText = TextureImage.open((ResourceManager)manager, (ResourceLocation)new ResourceLocation("entity/enderman/enderman_eyes"));){
                ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(Supplementaries.res("entity/enderman_head"), text2, false);
                ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(Supplementaries.res("entity/enderman_head_eyes"), eyeText, false);
            }
            catch (Exception text2) {
                // empty catch block
            }
        }
        if (CommonConfigs.Tools.ROPE_ARROW_ENABLED.get().booleanValue()) {
            RPUtils.appendModelOverride((ResourceManager)manager, (DynamicTexturePack)((DynamicTexturePack)this.dynamicPack), (ResourceLocation)new ResourceLocation("crossbow"), e -> e.add(new ItemOverride(new ResourceLocation("item/crossbow_rope_arrow"), List.of(new ItemOverride.Predicate(new ResourceLocation("charged"), 1.0f), new ItemOverride.Predicate(Supplementaries.res("rope_arrow"), 1.0f)))));
        }
        if (CommonConfigs.Tools.ANTIQUE_INK_ENABLED.get().booleanValue()) {
            RPUtils.appendModelOverride((ResourceManager)manager, (DynamicTexturePack)((DynamicTexturePack)this.dynamicPack), (ResourceLocation)new ResourceLocation("written_book"), e -> e.add(new ItemOverride(new ResourceLocation("item/written_book_tattered"), List.of(new ItemOverride.Predicate(Supplementaries.res("antique_ink"), 1.0f)))));
            RPUtils.appendModelOverride((ResourceManager)manager, (DynamicTexturePack)((DynamicTexturePack)this.dynamicPack), (ResourceLocation)new ResourceLocation("filled_map"), e -> e.add(new ItemOverride(new ResourceLocation("item/antique_map"), List.of(new ItemOverride.Predicate(Supplementaries.res("antique_ink"), 1.0f)))));
        }
        RPUtils.appendModelOverride((ResourceManager)manager, (DynamicTexturePack)((DynamicTexturePack)this.dynamicPack), (ResourceLocation)Supplementaries.res("globe"), e -> {
            int i = 0;
            for (ResourceLocation text : GlobeManager.Type.textures) {
                String name = text.m_135815_().split("/")[3].split("\\.")[0];
                e.add(new ItemOverride(Supplementaries.res("item/" + name), List.of(new ItemOverride.Predicate(Supplementaries.res("type"), (float)i))));
                ++i;
                ((DynamicTexturePack)this.dynamicPack).addItemModel(Supplementaries.res(name), JsonParser.parseString((String)("{\n    \"parent\": \"item/generated\",\n    \"textures\": {\n        \"layer0\": \"supplementaries:item/globes/" + name + "\"    }\n}\n")));
            }
        });
        StaticResource spItemModel = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.ITEM_MODELS.getPath(Supplementaries.res("sign_post_oak")));
        StaticResource spBlockModel = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(Supplementaries.res("sign_posts/sign_post_oak")));
        ModRegistry.SIGN_POST_ITEMS.forEach((wood, sign) -> {
            String id = Utils.getID((Item)sign).m_135815_();
            try {
                this.addSimilarJsonResource(manager, spItemModel, "sign_post_oak", id);
                this.addSimilarJsonResource(manager, spBlockModel, "sign_post_oak", id);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Sign Post item model for {} : {}", (Object)sign, (Object)ex);
            }
        });
        try {
            template = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res("item/sign_posts/template"));
            try {
                respriter = Respriter.of((TextureImage)template);
                ModRegistry.SIGN_POST_ITEMS.forEach((wood, sign) -> {
                    ResourceLocation textureRes = Supplementaries.res("item/sign_posts/" + Utils.getID((Item)sign).m_135815_());
                    if (this.alreadyHasTextureAtLocation(manager, textureRes)) {
                        return;
                    }
                    TextureImage newImage = null;
                    Item signItem = wood.getItemOfThis("sign");
                    if (signItem != null) {
                        try (TextureImage vanillaSign2 = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstItemTextureLocation((ResourceManager)manager, (Item)signItem));
                             TextureImage signMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res("item/hanging_signs/sign_board_mask"));){
                            List targetPalette = Palette.fromAnimatedImage((TextureImage)vanillaSign2, (TextureImage)signMask);
                            newImage = respriter.recolor(targetPalette);
                            try (TextureImage scribbles = ClientDynamicResourcesGenerator.recolorFromVanilla(manager, vanillaSign2, Supplementaries.res("item/hanging_signs/sign_scribbles_mask"), Supplementaries.res("item/sign_posts/scribbles_template"));){
                                newImage.applyOverlay(new TextureImage[]{scribbles});
                            }
                            catch (Exception ex) {
                                this.getLogger().error("Could not properly color Sign Post item texture for {} : {}", (Object)sign, (Object)ex);
                            }
                        }
                        catch (Exception vanillaSign2) {
                            // empty catch block
                        }
                    }
                    if (newImage == null) {
                        try (TextureImage plankPalette = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                            Palette targetPalette = SpriteUtils.extrapolateWoodItemPalette((TextureImage)plankPalette);
                            newImage = respriter.recolor(targetPalette);
                        }
                        catch (Exception ex) {
                            this.getLogger().error("Failed to generate Sign Post item texture for for {} : {}", (Object)sign, (Object)ex);
                        }
                    }
                    if (newImage != null) {
                        ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(textureRes, newImage);
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any Sign Post item texture : ", (Throwable)ex);
        }
        try {
            template = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res("block/sign_posts/sign_post_oak"));
            try {
                respriter = Respriter.of((TextureImage)template);
                ModRegistry.SIGN_POST_ITEMS.forEach((wood, sign) -> {
                    ResourceLocation textureRes = Supplementaries.res("block/sign_posts/" + Utils.getID((Item)sign).m_135815_());
                    if (this.alreadyHasTextureAtLocation(manager, textureRes)) {
                        return;
                    }
                    try (TextureImage plankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                        Palette palette = Palette.fromImage((TextureImage)plankTexture);
                        TextureImage newImage = respriter.recolor(palette);
                        ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(textureRes, newImage);
                    }
                    catch (Exception ex) {
                        this.getLogger().error("Failed to generate Sign Post block texture for for {} : {}", (Object)sign, (Object)ex);
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any Sign Post block texture : ", (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static TextureImage recolorFromVanilla(ResourceManager manager, TextureImage vanillaTexture, ResourceLocation vanillaMask, ResourceLocation templateTexture) {
        try (TextureImage scribbleMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)vanillaMask);){
            TextureImage textureImage;
            block14: {
                TextureImage template = TextureImage.open((ResourceManager)manager, (ResourceLocation)templateTexture);
                try {
                    Respriter respriter = Respriter.of((TextureImage)template);
                    Palette palette = Palette.fromImage((TextureImage)vanillaTexture, (TextureImage)scribbleMask);
                    textureImage = respriter.recolor(palette);
                    if (template == null) break block14;
                }
                catch (Throwable throwable) {
                    if (template != null) {
                        try {
                            template.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                template.close();
            }
            return textureImage;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void addDynamicTranslations(AfterLanguageLoadEvent lang) {
        ModRegistry.SIGN_POST_ITEMS.forEach((type, item) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)"item.supplementaries.sign_post", (BlockType)type, (Item)item));
    }
}

