/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.block.IOwnerProtected;
import net.mehvahdjukaar.moonlight.api.client.IScreenProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.BlackboardManager;
import net.mehvahdjukaar.supplementaries.client.screens.BlackBoardScreen;
import net.mehvahdjukaar.supplementaries.common.block.IOnePlayerInteractable;
import net.mehvahdjukaar.supplementaries.common.block.IWaxable;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.NoticeBoardBlock;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BlackboardBlockTile
extends BlockEntity
implements IOwnerProtected,
IOnePlayerInteractable,
IScreenProvider,
IWaxable,
IExtraModelDataProvider {
    public static final ModelDataKey<BlackboardManager.Key> BLACKBOARD_KEY = ModBlockProperties.BLACKBOARD;
    private UUID owner = null;
    private boolean waxed = false;
    private byte[][] pixels = new byte[16][16];
    @Nullable
    private UUID playerWhoMayEdit = null;
    private BlackboardManager.Key textureKey = null;

    public BlackboardBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.BLACKBOARD_TILE.get(), pos, state);
        this.clear();
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        builder.with(BLACKBOARD_KEY, (Object)this.getTextureKey());
    }

    public BlackboardManager.Key getTextureKey() {
        if (this.textureKey == null) {
            this.refreshTextureKey();
        }
        return this.textureKey;
    }

    public void refreshTextureKey() {
        this.textureKey = BlackboardManager.Key.of(BlackboardBlockTile.packPixels(this.pixels), (Boolean)this.m_58900_().m_61143_((Property)BlackboardBlock.GLOWING));
    }

    public void afterDataPacket(ExtraModelData oldData) {
        this.refreshTextureKey();
        super.afterDataPacket(oldData);
    }

    public void m_6596_() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        super.m_6596_();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.loadFromTag(compound);
        this.loadOwner(compound);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.savePixels(compound);
        this.saveOwner(compound);
    }

    public CompoundTag savePixels(CompoundTag compound) {
        if (this.waxed) {
            compound.m_128379_("Waxed", true);
        }
        compound.m_128388_("Pixels", BlackboardBlockTile.packPixels(this.pixels));
        return compound;
    }

    public void loadFromTag(CompoundTag compound) {
        this.waxed = compound.m_128441_("Waxed") && compound.m_128471_("Waxed");
        this.pixels = new byte[16][16];
        if (compound.m_128441_("Pixels")) {
            this.pixels = BlackboardBlockTile.unpackPixels(compound.m_128467_("Pixels"));
        }
    }

    public static long[] packPixels(byte[][] pixels) {
        long[] packed = new long[pixels.length];
        for (int i = 0; i < pixels.length; ++i) {
            long l = 0L;
            for (int j = 0; j < pixels[i].length; ++j) {
                l |= (long)(pixels[i][j] & 0xF) << j * 4;
            }
            packed[i] = l;
        }
        return packed;
    }

    public static byte[][] unpackPixels(long[] packed) {
        byte[][] bytes = new byte[16][16];
        for (int i = 0; i < packed.length; ++i) {
            for (int j = 0; j < 16; ++j) {
                bytes[i][j] = (byte)(packed[i] >> j * 4 & 0xFL);
            }
        }
        return bytes;
    }

    public static String packPixelsToString(long[] packed) {
        StringBuilder builder = new StringBuilder();
        for (long l : packed) {
            char a = (char)(l & 0xFFFFL);
            char b = (char)(l >> 16 & 0xFFFFL);
            char c = (char)(l >> 32 & 0xFFFFL);
            char d = (char)(l >> 48 & 0xFFFFL);
            builder.append(a).append(b).append(c).append(d);
        }
        return builder.toString();
    }

    public static long[] unpackPixelsFromString(String packed) {
        long[] unpacked = new long[16];
        char[] chars = packed.toCharArray();
        int j = 0;
        int i = 0;
        while (i + 3 < chars.length) {
            unpacked[j] = (long)chars[i + 3] << 48 | (long)chars[i + 2] << 32 | (long)chars[i + 1] << 16 | (long)chars[i];
            ++j;
            i += 4;
        }
        return unpacked;
    }

    public static long[] unpackPixelsFromStringWhiteOnly(String packed) {
        long[] unpacked = new long[16];
        char[] chars = packed.toCharArray();
        int j = 0;
        int i = 0;
        while (i + 3 < chars.length) {
            long l = 0L;
            char c = chars[i];
            for (int k = 0; k < 4; ++k) {
                l |= (long)((c >> k & 1) << 4 * k);
            }
            char c2 = chars[i + 1];
            for (int k = 0; k < 4; ++k) {
                l |= (long)(c2 >> k & 1) << 16 + 4 * k;
            }
            char c3 = chars[i + 2];
            for (int k = 0; k < 4; ++k) {
                l |= (long)(c3 >> k & 1) << 32 + 4 * k;
            }
            char c4 = chars[i + 3];
            for (int k = 0; k < 4; ++k) {
                l |= (long)(c4 >> k & 1) << 48 + 4 * k;
            }
            unpacked[j] = l;
            ++j;
            i += 4;
        }
        return unpacked;
    }

    public static String packPixelsToStringWhiteOnly(long[] packed) {
        StringBuilder builder = new StringBuilder();
        for (long l : packed) {
            char c = '\u0000';
            for (int k = 0; k < 4; ++k) {
                byte h = (byte)(l >> 4 * k & 1L);
                c = (char)(c | h << k);
            }
            char c1 = '\u0000';
            for (int k = 0; k < 4; ++k) {
                byte h = (byte)(l >> 16 + 4 * k & 1L);
                c1 = (char)(c1 | h << k);
            }
            char c2 = '\u0000';
            for (int k = 0; k < 4; ++k) {
                byte h = (byte)(l >> 32 + 4 * k & 1L);
                c2 = (char)(c2 | h << k);
            }
            char c3 = '\u0000';
            for (int k = 0; k < 4; ++k) {
                byte h = (byte)(l >> 48 + 4 * k & 1L);
                c3 = (char)(c3 | h << k);
            }
            builder.append(c).append(c1).append(c2).append(c3);
        }
        return builder.toString();
    }

    public void clear() {
        for (int x = 0; x < this.pixels.length; ++x) {
            for (int y = 0; y < this.pixels[x].length; ++y) {
                this.pixels[x][y] = 0;
            }
        }
    }

    public boolean isEmpty() {
        boolean flag = false;
        byte[][] byArray = this.pixels;
        int n = byArray.length;
        block0: for (int i = 0; i < n; ++i) {
            byte[] pixel;
            for (byte b : pixel = byArray[i]) {
                if (b == 0) continue;
                flag = true;
                continue block0;
            }
        }
        return !flag;
    }

    public void setPixel(int x, int y, byte b) {
        this.pixels[x][y] = b;
    }

    public byte getPixel(int xx, int yy) {
        return this.pixels[xx][yy];
    }

    public void setPixels(byte[][] pixels) {
        this.pixels = pixels;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)NoticeBoardBlock.FACING);
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public void openScreen(Level level, BlockPos pos, Player player) {
        BlackBoardScreen.open(this);
    }

    @Override
    public void setWaxed(boolean b) {
        this.waxed = b;
    }

    @Override
    public boolean isWaxed() {
        return this.waxed;
    }

    @Override
    public UUID getPlayerWhoMayEdit() {
        return this.playerWhoMayEdit;
    }

    @Override
    public void setPlayerWhoMayEdit(UUID playerWhoMayEdit) {
        this.playerWhoMayEdit = playerWhoMayEdit;
    }

    public boolean tryAcceptingClientPixels(ServerPlayer player, byte[][] pixels) {
        if (this.isEditingPlayer((Player)player)) {
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12565_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.setPixels(pixels);
            this.setPlayerWhoMayEdit(null);
            return true;
        }
        Supplementaries.LOGGER.warn("Player {} just tried to change non-editable blackboard block", (Object)player.m_7755_().getString());
        return false;
    }
}

