/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.faucet;

import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetTarget;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FluidOffer;
import net.mehvahdjukaar.supplementaries.integration.FarmersRespriteCompat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

class KettleInteraction
implements FaucetTarget.BlState,
FaucetSource.BlState {
    KettleInteraction() {
    }

    @Override
    public FluidOffer getProvidedFluid(Level level, BlockPos pos, Direction dir, BlockState state) {
        IntegerProperty p;
        int waterLevel;
        if (FarmersRespriteCompat.isKettle(state) && (waterLevel = ((Integer)state.m_61143_((Property)(p = FarmersRespriteCompat.getWaterLevel()))).intValue()) > 0) {
            return FluidOffer.of((Holder<SoftFluid>)BuiltInSoftFluids.WATER.getHolder(), waterLevel);
        }
        return null;
    }

    @Override
    public void drain(Level level, BlockPos pos, Direction dir, BlockState state, int amount) {
        if (FarmersRespriteCompat.isKettle(state)) {
            IntegerProperty p = FarmersRespriteCompat.getWaterLevel();
            int waterLevel = (Integer)state.m_61143_((Property)p);
            amount = Math.min(amount, waterLevel);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)p, (Comparable)Integer.valueOf(amount)), 3);
        }
    }

    @Override
    public Integer fill(Level level, BlockPos pos, BlockState state, SoftFluidStack fluid, int minAmount) {
        if (FarmersRespriteCompat.isKettle(state)) {
            IntegerProperty p = FarmersRespriteCompat.getWaterLevel();
            int waterLevel = (Integer)state.m_61143_((Property)p);
            if (waterLevel == 3) {
                return 0;
            }
            int newWater = Math.max(waterLevel + minAmount, 3);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)p, (Comparable)Integer.valueOf(newWater)), 3);
            return minAmount;
        }
        return null;
    }
}

