/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.block.IRotatable;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FenceMimicBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SignPostBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SignPostBlock
extends FenceMimicBlock
implements EntityBlock,
IRotatable {
    public SignPostBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (level instanceof ServerLevel) {
            SignPostBlockTile tile;
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack itemstack = player.m_21120_(handIn);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof SignPostBlockTile && (tile = (SignPostBlockTile)blockEntity).isAccessibleBy(player)) {
                return tile.handleInteraction(state, serverLevel, pos, player, handIn, hit, itemstack);
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof SignPostBlockTile) {
            SignPostBlockTile tile = (SignPostBlockTile)blockEntity;
            SignPostBlockTile.Sign sign = tile.getClickedSign(target.m_82450_());
            if (sign.active()) {
                return sign.getItem();
            }
            return new ItemStack((ItemLike)tile.getHeldBlock().m_60734_());
        }
        return new ItemStack((ItemLike)this);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        Object object = builder.m_287159_(LootContextParams.f_81462_);
        if (object instanceof SignPostBlockTile) {
            SignPostBlockTile tile = (SignPostBlockTile)object;
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            list.add(new ItemStack((ItemLike)tile.getHeldBlock().m_60734_()));
            SignPostBlockTile.Sign up = tile.getSignUp();
            SignPostBlockTile.Sign down = tile.getSignDown();
            if (up.active()) {
                list.add(up.getItem());
            }
            if (down.active()) {
                list.add(down.getItem());
            }
            return list;
        }
        return super.m_49635_(state, builder);
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rot) {
        return state;
    }

    public Optional<BlockState> getRotatedState(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation, Direction axis, @Nullable Vec3 hit) {
        return Optional.of(state);
    }

    public Optional<Direction> rotateOverAxis(BlockState state, LevelAccessor world, BlockPos pos, Rotation rot, Direction axis, @Nullable Vec3 hit) {
        boolean success = false;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof SignPostBlockTile) {
            float angle;
            SignPostBlockTile tile = (SignPostBlockTile)blockEntity;
            boolean simple = hit == null;
            boolean ccw = rot.equals((Object)Rotation.COUNTERCLOCKWISE_90);
            float f = simple ? (float)(ccw ? 90 : -90) : (angle = 22.5f * (float)(ccw ? 1 : -1));
            if (simple) {
                if (tile.rotateSign(true, angle, false)) {
                    success = true;
                }
                if (tile.rotateSign(false, angle, false)) {
                    success = true;
                }
            } else {
                boolean up;
                boolean bl = up = hit.f_82480_ % (double)((int)hit.f_82480_) > 0.5;
                if (tile.rotateSign(up, angle, true)) {
                    success = true;
                } else if (tile.rotateSign(!up, angle, true)) {
                    success = true;
                }
            }
            if (success) {
                tile.m_6596_();
                if (world instanceof Level) {
                    Level level = (Level)world;
                    level.m_7260_(pos, state, state, 3);
                }
                return Optional.of(Direction.UP);
            }
        }
        return Optional.empty();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new SignPostBlockTile(pPos, pState);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockUtil.addOptionalOwnership(placer, worldIn, pos);
    }
}

