/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.client.screens.widgets.DrawableBlackBoardButton;
import net.mehvahdjukaar.supplementaries.client.screens.widgets.DyeBlackBoardButton;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.common.network.ModNetwork;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundSetBlackboardPacket;
import net.mehvahdjukaar.supplementaries.common.utils.CircularList;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.ImmediatelyFastCompat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class BlackBoardScreen
extends Screen {
    private static final MutableComponent CLEAR = Component.m_237115_((String)"gui.supplementaries.blackboard.clear");
    private static final MutableComponent UNDO = Component.m_237115_((String)"gui.supplementaries.blackboard.undo");
    private static final MutableComponent EDIT = Component.m_237115_((String)"gui.supplementaries.blackboard.edit");
    private final BlackboardBlockTile tile;
    private final DrawableBlackBoardButton[][] buttons = new DrawableBlackBoardButton[16][16];
    private final Deque<List<Entry>> history = new CircularList<List<Entry>>(20);
    private List<Entry> currentHistoryStep = new ArrayList<Entry>();
    private Button historyButton;
    private byte selectedColor = 1;

    private BlackBoardScreen(BlackboardBlockTile teBoard) {
        super((Component)EDIT);
        this.tile = teBoard;
    }

    public static void open(BlackboardBlockTile sign) {
        Minecraft.m_91087_().m_91152_((Screen)new BlackBoardScreen(sign));
    }

    public void m_86600_() {
        if (!this.isValid()) {
            this.m_7379_();
        } else if (!(this.m_7222_() instanceof DrawableBlackBoardButton)) {
            this.m_7522_(null);
        }
    }

    private boolean isValid() {
        return this.f_96541_ != null && this.f_96541_.f_91074_ != null && !this.tile.m_58901_() && !this.tile.isEditingPlayer((Player)this.f_96541_.f_91074_);
    }

    public byte getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(byte color) {
        this.selectedColor = color;
    }

    public void m_7379_() {
        this.tile.m_6596_();
        super.m_7379_();
    }

    public void m_7861_() {
        byte[][] pixels = new byte[16][16];
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                pixels[xx][yy] = this.buttons[xx][yy].getColor();
            }
        }
        ModNetwork.CHANNEL.sendToServer((Message)new ServerBoundSetBlackboardPacket(this.tile.m_58899_(), pixels));
    }

    public void updateBlackboard(int x, int y, byte newColor) {
        this.tile.setPixel(x, y, newColor);
    }

    public void addHistory(int x, int y, byte oldColor) {
        this.currentHistoryStep.add(new Entry(x, y, oldColor));
    }

    public void saveHistoryStep() {
        if (!this.currentHistoryStep.isEmpty()) {
            this.history.add(this.currentHistoryStep);
            this.currentHistoryStep = new ArrayList<Entry>();
            this.historyButton.f_93623_ = true;
        }
    }

    public void onButtonDragged(double mx, double my, byte buttonValue) {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                DrawableBlackBoardButton b = this.buttons[xx][yy];
                if (!b.m_5953_(mx, my) || b.getColor() == buttonValue) continue;
                b.setColor(buttonValue);
            }
        }
    }

    private void clearPressed(Button button) {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                this.buttons[xx][yy].setColor((byte)0);
            }
        }
        this.saveHistoryStep();
    }

    private void undoPressed(Button button) {
        if (!this.history.isEmpty()) {
            for (Entry v : this.history.pollLast()) {
                this.buttons[v.x()][v.y()].setColor(v.color());
            }
            this.currentHistoryStep.clear();
        }
        if (this.history.isEmpty()) {
            this.historyButton.f_93623_ = false;
        }
    }

    protected void m_7856_() {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                byte pixel = this.tile.getPixel(xx, yy);
                DrawableBlackBoardButton widget = new DrawableBlackBoardButton(this, this.f_96543_ / 2, 65, xx, yy, pixel);
                this.buttons[xx][yy] = (DrawableBlackBoardButton)this.m_142416_(widget);
            }
        }
        int buttonW = 56;
        int sep = 4;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CLEAR, this::clearPressed).m_252987_(this.f_96543_ / 2 - buttonW / 2 - buttonW + sep / 2, this.f_96544_ / 4 + 120, buttonW - sep, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - buttonW / 2 + sep / 2, this.f_96544_ / 4 + 120, buttonW - sep, 20).m_253136_());
        this.historyButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)UNDO, this::undoPressed).m_252987_(this.f_96543_ / 2 + buttonW / 2 + sep / 2, this.f_96544_ / 4 + 120, buttonW - sep, 20).m_253136_());
        if (CommonConfigs.Building.BLACKBOARD_COLOR.get().booleanValue() || PlatHelper.isDev()) {
            for (byte b = 0; b < 16; b = (byte)(b + 1)) {
                int ox = b % 2;
                int oy = b / 2;
                this.m_142416_(new DyeBlackBoardButton(this, this.f_96543_ / 2 - 78 + ox * 10, 73 + oy * 10, b));
            }
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 40, 0xFFFFFF);
        if (CompatHandler.IMMEDIATELY_FAST) {
            ImmediatelyFastCompat.startBatching();
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280168_().m_85836_();
        block0: for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                DrawableBlackBoardButton button = this.buttons[xx][yy];
                if (!button.isShouldDrawOverlay()) continue;
                button.renderHoverOverlay(graphics);
                break block0;
            }
        }
        graphics.m_280168_().m_85849_();
        if (CompatHandler.IMMEDIATELY_FAST) {
            ImmediatelyFastCompat.endBatching();
        }
    }

    private record Entry(int x, int y, byte color) {
    }
}

