/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.commands;

import com.legacy.structure_gel.core.capability.level.BuildingToolPlayerData;
import com.legacy.structure_gel.core.item.building_tool.ActionHistory;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class BuildingToolCommand {
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_LEVEL_PLAYERS = (context, builder) -> SharedSuggestionProvider.m_82970_(ActionHistory.getHistoryOwners((Level)((CommandSourceStack)context.getSource()).m_81372_()), (SuggestionsBuilder)builder);
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_ALL_PLAYERS = (context, builder) -> SharedSuggestionProvider.m_82970_(ActionHistory.getHistoryOwners(((CommandSourceStack)context.getSource()).m_81377_()), (SuggestionsBuilder)builder);

    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.m_82127_((String)"building_tool").requires(source -> source.m_6761_(2));
        command.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"undo").executes(context -> BuildingToolCommand.undo((CommandContext<CommandSourceStack>)context, ((CommandSourceStack)context.getSource()).m_81375_().m_36316_().getName(), 1))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_LEVEL_PLAYERS).executes(context -> BuildingToolCommand.undo((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"player"), 1))).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> BuildingToolCommand.undo((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"))))));
        command.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"redo").executes(context -> BuildingToolCommand.redo((CommandContext<CommandSourceStack>)context, ((CommandSourceStack)context.getSource()).m_81375_().m_36316_().getName(), 1))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_LEVEL_PLAYERS).executes(context -> BuildingToolCommand.redo((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"player"), 1))).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> BuildingToolCommand.redo((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"))))));
        command.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"clear_history").executes(context -> BuildingToolCommand.clearActions((CommandContext<CommandSourceStack>)context, ((CommandSourceStack)context.getSource()).m_81375_().m_36316_().getName()))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_ALL_PLAYERS).executes(context -> BuildingToolCommand.clearActions((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"player")))).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(context -> BuildingToolCommand.clearActions((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"player"), DimensionArgument.m_88808_((CommandContext)context, (String)"dimension"))))));
        command.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"clear_clipboard").executes(context -> BuildingToolCommand.clearClipboard((CommandContext<CommandSourceStack>)context, ((CommandSourceStack)context.getSource()).m_81375_().m_36316_().getName()))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_ALL_PLAYERS).executes(context -> BuildingToolCommand.clearClipboard((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"player")))).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(context -> BuildingToolCommand.clearClipboard((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"player"), DimensionArgument.m_88808_((CommandContext)context, (String)"dimension"))))));
        return command;
    }

    private static int undo(CommandContext<CommandSourceStack> context, String playerName, int amount) {
        return BuildingToolCommand.undoOrRedo(context, playerName, amount, true);
    }

    private static int redo(CommandContext<CommandSourceStack> context, String playerName, int amount) {
        return BuildingToolCommand.undoOrRedo(context, playerName, amount, false);
    }

    private static int undoOrRedo(CommandContext<CommandSourceStack> context, String playerName, int amount, boolean undo) {
        Consumer<ServerPlayer> action;
        String doing;
        ActionHistory history = ActionHistory.get(playerName, (Level)((CommandSourceStack)context.getSource()).m_81372_());
        if (history.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)(playerName + " has no action history.")));
            return 0;
        }
        String string = doing = undo ? "undo" : "redo";
        Consumer<ServerPlayer> consumer = undo ? history::undo : (action = history::redo);
        if (amount > 1) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Attempting to " + doing + " " + amount + " actions from " + playerName)), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Attempting to " + doing + " " + playerName + "'s last action")), true);
        }
        try {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            for (int i = 0; i < amount; ++i) {
                action.accept(player);
            }
            return 1;
        }
        catch (CommandSyntaxException e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"This command must be ran by a player since they need to be in the dimension of the action."));
            return 0;
        }
    }

    private static int clearActions(CommandContext<CommandSourceStack> context, String playerName) {
        for (ServerLevel level : ((CommandSourceStack)context.getSource()).m_81377_().m_129785_()) {
            ActionHistory history = ActionHistory.get(playerName, (Level)level);
            history.clear();
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Cleared action history for " + playerName)), true);
        return 1;
    }

    private static int clearActions(CommandContext<CommandSourceStack> context, String playerName, ServerLevel level) {
        ActionHistory history = ActionHistory.get(playerName, (Level)level);
        history.clear();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Cleared action history for " + playerName + " in " + level.m_46472_().m_135782_())), true);
        return 1;
    }

    private static int clearClipboard(CommandContext<CommandSourceStack> context, String playerName) {
        for (ServerLevel level : ((CommandSourceStack)context.getSource()).m_81377_().m_129785_()) {
            BuildingToolPlayerData data = BuildingToolPlayerData.get(level, playerName);
            data.clearClipboard();
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Cleared clipboard for " + playerName)), true);
        return 1;
    }

    private static int clearClipboard(CommandContext<CommandSourceStack> context, String playerName, ServerLevel level) {
        BuildingToolPlayerData data = BuildingToolPlayerData.get(level, playerName);
        data.clearClipboard();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Cleared clipboard for " + playerName + " in " + level.m_46472_().m_135782_())), true);
        return 1;
    }
}

