/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.registry.registrar;

import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.legacy.structure_gel.api.registry.registrar.RegistrarHandler;
import com.legacy.structure_gel.core.util.Internal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;

public class DimensionRegistrar {
    @Internal
    public static final List<DimensionRegistrar> REGISTRARS = new ArrayList<DimensionRegistrar>();
    private final Registrar.Pointer<DimensionType> dimensionType;
    private final Registrar.Pointer<NoiseGeneratorSettings> noiseSettings;
    private final Registrar.Pointer<LevelStem> levelStem;
    private final ResourceKey<Level> levelKey;

    public DimensionRegistrar(ResourceLocation registryName, Function<BootstapContext<?>, DimensionType> dimensionType, Function<BootstapContext<?>, NoiseGeneratorSettings> noiseSettings, Function<BootstapContext<?>, ChunkGenerator> chunkGeneratorFactory) {
        String modID = registryName.m_135827_();
        RegistrarHandler dimTypeHandler = RegistrarHandler.getOrCreate(Registries.f_256787_, modID);
        RegistrarHandler noiseSettingsHandler = RegistrarHandler.getOrCreate(Registries.f_256932_, modID);
        RegistrarHandler levelStemHandler = RegistrarHandler.getOrCreate(Registries.f_256862_, modID);
        this.dimensionType = dimTypeHandler.createPointer(registryName, dimensionType);
        this.noiseSettings = noiseSettingsHandler.createPointer(registryName, noiseSettings);
        this.levelStem = levelStemHandler.createPointer(registryName, c -> new LevelStem((Holder)this.dimensionType.getHolder((BootstapContext<?>)c).get(), (ChunkGenerator)chunkGeneratorFactory.apply((BootstapContext<?>)c)));
        this.levelKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)registryName);
        REGISTRARS.add(this);
    }

    public Registrar.Pointer<DimensionType> getType() {
        return this.dimensionType;
    }

    public Registrar.Pointer<NoiseGeneratorSettings> getNoiseSettings() {
        return this.noiseSettings;
    }

    public Registrar.Pointer<LevelStem> getLevelStem() {
        return this.levelStem;
    }

    public ResourceKey<Level> getLevelKey() {
        return this.levelKey;
    }
}

