/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.api.enchantment;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.spell_power.SpellPowerMod;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import net.spell_power.config.EnchantmentsConfig;

public class SpellPowerEnchanting {
    private static final ArrayList<class_1738> armor = new ArrayList();
    private static final ArrayList<Function<class_1799, Boolean>> weaponConditions = new ArrayList();

    public static void registerArmor(class_1738 ... items) {
        for (class_1738 item : items) {
            SpellPowerEnchanting.registerArmor(item);
        }
    }

    public static void registerArmor(List<class_1738> items) {
        for (class_1738 item : items) {
            SpellPowerEnchanting.registerArmor(item);
        }
    }

    @Deprecated
    public static void registerArmor(class_1738 item) {
        armor.add(item);
    }

    @Deprecated
    public static boolean isArmorRegistered(class_1792 item) {
        return armor.contains(item);
    }

    @Deprecated
    public static void allowForWeapon(Function<class_1799, Boolean> condition) {
        weaponConditions.add(condition);
    }

    public static boolean isAllowedForWeapon(class_1799 stack) {
        for (Function<class_1799, Boolean> condition : weaponConditions) {
            if (!condition.apply(stack).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static Set<SpellSchool> relevantSchools(class_1799 stack) {
        class_1792 item = stack.method_7909();
        class_1304 slot = class_1304.field_6173;
        if (item instanceof class_1738) {
            class_1738 armor = (class_1738)item;
            slot = armor.method_7685();
        }
        return SpellPowerEnchanting.relevantSchools(stack, slot);
    }

    public static Set<SpellSchool> relevantSchools(class_1799 stack, class_1304 slot) {
        HashSet<SpellSchool> schools = new HashSet<SpellSchool>();
        Multimap attributes = stack.method_7926(slot);
        for (Map.Entry entry : attributes.entries()) {
            class_1320 attribute = (class_1320)entry.getKey();
            for (SpellSchool school : SpellSchools.all()) {
                if (!school.attribute.equals(attribute)) continue;
                schools.add(school);
            }
        }
        return schools;
    }

    public static int getEnchantmentLevel(class_1887 enchantment, class_1309 entity, class_1799 provisionedWeapon) {
        int level = ((EnchantmentsConfig)((Object)SpellPowerMod.enchantmentConfig.value)).allow_stacking ? SpellPowerEnchanting.getEnchantmentLevelEquipmentSum(enchantment, entity) : class_1890.method_8203((class_1887)enchantment, (class_1309)entity);
        if (provisionedWeapon != null && !provisionedWeapon.method_7960()) {
            class_1799 mainHandStack = entity.method_6047();
            if (mainHandStack != null && !mainHandStack.method_7960()) {
                level -= class_1890.method_8225((class_1887)enchantment, (class_1799)mainHandStack);
            }
            level += class_1890.method_8225((class_1887)enchantment, (class_1799)provisionedWeapon);
        }
        return level;
    }

    public static int getEnchantmentLevelEquipmentSum(class_1887 enchantment, class_1309 entity) {
        class_1799 offHandStack;
        int level = 0;
        for (class_1799 itemStack : entity.method_5661()) {
            level += class_1890.method_8225((class_1887)enchantment, (class_1799)itemStack);
        }
        class_1799 mainHandStack = entity.method_6047();
        if (mainHandStack != null) {
            level += class_1890.method_8225((class_1887)enchantment, (class_1799)mainHandStack);
        }
        if ((offHandStack = entity.method_6079()) != null) {
            level += class_1890.method_8225((class_1887)enchantment, (class_1799)offHandStack);
        }
        return level;
    }
}

