/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.api.enchantment;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.class_1799;
import net.minecraft.class_1887;

public final class EnchantmentRestriction {
    private static HashMap<class_1887, ArrayList<Condition>> permissions = new HashMap();
    private static HashMap<class_1887, ArrayList<Condition>> prohibitions = new HashMap();

    public static void permit(class_1887 enchantment, Condition condition) {
        ArrayList<Condition> conditions = permissions.get(enchantment);
        if (conditions == null) {
            conditions = new ArrayList();
        }
        conditions.add(condition);
        permissions.put(enchantment, conditions);
    }

    public static boolean isPermitted(class_1887 enchantment, class_1799 itemStack) {
        ArrayList<Condition> conditions = permissions.get(enchantment);
        if (conditions != null) {
            for (Condition permittingCondition : conditions) {
                if (!permittingCondition.appliesForItemStack(itemStack)) continue;
                return true;
            }
        }
        return false;
    }

    public static void prohibit(class_1887 enchantment, Condition condition) {
        ArrayList<Condition> conditions = prohibitions.get(enchantment);
        if (conditions == null) {
            conditions = new ArrayList();
        }
        conditions.add(condition);
        prohibitions.put(enchantment, conditions);
    }

    public static boolean isProhibited(class_1887 enchantment, class_1799 itemStack) {
        ArrayList<Condition> conditions = prohibitions.get(enchantment);
        if (conditions != null) {
            for (Condition prohibitingCondition : conditions) {
                if (!prohibitingCondition.appliesForItemStack(itemStack)) continue;
                return true;
            }
        }
        return false;
    }

    public static interface Condition {
        public boolean appliesForItemStack(class_1799 var1);
    }
}

