/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.api;

import com.google.gson.annotations.JsonAdapter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.class_1291;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_8110;
import net.spell_power.api.misc.SpellSchoolJSONAdapter;
import org.jetbrains.annotations.Nullable;

@JsonAdapter(value=SpellSchoolJSONAdapter.class)
public class SpellSchool {
    public final Archetype archetype;
    public final class_2960 id;
    public final int color;
    public final class_1320 attribute;
    public Manage attributeManagement = Manage.INTERNAL;
    @Nullable
    public final class_1291 boostEffect;
    public Manage powerEffectManagement = Manage.INTERNAL;
    public final class_5321<class_8110> damageType;
    private HashMap<Trait, ArrayList<Source>> sources = SpellSchool.emptyTraits();

    public SpellSchool(Archetype archetype, class_2960 id, int color, class_5321<class_8110> damageType, class_1320 attribute) {
        this(archetype, id, color, damageType, attribute, null);
    }

    public SpellSchool(Archetype archetype, class_2960 id, int color, class_5321<class_8110> damageType, class_1320 attribute, @Nullable class_1291 boostEffect) {
        this.archetype = archetype;
        this.id = id;
        this.color = color;
        this.damageType = damageType;
        this.attribute = attribute;
        this.boostEffect = boostEffect;
    }

    private static HashMap<Trait, ArrayList<Source>> emptyTraits() {
        HashMap<Trait, ArrayList<Source>> map = new HashMap<Trait, ArrayList<Source>>();
        for (Trait trait : Trait.values()) {
            map.put(trait, new ArrayList());
        }
        return map;
    }

    public void addSource(Trait trait, Apply apply, Function<QueryArgs, Double> function) {
        this.addSource(trait, new Source(apply, function));
    }

    public void addSource(Trait trait, Source source) {
        this.sources.get((Object)trait).add(source);
        this.sources.get((Object)trait).sort(Comparator.comparingInt(a -> a.apply.ordinal()));
    }

    public double getValue(Trait trait, QueryArgs query) {
        ArrayList<Source> traitSources = this.sources.get((Object)trait);
        float value = 0.0f;
        switch (trait) {
            case POWER: 
            case CRIT_CHANCE: {
                value = 0.0f;
                break;
            }
            case HASTE: 
            case CRIT_DAMAGE: {
                value = 1.0f;
            }
        }
        float multiplier = 1.0f;
        for (Source source : traitSources) {
            switch (source.apply) {
                case ADD: {
                    value = (float)((double)value + source.function.apply(query));
                    break;
                }
                case MULTIPLY: {
                    multiplier = (float)((double)multiplier + source.function.apply(query));
                }
            }
        }
        return value *= multiplier;
    }

    public static enum Archetype {
        ARCHERY,
        MAGIC,
        MELEE;

    }

    public static enum Manage {
        INTERNAL,
        EXTERNAL;


        public boolean isInternal() {
            return this == INTERNAL;
        }
    }

    public static enum Trait {
        POWER,
        HASTE,
        CRIT_CHANCE,
        CRIT_DAMAGE;

    }

    public record Source(Apply apply, Function<QueryArgs, Double> function) {
    }

    public static enum Apply {
        ADD,
        MULTIPLY;

    }

    public record QueryArgs(class_1309 entity) {
    }
}

