/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.tank;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModFluids;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedTankUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IStackableContentsUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.XpHelper;

public class TankUpgradeWrapper
extends UpgradeWrapperBase<TankUpgradeWrapper, TankUpgradeItem>
implements IRenderedTankUpgrade,
ITickableUpgrade,
IStackableContentsUpgrade {
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    private static final String CONTENTS_TAG = "contents";
    private Consumer<IRenderedTankUpgrade.TankRenderInfo> updateTankRenderInfoCallback;
    private final ItemStackHandler inventory;
    private FluidStack contents;
    private long cooldownTime = 0L;
    private static final List<AlternativeFluidContainerDefinition> ALTERNATIVE_FLUID_CONTAINER_DEFINITIONS = List.of(new AlternativeFluidContainerDefinition(Items.f_42612_, Items.f_42590_, (Fluid)ModFluids.XP_STILL.get(), XpHelper.experienceToLiquid(8.0f)));

    protected TankUpgradeWrapper(IStorageWrapper storageWrapper, final ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.inventory = new ItemStackHandler(2){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                upgrade.m_41700_("inventory", (Tag)this.serializeNBT());
                TankUpgradeWrapper.this.save();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot == 0) {
                    return this.isValidInputItem(stack) || ALTERNATIVE_FLUID_CONTAINER_DEFINITIONS.stream().anyMatch(alt -> stack.m_41720_() == alt.filledItem && alt.tankContentsEmptyOrMatch(TankUpgradeWrapper.this.contents) || stack.m_41720_() == alt.emptyItem);
                }
                if (slot == 1) {
                    return this.isValidOutputItem(stack) || ALTERNATIVE_FLUID_CONTAINER_DEFINITIONS.stream().anyMatch(alt -> stack.m_41720_() == alt.emptyItem && alt.tankContentsMatch(TankUpgradeWrapper.this.contents) || stack.m_41720_() == alt.filledItem);
                }
                return false;
            }

            private boolean isValidInputItem(ItemStack stack) {
                return TankUpgradeWrapper.this.isValidFluidItem(stack, false);
            }

            private boolean isValidOutputItem(ItemStack stack) {
                return TankUpgradeWrapper.this.isValidFluidItem(stack, true);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
        NBTHelper.getCompound(upgrade, "inventory").ifPresent(arg_0 -> ((ItemStackHandler)this.inventory).deserializeNBT(arg_0));
        this.contents = TankUpgradeWrapper.getContents(upgrade);
    }

    public static FluidStack getContents(ItemStack upgrade) {
        return NBTHelper.getCompound(upgrade, CONTENTS_TAG).map(FluidStack::loadFluidStackFromNBT).orElse(FluidStack.EMPTY);
    }

    private boolean isValidFluidItem(ItemStack stack, boolean isOutput) {
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(fluidHandler -> this.isValidFluidHandler((IFluidHandlerItem)fluidHandler, isOutput)).orElse(false);
    }

    private boolean isValidFluidHandler(IFluidHandlerItem fluidHandler, boolean isOutput) {
        boolean tankEmpty = this.contents.isEmpty();
        for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
            FluidStack fluidInTank = fluidHandler.getFluidInTank(tank);
            if ((!isOutput || !fluidInTank.isEmpty() && (tankEmpty || !fluidInTank.isFluidEqual(this.contents))) && (isOutput || fluidInTank.isEmpty() || !tankEmpty && !this.contents.isFluidEqual(fluidInTank))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setTankRenderInfoUpdateCallback(Consumer<IRenderedTankUpgrade.TankRenderInfo> updateTankRenderInfoCallback) {
        this.updateTankRenderInfoCallback = updateTankRenderInfoCallback;
    }

    @Override
    public void forceUpdateTankRenderInfo() {
        IRenderedTankUpgrade.TankRenderInfo renderInfo = new IRenderedTankUpgrade.TankRenderInfo();
        if (!this.contents.isEmpty()) {
            renderInfo.setFluid(this.contents);
            renderInfo.setFillRatio((float)Math.round((float)this.contents.getAmount() / (float)this.getTankCapacity() * 10.0f) / 10.0f);
        }
        this.updateTankRenderInfoCallback.accept(renderInfo);
    }

    public FluidStack getContents() {
        return this.contents;
    }

    public int getTankCapacity() {
        return ((TankUpgradeItem)this.upgradeItem).getTankCapacity(this.storageWrapper);
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    private int getMaxInOut() {
        return (int)Math.max(1000.0, (double)((Integer)((TankUpgradeItem)this.upgradeItem).getTankUpgradeConfig().maxInputOutput.get() * this.storageWrapper.getNumberOfSlotRows()) * ((TankUpgradeItem)this.upgradeItem).getAdjustedStackMultiplier(this.storageWrapper));
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action, boolean ignoreInOutLimit) {
        int capacity = this.getTankCapacity();
        if (this.contents.getAmount() >= capacity || !this.contents.isEmpty() && !resource.isFluidEqual(this.contents)) {
            return 0;
        }
        int toFill = Math.min(capacity - this.contents.getAmount(), resource.getAmount());
        if (!ignoreInOutLimit) {
            toFill = Math.min(this.getMaxInOut(), toFill);
        }
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            if (this.contents.isEmpty()) {
                this.contents = new FluidStack(resource, toFill);
            } else {
                this.contents.setAmount(this.contents.getAmount() + toFill);
            }
            this.serializeContents();
        }
        return toFill;
    }

    private void serializeContents() {
        this.upgrade.m_41700_(CONTENTS_TAG, (Tag)this.contents.writeToNBT(new CompoundTag()));
        this.save();
        this.forceUpdateTankRenderInfo();
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action, boolean ignoreInOutLimit) {
        if (this.contents.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int toDrain = Math.min(maxDrain, this.contents.getAmount());
        if (!ignoreInOutLimit) {
            toDrain = Math.min(this.getMaxInOut(), toDrain);
        }
        FluidStack ret = new FluidStack(this.contents, toDrain);
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            if (toDrain == this.contents.getAmount()) {
                this.contents = FluidStack.EMPTY;
            } else {
                this.contents.setAmount(this.contents.getAmount() - toDrain);
            }
            this.serializeContents();
        }
        return ret;
    }

    @Override
    public void tick(@Nullable Entity entity, Level level, BlockPos pos) {
        if (level.m_46467_() < this.cooldownTime) {
            return;
        }
        boolean didSomething = false;
        didSomething = this.inventory.getStackInSlot(0).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(fluidHandler -> this.drainHandler((IFluidHandlerItem)fluidHandler, stack -> this.inventory.setStackInSlot(0, stack))).orElse(false) != false ? true : this.drainAlternativeFluidContainer(didSomething);
        didSomething = this.inventory.getStackInSlot(1).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(fluidHandler -> this.fillHandler((IFluidHandlerItem)fluidHandler, stack -> this.inventory.setStackInSlot(1, stack))).orElse(false) != false ? true : this.fillAlternativeFluidContainer(didSomething);
        if (didSomething) {
            this.cooldownTime = level.m_46467_() + (long)((Integer)((TankUpgradeItem)this.upgradeItem).getTankUpgradeConfig().autoFillDrainContainerCooldown.get()).intValue();
        }
    }

    private boolean fillAlternativeFluidContainer(boolean didSomething) {
        for (AlternativeFluidContainerDefinition alt : ALTERNATIVE_FLUID_CONTAINER_DEFINITIONS) {
            if (this.inventory.getStackInSlot(1).m_41720_() != alt.emptyItem || !alt.tankContentsMatch(this.contents) || this.drain(alt.amount, IFluidHandler.FluidAction.SIMULATE, false).getAmount() != alt.amount) continue;
            this.drain(alt.amount, IFluidHandler.FluidAction.EXECUTE, false);
            this.inventory.setStackInSlot(1, new ItemStack((ItemLike)alt.filledItem));
            this.serializeContents();
            didSomething = true;
            break;
        }
        return didSomething;
    }

    private boolean drainAlternativeFluidContainer(boolean didSomething) {
        for (AlternativeFluidContainerDefinition alt : ALTERNATIVE_FLUID_CONTAINER_DEFINITIONS) {
            if (this.inventory.getStackInSlot(0).m_41720_() != alt.filledItem || !alt.tankContentsEmptyOrMatch(this.contents) || this.fill(new FluidStack(alt.fluid, alt.amount), IFluidHandler.FluidAction.SIMULATE, true) != alt.amount) continue;
            this.fill(new FluidStack(alt.fluid, alt.amount), IFluidHandler.FluidAction.EXECUTE, false);
            this.inventory.setStackInSlot(0, new ItemStack((ItemLike)alt.emptyItem));
            this.serializeContents();
            didSomething = true;
            break;
        }
        return didSomething;
    }

    public boolean fillHandler(IFluidHandlerItem fluidHandler, Consumer<ItemStack> updateContainerStack) {
        if (!this.contents.isEmpty() && this.isValidFluidHandler(fluidHandler, true)) {
            int filled = fluidHandler.fill(new FluidStack(this.contents, Math.min(1000, this.contents.getAmount())), IFluidHandler.FluidAction.SIMULATE);
            if (filled <= 0) {
                return false;
            }
            FluidStack drained = this.drain(filled, IFluidHandler.FluidAction.EXECUTE, false);
            fluidHandler.fill(drained, IFluidHandler.FluidAction.EXECUTE);
            updateContainerStack.accept(fluidHandler.getContainer());
            return true;
        }
        return false;
    }

    public boolean drainHandler(IFluidHandlerItem fluidHandler, Consumer<ItemStack> updateContainerStack) {
        if (this.isValidFluidHandler(fluidHandler, false)) {
            FluidStack extracted;
            FluidStack fluidStack = extracted = this.contents.isEmpty() ? fluidHandler.drain(1000, IFluidHandler.FluidAction.SIMULATE) : fluidHandler.drain(new FluidStack(this.contents, Math.min(1000, this.getTankCapacity() - this.contents.getAmount())), IFluidHandler.FluidAction.SIMULATE);
            if (extracted.isEmpty()) {
                return false;
            }
            int filled = this.fill(extracted, IFluidHandler.FluidAction.EXECUTE, false);
            FluidStack toExtract = filled == extracted.getAmount() ? extracted : new FluidStack(extracted, filled);
            fluidHandler.drain(toExtract, IFluidHandler.FluidAction.EXECUTE);
            updateContainerStack.accept(fluidHandler.getContainer());
            return true;
        }
        return false;
    }

    @Override
    public int getMinimumMultiplierRequired() {
        return (int)Math.ceil((float)this.contents.getAmount() / (float)((TankUpgradeItem)this.upgradeItem).getBaseCapacity(this.storageWrapper));
    }

    @Override
    public boolean canBeDisabled() {
        return false;
    }

    public boolean isItemValidForPlacement(int slot, ItemStack stack) {
        if (slot == 0) {
            return this.isValidInputItem(stack);
        }
        if (slot == 1) {
            return this.isValidOutputItem(stack);
        }
        return false;
    }

    private boolean isValidInputItem(ItemStack stack) {
        return this.isValidFluidItem(stack, false);
    }

    private boolean isValidOutputItem(ItemStack stack) {
        return this.isValidFluidItem(stack, true);
    }

    private record AlternativeFluidContainerDefinition(Item filledItem, Item emptyItem, Fluid fluid, int amount) {
        public boolean tankContentsEmptyOrMatch(FluidStack contents) {
            return contents.isEmpty() || this.fluid.equals(contents.getFluid());
        }

        public boolean tankContentsMatch(FluidStack contents) {
            return !contents.isEmpty() && this.fluid.equals(contents.getFluid());
        }
    }
}

