/*
 * Decompiled with CFR 0.152.
 */
package toni.sodiumoptionsapi.gui;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import me.jellysquid.mods.sodium.client.gui.widgets.FlatButtonWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.resource.PathPackResources;
import net.minecraftforge.resource.ResourcePackLoader;
import toni.sodiumoptionsapi.SodiumOptionsAPI;
import toni.sodiumoptionsapi.mixin.sodium.FlatButtonWidgetAccessor;
import toni.sodiumoptionsapi.util.ILeftAlignOffsetAccessor;

public class TabHeaderWidget
extends FlatButtonWidget {
    private static final ResourceLocation FALLBACK_LOCATION = new ResourceLocation("textures/misc/unknown_pack.png");
    private static final Set<String> erroredLogos = new HashSet<String>();
    private final ResourceLocation logoTexture;
    private final boolean isTitle;

    public static MutableComponent getLabel(String modId, boolean underline) {
        return (switch (modId) {
            case "sspb" -> Component.m_237113_((String)"SSPB");
            default -> TabHeaderWidget.idComponent(modId);
        }).m_130938_(s -> s.m_131162_(Boolean.valueOf(underline)));
    }

    static MutableComponent idComponent(String namespace) {
        return Component.m_237113_((String)TabHeaderWidget.getModName(namespace));
    }

    public static String getModName(String modId) {
        return ModList.get().getModContainerById(modId).map(container -> container.getModInfo().getDisplayName()).orElse(modId);
    }

    public TabHeaderWidget(Dim2i dim, String modId, Runnable action) {
        super(dim, (Component)TabHeaderWidget.getLabel(modId, action == null), action == null ? () -> {} : action);
        this.isTitle = action == null;
        Optional logoFile = erroredLogos.contains(modId) ? Optional.empty() : ModList.get().getModContainerById(modId).flatMap(c -> c.getModInfo().getLogoFile());
        ResourceLocation texture = null;
        if (logoFile.isPresent()) {
            PathPackResources resourcePack = ResourcePackLoader.getPackFor((String)modId).orElse((PathPackResources)ResourcePackLoader.getPackFor((String)"forge").orElseThrow(() -> new RuntimeException("Can't find forge, WHAT!")));
            try {
                IoSupplier logoResource = resourcePack.m_8017_(new String[]{(String)logoFile.get()});
                if (logoResource != null) {
                    NativeImage logo = NativeImage.m_85058_((InputStream)((InputStream)logoResource.m_247737_()));
                    if (logo.m_84982_() != logo.m_85084_()) {
                        logo.close();
                        throw new IOException("Logo " + (String)logoFile.get() + " for " + modId + " is not square");
                    }
                    texture = new ResourceLocation("embeddium", "logo/" + modId);
                    Minecraft.m_91087_().f_90987_.m_118495_(texture, (AbstractTexture)new DynamicTexture(logo));
                }
            }
            catch (IOException e) {
                erroredLogos.add(modId);
                SodiumOptionsAPI.LOGGER.error("Exception reading logo for " + modId, (Throwable)e);
            }
        }
        this.setStyle(this.getStyle());
        this.logoTexture = texture;
    }

    public FlatButtonWidget.Style getStyle() {
        FlatButtonWidget.Style style = new FlatButtonWidget.Style();
        style.bgHovered = this.isTitle ? ColorARGB.pack((int)0, (int)0, (int)0, (int)140) : -536870912;
        style.bgDefault = ColorARGB.pack((int)0, (int)0, (int)0, (int)140);
        style.bgDisabled = 0x60000000;
        style.textDefault = -1;
        style.textDisabled = -1862270977;
        return style;
    }

    protected boolean isHovered(int mouseX, int mouseY) {
        return false;
    }

    public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        ((ILeftAlignOffsetAccessor)((Object)this)).sodiumOptionsAPI$setLeftAlignOffset(20);
        super.m_88315_(drawContext, mouseX, mouseY, delta);
        Dim2i dim = ((FlatButtonWidgetAccessor)((Object)this)).getDim();
        ResourceLocation icon = Objects.requireNonNullElse(this.logoTexture, FALLBACK_LOCATION);
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        int fontHeight = 9;
        int imgY = ((FlatButtonWidgetAccessor)((Object)this)).getDim().getCenterY() - fontHeight / 2;
        drawContext.m_280163_(icon, ((FlatButtonWidgetAccessor)((Object)this)).getDim().x() + 5, imgY, 0.0f, 0.0f, fontHeight, fontHeight, fontHeight, fontHeight);
    }
}

