/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common.blocks;

import net.mehvahdjukaar.moonlight.api.block.IWashable;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.common.blocks.IModBed;
import net.mehvahdjukaar.sleep_tight.common.entities.BedbugEntity;
import net.mehvahdjukaar.sleep_tight.common.network.ClientBoundParticleMessage;
import net.mehvahdjukaar.sleep_tight.common.network.NetworkHandler;
import net.mehvahdjukaar.sleep_tight.common.tiles.InfestedBedTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class InfestedBedBlock
extends BedBlock
implements IWashable {
    public InfestedBedBlock(BlockBehaviour.Properties properties) {
        super(DyeColor.BROWN, properties);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new InfestedBedTile(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.m_214162_(state, level, pos, random);
        if ((double)random.m_188501_() < 0.3) {
            float x = (float)pos.m_123341_() + level.f_46441_.m_188501_();
            float z = (float)pos.m_123343_() + level.f_46441_.m_188501_();
            float y = (float)pos.m_123342_() + 0.5625f;
            level.m_7106_((ParticleOptions)SleepTight.BEDBUG_PARTICLE.get(), (double)x, (double)y + 0.01, (double)z, 0.0, 0.0, 0.0);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (IModBed.tryExploding(level, pos)) {
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof LingeringPotionItem || stack.m_41720_() instanceof SplashPotionItem) {
            return InteractionResult.PASS;
        }
        player.m_5661_((Component)Component.m_237115_((String)"message.sleep_tight.bedbug"), true);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (projectile instanceof ThrownPotion) {
            ThrownPotion tp = (ThrownPotion)projectile;
            Potion p = PotionUtils.m_43579_((ItemStack)tp.m_7846_());
            for (MobEffectInstance e : p.m_43488_()) {
                if (e.m_19544_() != MobEffects.f_19602_) continue;
                InfestedBedBlock.convertToBed(level, state, hit.m_82425_());
                return;
            }
        }
        super.m_5581_(level, state, hit, projectile);
    }

    private static Direction getNeighbourDirection(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.m_122424_();
    }

    public void m_213646_(BlockState state, ServerLevel level, BlockPos pos, ItemStack stack, boolean bl) {
        super.m_213646_(state, level, pos, stack, bl);
        if (state.m_61143_((Property)f_49440_) == BedPart.FOOT && level.m_46469_().m_46207_(GameRules.f_46136_)) {
            BedbugEntity entity = (BedbugEntity)SleepTight.BEDBUG_ENTITY.get().m_20615_((Level)level);
            entity.m_7678_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
            level.m_7967_((Entity)entity);
            entity.m_21373_();
        }
    }

    public boolean tryWash(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof InfestedBedTile) {
            InfestedBedTile tile = (InfestedBedTile)blockEntity;
            return true;
        }
        return false;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof InfestedBedTile) {
            InfestedBedTile tile = (InfestedBedTile)blockEntity;
            return tile.getHeldBlock().m_60734_().m_5456_().m_7968_();
        }
        return this.m_7397_(level, pos, state);
    }

    public static void convertToBed(Level level, BlockState state, BlockPos blockPos) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof InfestedBedTile) {
            Block bed;
            InfestedBedTile tile = (InfestedBedTile)blockEntity;
            Direction dir = InfestedBedBlock.getNeighbourDirection((BedPart)state.m_61143_((Property)f_49440_), (Direction)state.m_61143_((Property)f_54117_));
            BlockPos neighbor = blockPos.m_121945_(dir);
            if (!level.f_46443_) {
                NetworkHandler.CHANNEL.sendToAllClientPlayersInRange(level, blockPos, 32.0, (Message)ClientBoundParticleMessage.bedbugInfest(blockPos, dir));
            }
            if ((bed = tile.getBed().m_60734_()) != null) {
                level.m_7731_(blockPos, bed.m_152465_(state), 18);
                level.m_7731_(neighbor, bed.m_152465_(level.m_8055_(neighbor)), 18);
                level.m_5594_(null, blockPos, SoundEvents.f_12420_, SoundSource.BLOCKS, 1.0f, 1.3f);
            }
        }
    }

    public static boolean infestBed(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (BedbugEntity.isValidBedForInfestation(state)) {
            InfestedBedTile tile;
            level.m_7731_(pos, SleepTight.INFESTED_BED.get().m_152465_(state), 18);
            Direction dir = (Direction)state.m_61143_((Property)BedBlock.f_54117_);
            BlockPos neighborPos = pos.m_121945_(state.m_61143_((Property)BedBlock.f_49440_) == BedPart.FOOT ? dir : dir.m_122424_());
            level.m_7731_(neighborPos, SleepTight.INFESTED_BED.get().m_152465_(level.m_8055_(neighborPos)), 2);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof InfestedBedTile) {
                tile = (InfestedBedTile)blockEntity;
                tile.setHeldBlock(state.m_60734_().m_152465_(tile.m_58900_()));
            }
            if ((blockEntity = level.m_7702_(neighborPos)) instanceof InfestedBedTile) {
                tile = (InfestedBedTile)blockEntity;
                tile.setHeldBlock(state.m_60734_().m_152465_(tile.m_58900_()));
            }
            return true;
        }
        return false;
    }
}

