/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screens;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyScreenshotToast
implements Toast {
    private final int width;
    private final long displayDuration;
    private Component title;
    @Nullable
    private Component description;
    private long startTime;
    private boolean justUpdated;

    public CopyScreenshotToast(Component title, @Nullable Component description, long displayDuration) {
        this.title = title;
        this.description = description;
        Font font = Minecraft.m_91087_().f_91062_;
        this.width = Math.max(160, 30 + Math.max(font.m_92852_((FormattedText)title), description == null ? 0 : font.m_92852_((FormattedText)description)));
        this.displayDuration = displayDuration;
    }

    @NotNull
    public Toast.Visibility m_7172_(@NotNull GuiGraphics context, @NotNull ToastComponent manager, long startTime) {
        int width;
        if (this.justUpdated) {
            this.startTime = startTime;
            this.justUpdated = false;
        }
        if ((width = this.m_7828_()) == 160) {
            context.m_280218_(f_94893_, 0, 0, 0, 64, width, this.m_94899_());
        } else {
            int height = this.m_94899_();
            this.drawPart(context, width, 0, 0, 28);
            this.drawPart(context, width, 28, height - 4, 4);
        }
        if (this.description == null) {
            context.m_280614_(manager.m_94929_().f_91062_, this.title, 18, 12, -256, false);
        } else {
            context.m_280614_(manager.m_94929_().f_91062_, this.title, 18, 7, -256, false);
            context.m_280614_(manager.m_94929_().f_91062_, this.description, 18, 18, -1, false);
        }
        return (double)(startTime - this.startTime) < (double)this.displayDuration * manager.m_264542_() ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
    }

    public int m_7828_() {
        return this.width;
    }

    private void drawPart(GuiGraphics context, int width, int textureV, int y, int height) {
        int i = textureV == 0 ? 20 : 5;
        int j = Math.min(60, width - i);
        context.m_280218_(f_94893_, 0, y, 0, 64 + textureV, i, height);
        for (int k = i; k < width - j; k += 64) {
            context.m_280218_(f_94893_, k, y, 32, 64 + textureV, Math.min(64, width - k - j), height);
        }
        context.m_280218_(f_94893_, width - j, y, 160 - j, 64 + textureV, j, height);
    }

    public void setContent(Component title, @Nullable Component description) {
        this.title = title;
        this.description = description;
        this.justUpdated = true;
    }

    public static void add(ToastComponent manager, Component title, @Nullable Component description, long displayDuration) {
        manager.m_94922_((Toast)new CopyScreenshotToast(title, description, displayDuration));
    }

    public static void show(ToastComponent manager, Component title, @Nullable Component description, long displayDuration) {
        CopyScreenshotToast toast = (CopyScreenshotToast)manager.m_94926_(CopyScreenshotToast.class, f_94894_);
        if (toast == null) {
            CopyScreenshotToast.add(manager, title, description, displayDuration);
        } else {
            toast.setContent(title, description);
        }
    }
}

