/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer;

import com.mojang.blaze3d.platform.InputConstants;
import io.github.lgatodu47.screenshot_viewer.config.ScreenshotViewerConfig;
import io.github.lgatodu47.screenshot_viewer.config.ScreenshotViewerConfigListener;
import io.github.lgatodu47.screenshot_viewer.screens.IconButtonWidget;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotClickEvent;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotViewerTexts;
import io.github.lgatodu47.screenshot_viewer.screens.manage_screenshots.ManageScreenshotsScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ScreenshotEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;
import org.jetbrains.annotations.NotNull;

@Mod(value="screenshot_viewer")
public class ScreenshotViewer {
    public static final String MODID = "screenshot_viewer";
    private static ScreenshotViewer instance;
    private final List<ScreenshotViewerConfigListener> configListeners = new ArrayList<ScreenshotViewerConfigListener>();
    private final ScreenshotViewerConfig config;
    private final IModInfo modInfo;
    private KeyMapping openScreenshotsScreenKey;
    private static final ResourceLocation SCREENSHOT_VIEWER_ICON;

    public ScreenshotViewer() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::registerKeyMappings);
        bus.addListener(this::onConfigReloaded);
        ModLoadingContext mlc = ModLoadingContext.get();
        this.config = ScreenshotViewerConfig.registerConfig(mlc);
        this.modInfo = mlc.getActiveContainer().getModInfo();
        MinecraftForge.EVENT_BUS.register((Object)this);
        instance = this;
    }

    private void registerKeyMappings(RegisterKeyMappingsEvent event) {
        this.openScreenshotsScreenKey = (KeyMapping)Util.m_137469_((Object)new KeyMapping(ScreenshotViewerTexts.translation("key", "open_screenshots_screen"), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.f_84822_, "key.categories.misc"), arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
    }

    private void onConfigReloaded(ModConfigEvent.Reloading event) {
        this.configListeners.forEach(ScreenshotViewerConfigListener::onConfigReloaded);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        if (this.openScreenshotsScreenKey == null || this.openScreenshotsScreenKey.m_90862_()) {
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        KeyMapping openScreenshotsScreenKey = ScreenshotViewer.getInstance().getOpenScreenshotsScreenKey();
        if (client.f_91073_ != null && client.f_91080_ == null && event.getAction() == 1 && openScreenshotsScreenKey.getKey().m_84873_() == event.getKey()) {
            client.m_91152_((Screen)new ManageScreenshotsScreen(null));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onScreenPostInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        Minecraft client = screen.getMinecraft();
        List buttons = event.getListenersList();
        if (((Boolean)this.config.showButtonInGamePauseMenu.get()).booleanValue() && screen instanceof PauseScreen) {
            buttons.stream().filter(AbstractWidget.class::isInstance).map(AbstractWidget.class::cast).findFirst().ifPresent(topButton -> event.addListener((GuiEventListener)Util.m_137469_((Object)((Object)new IconButtonWidget(topButton.m_252754_() + topButton.m_5711_() + (Integer)this.config.pauseMenuButtonOffset.get(), topButton.m_252907_(), topButton.m_93694_(), topButton.m_93694_(), ScreenshotViewerTexts.MANAGE_SCREENSHOTS, SCREENSHOT_VIEWER_ICON, button -> client.m_91152_((Screen)new ManageScreenshotsScreen(screen)))), btn -> btn.m_257544_(Tooltip.m_257550_((Component)ScreenshotViewerTexts.MANAGE_SCREENSHOTS)))));
        }
        if (((Boolean)this.config.showButtonOnTitleScreen.get()).booleanValue() && screen instanceof TitleScreen) {
            Optional<ImageButton> accessibilityWidgetOpt = buttons.stream().filter(ImageButton.class::isInstance).map(ImageButton.class::cast).filter(widget -> widget.m_6035_().equals(Component.m_237115_((String)"narrator.button.accessibility"))).findFirst();
            int x = accessibilityWidgetOpt.map(AbstractWidget::m_252754_).orElse(screen.f_96543_ / 2 + 104);
            int y = accessibilityWidgetOpt.map(AbstractWidget::m_252907_).orElse(screen.f_96544_ / 4 + 132);
            int width = accessibilityWidgetOpt.map(AbstractWidget::m_5711_).orElse(20);
            int height = accessibilityWidgetOpt.map(AbstractWidget::m_93694_).orElse(20);
            event.addListener((GuiEventListener)Util.m_137469_((Object)((Object)new IconButtonWidget(x + width + 4, y, width, height, ScreenshotViewerTexts.MANAGE_SCREENSHOTS, SCREENSHOT_VIEWER_ICON, button -> client.m_91152_((Screen)new ManageScreenshotsScreen(screen)))), btn -> btn.m_257544_(Tooltip.m_257550_((Component)ScreenshotViewerTexts.MANAGE_SCREENSHOTS))));
        }
    }

    @SubscribeEvent
    public void onScreenshotTaken(ScreenshotEvent event) {
        event.setResultMessage((Component)Component.m_237110_((String)"screenshot.success", (Object[])new Object[]{Component.m_237113_((String)event.getScreenshotFile().getName()).m_130940_(ChatFormatting.UNDERLINE).m_130938_(style -> style.m_131142_((ClickEvent)new ScreenshotClickEvent(event.getScreenshotFile())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, ScreenshotViewerTexts.REDIRECT_TO_SCREENSHOT_MANAGER){

            @Nullable
            public <T> T m_130823_(@Nonnull HoverEvent.Action<T> action) {
                return (T)((Boolean)ScreenshotViewer.this.config.redirectScreenshotChatLinks.get() != false ? super.m_130823_(action) : null);
            }
        }))}));
    }

    public ScreenshotViewerConfig getConfig() {
        return this.config;
    }

    public KeyMapping getOpenScreenshotsScreenKey() {
        return this.openScreenshotsScreenKey;
    }

    public Optional<BiFunction<Minecraft, Screen, Screen>> getConfigScreenFactory() {
        return ConfigScreenHandler.getScreenFactoryFor((IModInfo)this.modInfo);
    }

    public void registerConfigListener(ScreenshotViewerConfigListener listener) {
        this.configListeners.add(listener);
    }

    public void unregisterConfigListener(ScreenshotViewerConfigListener listener) {
        this.configListeners.remove(listener);
    }

    @NotNull
    public static ScreenshotViewer getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Screenshot Viewer is not loaded yet!");
        }
        return instance;
    }

    static {
        SCREENSHOT_VIEWER_ICON = new ResourceLocation(MODID, "textures/gui/sprites/widget/icons/screenshot_viewer.png");
    }
}

