/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import io.github.mortuusars.scholar.Config;
import io.github.mortuusars.scholar.Scholar;
import io.github.mortuusars.scholar.util.RenderUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.item.WrittenBookItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpreadBookViewScreen
extends Screen {
    public static final BookAccess EMPTY_ACCESS = new BookAccess(){

        @Override
        public int getPageCount() {
            return 0;
        }

        @Override
        public FormattedText getPageRaw(int i) {
            return FormattedText.f_130760_;
        }
    };
    public static final ResourceLocation TEXTURE = Scholar.resource("textures/gui/book.png");
    public static final int BOOK_WIDTH = 295;
    public static final int BOOK_HEIGHT = 180;
    public static final int TEXT_LEFT_X = 23;
    public static final int TEXT_RIGHT_X = 158;
    public static final int TEXT_Y = 21;
    public static final int TEXT_WIDTH = 114;
    public static final int TEXT_HEIGHT = 128;
    protected BookAccess bookAccess;
    protected final int bookColor;
    protected int currentSpread;
    protected Pair<List<FormattedCharSequence>, List<FormattedCharSequence>> cachedPageComponents;
    protected int cachedSpread;
    protected final int mainFontColor;
    protected final int secondaryFontColor;
    protected int leftPos;
    protected int topPos;
    protected Button nextButton;
    protected Button prevButton;

    public SpreadBookViewScreen(BookAccess bookAccess, int bookColor) {
        super(GameNarrator.f_93310_);
        this.bookColor = bookColor;
        this.cachedPageComponents = Pair.of(Collections.emptyList(), Collections.emptyList());
        this.cachedSpread = -1;
        this.bookAccess = bookAccess;
        this.mainFontColor = Config.Client.getColor(Config.Client.MAIN_FONT_COLOR);
        this.secondaryFontColor = Config.Client.getColor(Config.Client.SECONDARY_FONT_COLOR);
    }

    public void setBookAccess(BookAccess bookAccess) {
        this.bookAccess = bookAccess;
        this.currentSpread = Mth.m_14045_((int)this.currentSpread, (int)0, (int)bookAccess.getPageCount());
        this.updateButtonVisibility();
        this.cachedSpread = -1;
    }

    protected void m_7856_() {
        this.leftPos = (this.f_96543_ - 295) / 2;
        this.topPos = (this.f_96544_ - 180) / 2;
        this.createMenuControls();
        this.createPageControlButtons();
    }

    public boolean m_7043_() {
        return (Boolean)Config.Client.WRITTEN_PAUSE.get();
    }

    protected void createMenuControls() {
        if (((Boolean)Config.Client.WRITTEN_SHOW_DONE_BUTTON.get()).booleanValue()) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - 60, this.topPos + 180 + 12, 120, 20).m_253136_());
        }
    }

    protected void createPageControlButtons() {
        ImageButton prevButton = new ImageButton(this.leftPos + 12, this.topPos + 156, 13, 15, 295, 0, 15, TEXTURE, 512, 512, button -> this.pageBack());
        prevButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"spectatorMenu.previous_page")));
        this.prevButton = (Button)this.m_142416_((GuiEventListener)prevButton);
        ImageButton nextButton = new ImageButton(this.leftPos + 270, this.topPos + 156, 13, 15, 308, 0, 15, TEXTURE, 512, 512, button -> this.pageForward());
        nextButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"spectatorMenu.next_page")));
        this.nextButton = (Button)this.m_142416_((GuiEventListener)nextButton);
        this.updateButtonVisibility();
    }

    private int getSpreadCount() {
        return (int)Math.ceil((double)this.bookAccess.getPageCount() / 2.0);
    }

    protected void pageBack() {
        if (this.currentSpread > 0) {
            --this.currentSpread;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)0.8f));
        }
        this.updateButtonVisibility();
    }

    protected void pageForward() {
        if (this.currentSpread < this.getSpreadCount() - 1) {
            ++this.currentSpread;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
        }
        this.updateButtonVisibility();
    }

    public boolean setPage(int pageIndex) {
        int spreadIndex = (int)((float)(pageIndex = Mth.m_14045_((int)pageIndex, (int)0, (int)(this.bookAccess.getPageCount() - 1))) / 2.0f);
        if (spreadIndex != this.currentSpread) {
            this.currentSpread = spreadIndex;
            this.updateButtonVisibility();
            this.cachedSpread = -1;
            return true;
        }
        return false;
    }

    protected boolean forcePage(int i) {
        return this.setPage(i);
    }

    private void updateButtonVisibility() {
        this.nextButton.f_93624_ = this.currentSpread < this.getSpreadCount() - 1;
        this.prevButton.f_93624_ = this.currentSpread > 0;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (Minecraft.m_91087_().f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
            return true;
        }
        if (keyCode == 263 || keyCode == 266 || Minecraft.m_91087_().f_91066_.f_92086_.m_90832_(keyCode, scanCode)) {
            this.pageBack();
            return true;
        }
        if (keyCode == 262 || keyCode == 267 || Minecraft.m_91087_().f_91066_.f_92088_.m_90832_(keyCode, scanCode)) {
            this.pageForward();
            return true;
        }
        return false;
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        RenderUtil.withColorMultiplied(this.bookColor, () -> guiGraphics.m_280411_(TEXTURE, (this.f_96543_ - 295) / 2, (this.f_96544_ - 180) / 2, 295, 180, 0.0f, 0.0f, 295, 180, 512, 512));
        guiGraphics.m_280411_(TEXTURE, (this.f_96543_ - 295) / 2, (this.f_96544_ - 180) / 2, 295, 180, 0.0f, 180.0f, 295, 180, 512, 512);
        this.drawPageNumbers(guiGraphics, this.currentSpread);
        if (this.cachedSpread != this.currentSpread) {
            FormattedText leftFormattedText = this.bookAccess.getPage(this.currentSpread * 2);
            FormattedText rightFormattedText = this.bookAccess.getPageCount() > this.currentSpread * 2 + 1 ? this.bookAccess.getPage(this.currentSpread * 2 + 1) : FormattedText.f_130760_;
            this.cachedPageComponents = Pair.of((Object)this.f_96547_.m_92923_(leftFormattedText, 114), (Object)this.f_96547_.m_92923_(rightFormattedText, 114));
        }
        this.cachedSpread = this.currentSpread;
        this.drawPageContents(guiGraphics, (List)this.cachedPageComponents.getFirst(), this.leftPos + 23, this.topPos + 21);
        this.drawPageContents(guiGraphics, (List)this.cachedPageComponents.getSecond(), this.leftPos + 158, this.topPos + 21);
        Style style = this.getClickedComponentStyleAt(mouseX, mouseY);
        if (style != null) {
            guiGraphics.m_280304_(this.f_96547_, style, mouseX, mouseY);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    protected void drawPageNumbers(GuiGraphics guiGraphics, int currentSpreadIndex) {
        String leftPageNumber = Integer.toString(currentSpreadIndex * 2 + 1);
        guiGraphics.m_280056_(this.f_96547_, leftPageNumber, this.leftPos + 69 + (8 - this.f_96547_.m_92895_(leftPageNumber) / 2), this.topPos + 157, this.secondaryFontColor, false);
        String rightPageNumber = Integer.toString(currentSpreadIndex * 2 + 2);
        guiGraphics.m_280056_(this.f_96547_, rightPageNumber, this.leftPos + 208 + (8 - this.f_96547_.m_92895_(rightPageNumber) / 2), this.topPos + 157, this.secondaryFontColor, false);
    }

    protected void drawPageContents(GuiGraphics guiGraphics, List<FormattedCharSequence> lines, int x, int y) {
        Objects.requireNonNull(this.f_96547_);
        int maxLines = Math.min(128 / 9, lines.size());
        for (int i = 0; i < maxLines; ++i) {
            FormattedCharSequence text = lines.get(i);
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280649_(this.f_96547_, text, x, y + i * 9, this.mainFontColor, false);
        }
    }

    public boolean m_6375_(double x, double y, int button) {
        Style style;
        if (button == 0 && (style = this.getClickedComponentStyleAt(x, y)) != null && this.m_5561_(style)) {
            return true;
        }
        return super.m_6375_(x, y, button);
    }

    public boolean m_5561_(Style style) {
        if (style == null) {
            return false;
        }
        ClickEvent clickEvent = style.m_131182_();
        if (clickEvent == null) {
            return false;
        }
        if (clickEvent.m_130622_() == ClickEvent.Action.CHANGE_PAGE) {
            String pageNumber = clickEvent.m_130623_();
            try {
                int pageIndex = Integer.parseInt(pageNumber) - 1;
                boolean pageChanged = this.forcePage(pageIndex);
                if (pageChanged) {
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
                }
                return pageChanged;
            }
            catch (Exception var5) {
                return false;
            }
        }
        boolean handled = super.m_5561_(style);
        if (handled && clickEvent.m_130622_() == ClickEvent.Action.RUN_COMMAND) {
            this.closeScreen();
        }
        return handled;
    }

    protected void closeScreen() {
        Minecraft.m_91087_().m_91152_(null);
    }

    @Nullable
    public Style getClickedComponentStyleAt(double mouseX, double mouseY) {
        List pageContents;
        boolean isOverRightPage;
        if (mouseY < (double)(this.topPos + 21) || mouseY >= (double)(this.topPos + 21 + 128)) {
            return null;
        }
        if (mouseX >= (double)(this.leftPos + 158) && mouseX < (double)(this.leftPos + 158 + 114)) {
            isOverRightPage = true;
        } else if (mouseX >= (double)(this.leftPos + 23) && mouseX < (double)(this.leftPos + 23 + 114)) {
            isOverRightPage = false;
        } else {
            return null;
        }
        List list = pageContents = isOverRightPage ? (List)this.cachedPageComponents.getSecond() : (List)this.cachedPageComponents.getFirst();
        if (pageContents.isEmpty()) {
            return null;
        }
        int x = (int)mouseX - (this.leftPos + (isOverRightPage ? 158 : 23));
        int y = (int)mouseY - (this.topPos + 21);
        Objects.requireNonNull(this.f_96547_);
        int linesCount = Math.min(128 / 9, pageContents.size());
        Objects.requireNonNull(this.f_96547_);
        if (y < 9 * linesCount + linesCount) {
            Objects.requireNonNull(this.f_96547_);
            int clickedLine = y / 9;
            if (clickedLine >= 0 && clickedLine < pageContents.size()) {
                FormattedCharSequence text = (FormattedCharSequence)pageContents.get(clickedLine);
                return this.f_96547_.m_92865_().m_92338_(text, x);
            }
            return null;
        }
        return null;
    }

    static List<String> loadPages(CompoundTag compoundTag) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Objects.requireNonNull(builder);
        SpreadBookViewScreen.loadPages(compoundTag, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public static void loadPages(CompoundTag compoundTag, Consumer<String> consumer) {
        IntFunction<String> intFunction;
        ListTag listTag = compoundTag.m_128437_("pages", 8).m_6426_();
        if (Minecraft.m_91087_().m_167974_() && compoundTag.m_128425_("filtered_pages", 10)) {
            CompoundTag compoundTag2 = compoundTag.m_128469_("filtered_pages");
            intFunction = ix -> {
                String string = String.valueOf(ix);
                return compoundTag2.m_128441_(string) ? compoundTag2.m_128461_(string) : listTag.m_128778_(ix);
            };
        } else {
            Objects.requireNonNull(listTag);
            intFunction = arg_0 -> ((ListTag)listTag).m_128778_(arg_0);
        }
        for (int i = 0; i < listTag.size(); ++i) {
            consumer.accept(intFunction.apply(i));
        }
    }

    public static interface BookAccess {
        public int getPageCount();

        public FormattedText getPageRaw(int var1);

        default public FormattedText getPage(int i) {
            return i >= 0 && i < this.getPageCount() ? this.getPageRaw(i) : FormattedText.f_130760_;
        }

        public static BookAccess fromItem(ItemStack itemStack) {
            if (itemStack.m_41720_() instanceof WrittenBookItem) {
                return new WrittenBookAccess(itemStack);
            }
            return itemStack.m_41720_() instanceof WritableBookItem ? new WritableBookAccess(itemStack) : EMPTY_ACCESS;
        }
    }

    public static class WrittenBookAccess
    implements BookAccess {
        private final List<String> pages;

        public WrittenBookAccess(ItemStack itemStack) {
            this.pages = WrittenBookAccess.readPages(itemStack);
        }

        private static List<String> readPages(ItemStack itemStack) {
            CompoundTag compoundTag = itemStack.m_41783_();
            return WrittenBookItem.m_43471_((CompoundTag)compoundTag) ? SpreadBookViewScreen.loadPages(compoundTag) : ImmutableList.of((Object)Component.Serializer.m_130703_((Component)Component.m_237115_((String)"book.invalid.tag").m_130940_(ChatFormatting.DARK_RED)));
        }

        @Override
        public int getPageCount() {
            return this.pages.size();
        }

        @Override
        @NotNull
        public FormattedText getPageRaw(int i) {
            String string = this.pages.get(i);
            try {
                MutableComponent formattedText = Component.Serializer.m_130701_((String)string);
                if (formattedText != null) {
                    return formattedText;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return FormattedText.m_130775_((String)string);
        }
    }

    public static class WritableBookAccess
    implements BookAccess {
        private final List<String> pages;

        public WritableBookAccess(ItemStack itemStack) {
            this.pages = WritableBookAccess.readPages(itemStack);
        }

        private static List<String> readPages(ItemStack itemStack) {
            CompoundTag compoundTag = itemStack.m_41783_();
            return compoundTag != null ? SpreadBookViewScreen.loadPages(compoundTag) : ImmutableList.of();
        }

        @Override
        public int getPageCount() {
            return this.pages.size();
        }

        @Override
        public FormattedText getPageRaw(int i) {
            return FormattedText.m_130775_((String)this.pages.get(i));
        }
    }
}

