/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.screen;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.scholar.Config;
import io.github.mortuusars.scholar.Scholar;
import io.github.mortuusars.scholar.screen.BookSigningScreen;
import io.github.mortuusars.scholar.screen.textbox.TextBox;
import io.github.mortuusars.scholar.util.RenderUtil;
import io.github.mortuusars.scholar.visual.BookColors;
import io.github.mortuusars.scholar.visual.Formatting;
import io.netty.util.internal.StringUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundEditBookPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpreadBookEditScreen
extends Screen {
    private TextBox leftPageTextBox;
    private TextBox rightPageTextBox;
    public static final ResourceLocation TEXTURE = Scholar.resource("textures/gui/book.png");
    public static final int BOOK_WIDTH = 295;
    public static final int BOOK_HEIGHT = 180;
    public static final int TEXT_LEFT_X = 23;
    public static final int TEXT_RIGHT_X = 158;
    public static final int TEXT_Y = 21;
    public static final int TEXT_WIDTH = 114;
    public static final int TEXT_HEIGHT = 128;
    public static final int SELECTION_COLOR = -10075000;
    public static final int SELECTION_UNFOCUSED_COLOR = -8956519;
    protected final Player owner;
    protected final ItemStack bookStack;
    protected final int bookColor;
    protected final InteractionHand hand;
    protected final int mainFontColor;
    protected final int secondaryFontColor;
    protected final List<String> pages = Lists.newArrayList();
    protected int leftPos;
    protected int topPos;
    protected Button nextButton;
    protected Button prevButton;
    protected Button enterSignModeButton;
    @Nullable
    protected Button insertSectionSignButton;
    protected int currentSpread;
    protected boolean isModified;

    public SpreadBookEditScreen(Player owner, ItemStack bookStack, InteractionHand hand) {
        super(GameNarrator.f_93310_);
        this.owner = owner;
        this.bookStack = bookStack;
        this.bookColor = BookColors.fromStack(bookStack);
        this.hand = hand;
        this.mainFontColor = Config.Client.getColor(Config.Client.MAIN_FONT_COLOR);
        this.secondaryFontColor = Config.Client.getColor(Config.Client.SECONDARY_FONT_COLOR);
        CompoundTag compoundtag = bookStack.m_41783_();
        if (compoundtag != null) {
            BookViewScreen.m_169696_((CompoundTag)compoundtag, this.pages::add);
        }
        while (this.pages.size() < 2) {
            this.pages.add("");
        }
    }

    public boolean m_7043_() {
        return (Boolean)Config.Client.WRITABLE_PAUSE.get();
    }

    public void m_86600_() {
        this.leftPageTextBox.tick();
        this.rightPageTextBox.tick();
    }

    protected void m_7856_() {
        this.leftPos = (this.f_96543_ - 295) / 2;
        this.topPos = (this.f_96544_ - 180) / 2;
        this.leftPageTextBox = new TextBox(this.f_96547_, this.leftPos + 23, this.topPos + 21, 114, 128, () -> this.getPageText(Side.LEFT), text -> this.setPageText(Side.LEFT, (String)text)).setFontColor(this.mainFontColor, this.mainFontColor).setSelectionColor(-10075000, -8956519);
        this.m_142416_((GuiEventListener)this.leftPageTextBox);
        this.rightPageTextBox = new TextBox(this.f_96547_, this.leftPos + 158, this.topPos + 21, 114, 128, () -> this.getPageText(Side.RIGHT), text -> this.setPageText(Side.RIGHT, (String)text)).setFontColor(this.mainFontColor, this.mainFontColor).setSelectionColor(-10075000, -8956519);
        this.m_142416_((GuiEventListener)this.rightPageTextBox);
        ImageButton prevButton = new ImageButton(this.leftPos + 12, this.topPos + 156, 13, 15, 295, 0, 15, TEXTURE, 512, 512, button -> this.pageBack());
        prevButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"spectatorMenu.previous_page")));
        this.prevButton = (Button)this.m_142416_((GuiEventListener)prevButton);
        ImageButton nextButton = new ImageButton(this.leftPos + 270, this.topPos + 156, 13, 15, 308, 0, 15, TEXTURE, 512, 512, button -> this.pageForward());
        nextButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"spectatorMenu.next_page")));
        this.nextButton = (Button)this.m_142416_((GuiEventListener)nextButton);
        this.enterSignModeButton = new ImageButton(this.leftPos - 24, this.topPos + 18, 22, 22, 321, 0, 22, TEXTURE, 512, 512, b -> this.enterSignMode(), (Component)Component.m_237115_((String)"book.signButton"));
        this.enterSignModeButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"book.signButton")));
        this.m_142416_((GuiEventListener)this.enterSignModeButton);
        if (this.isFormattingAllowed()) {
            this.insertSectionSignButton = new ImageButton(this.f_96543_ - 22, 2, 22, 22, 343, 0, 22, TEXTURE, 512, 512, b -> this.insertSectionSign(), (Component)Component.m_237115_((String)"gui.scholar.insert_section_sign"));
            MutableComponent tooltip = Component.m_237115_((String)"gui.scholar.insert_section_sign").m_7220_((Component)Component.m_237113_((String)" [").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)Component.m_237113_((String)"CTRL+F").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)"]").m_130940_(ChatFormatting.DARK_GRAY)).m_130946_("\n\n").m_7220_((Component)Component.m_237115_((String)"gui.scholar.insert_section_sign.help1").m_130940_(ChatFormatting.GRAY)).m_130946_("\n\n").m_7220_((Component)Component.m_237110_((String)"gui.scholar.insert_section_sign.help2", (Object[])new Object[]{Component.m_237113_((String)"F1").m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY)));
            this.insertSectionSignButton.m_257544_(Tooltip.m_257550_((Component)tooltip));
            this.m_169394_((Renderable)this.insertSectionSignButton);
        }
        this.updateButtonVisibility();
        this.createMenuControls();
    }

    protected void createMenuControls() {
        if (((Boolean)Config.Client.WRITABLE_SHOW_DONE_BUTTON.get()).booleanValue()) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - 60, this.topPos + 180 + 12, 120, 20).m_253136_());
        }
    }

    protected void enterSignMode() {
        Objects.requireNonNull(this.f_96541_).m_91152_((Screen)new BookSigningScreen(this, this.bookColor));
    }

    private void updateButtonVisibility() {
        this.prevButton.f_93624_ = this.currentSpread > 0;
        this.nextButton.f_93624_ = this.currentSpread < 49;
    }

    private void clearDisplayCacheAfterPageChange() {
        this.leftPageTextBox.setCursorToEnd();
        this.rightPageTextBox.setCursorToEnd();
    }

    protected void pageBack() {
        if (this.currentSpread > 0) {
            --this.currentSpread;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)0.8f));
            this.updateButtonVisibility();
            this.clearDisplayCacheAfterPageChange();
        }
    }

    protected void pageForward() {
        if (this.currentSpread < 49) {
            ++this.currentSpread;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
            while (this.pages.size() < (this.currentSpread + 1) * 2) {
                this.appendPageToBook();
            }
            this.updateButtonVisibility();
            this.clearDisplayCacheAfterPageChange();
        }
    }

    private void appendPageToBook() {
        if (this.pages.size() < 100) {
            this.pages.add("");
            this.isModified = true;
        }
    }

    protected String getPageText(Side side) {
        int pageIndex = side.getPageIndexFromSpread(this.currentSpread);
        return pageIndex >= 0 && pageIndex < this.pages.size() ? this.pages.get(pageIndex) : "";
    }

    protected void setPageText(Side side, String text) {
        int pageIndex = side.getPageIndexFromSpread(this.currentSpread);
        if (pageIndex >= 0 && pageIndex < this.pages.size()) {
            this.pages.set(pageIndex, text);
            this.isModified = true;
        }
    }

    public void saveChanges(boolean sign, @Nullable String title) {
        if (this.isModified || sign) {
            if (!sign) {
                title = null;
            }
            this.eraseEmptyTrailingPages();
            this.updateLocalCopy(sign, title);
            int slotId = this.hand == InteractionHand.MAIN_HAND ? this.owner.m_150109_().f_35977_ : 40;
            Objects.requireNonNull(Minecraft.m_91087_().m_91403_()).m_104955_((Packet)new ServerboundEditBookPacket(slotId, this.pages, Optional.ofNullable(title)));
        }
    }

    protected void eraseEmptyTrailingPages() {
        ListIterator<String> iterator = this.pages.listIterator(this.pages.size());
        while (iterator.hasPrevious() && iterator.previous().isEmpty()) {
            iterator.remove();
        }
    }

    protected void updateLocalCopy(boolean sign, @Nullable String title) {
        ListTag listTag = new ListTag();
        this.pages.stream().map(StringTag::m_129297_).forEach(arg_0 -> listTag.add(arg_0));
        if (!this.pages.isEmpty()) {
            this.bookStack.m_41700_("pages", (Tag)listTag);
        }
        if (sign) {
            Preconditions.checkState((!StringUtil.isNullOrEmpty((String)title) ? 1 : 0) != 0, (Object)"Title cannot be null or empty when signing a book.");
            this.bookStack.m_41700_("author", (Tag)StringTag.m_129297_((String)this.owner.m_36316_().getName()));
            this.bookStack.m_41700_("title", (Tag)StringTag.m_129297_((String)title));
        }
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        if (this.insertSectionSignButton != null) {
            this.insertSectionSignButton.f_93623_ = this.m_7222_() instanceof TextBox;
        }
        RenderUtil.withColorMultiplied(this.bookColor, () -> {
            guiGraphics.m_280411_(TEXTURE, (this.f_96543_ - 295) / 2, (this.f_96544_ - 180) / 2, 295, 180, 0.0f, 0.0f, 295, 180, 512, 512);
            guiGraphics.m_280163_(TEXTURE, this.leftPos - 29, this.topPos + 14, 0.0f, 360.0f, 29, 28, 512, 512);
        });
        guiGraphics.m_280411_(TEXTURE, (this.f_96543_ - 295) / 2, (this.f_96544_ - 180) / 2, 295, 180, 0.0f, 180.0f, 295, 180, 512, 512);
        this.drawPageNumbers(guiGraphics, this.currentSpread);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    protected void drawPageNumbers(GuiGraphics guiGraphics, int currentSpreadIndex) {
        String leftPageNumber = Integer.toString(currentSpreadIndex * 2 + 1);
        guiGraphics.m_280056_(this.f_96547_, leftPageNumber, this.leftPos + 69 + (8 - this.f_96547_.m_92895_(leftPageNumber) / 2), this.topPos + 157, this.secondaryFontColor, false);
        String rightPageNumber = Integer.toString(currentSpreadIndex * 2 + 2);
        guiGraphics.m_280056_(this.f_96547_, rightPageNumber, this.leftPos + 208 + (8 - this.f_96547_.m_92895_(rightPageNumber) / 2), this.topPos + 157, this.secondaryFontColor, false);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.m_7222_() instanceof TextBox && Screen.m_96637_() && keyCode == 70) {
            this.insertSectionSign();
            return true;
        }
        if (this.insertSectionSignButton != null && this.insertSectionSignButton.m_274382_() && keyCode == 290) {
            this.openFormattingWikiPage();
            return true;
        }
        if (!(this.m_7222_() instanceof TextBox)) {
            if (Minecraft.m_91087_().f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
                this.m_7379_();
                return true;
            }
            if (keyCode == 263 || keyCode == 266 || Minecraft.m_91087_().f_91066_.f_92086_.m_90832_(keyCode, scanCode)) {
                this.pageBack();
                return true;
            }
            if (keyCode == 262 || keyCode == 267 || Minecraft.m_91087_().f_91066_.f_92088_.m_90832_(keyCode, scanCode)) {
                this.pageForward();
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected void insertSectionSign() {
        GuiEventListener guiEventListener;
        if (this.isFormattingAllowed() && (guiEventListener = this.m_7222_()) instanceof TextBox) {
            TextBox textBox = (TextBox)guiEventListener;
            textBox.textFieldHelper.m_95158_("\u00a7");
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)Scholar.SoundEvents.FORMATTING_CLICK.get(), (float)1.0f, (float)0.5f));
        }
    }

    protected boolean isFormattingAllowed() {
        return (Boolean)Config.Common.WRITABLE_SURVIVAL_FORMATTING.get() != false || Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_7500_();
    }

    protected void openFormattingWikiPage() {
        String page = "https://minecraft.wiki/Formatting_codes";
        try {
            URI uri = new URI(page);
            String protocol = uri.getScheme();
            if (protocol == null) {
                throw new URISyntaxException(page, "Missing protocol");
            }
            if (!Sets.newHashSet((Object[])new String[]{"http", "https"}).contains(protocol.toLowerCase(Locale.ROOT))) {
                throw new URISyntaxException(page, "Unsupported protocol: " + protocol.toLowerCase(Locale.ROOT));
            }
            Minecraft.m_91087_().m_91152_((Screen)new ConfirmLinkScreen(shouldOpen -> {
                if (shouldOpen) {
                    Util.m_137581_().m_137648_(uri);
                }
                Minecraft.m_91087_().m_91152_((Screen)this);
            }, page, true));
        }
        catch (URISyntaxException uRISyntaxException) {
            LogUtils.getLogger().error("Can't open url {} - {}", (Object)page, (Object)uRISyntaxException);
        }
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        GuiEventListener guiEventListener;
        boolean handled = super.m_5534_(pCodePoint, pModifiers);
        if (handled && (guiEventListener = this.m_7222_()) instanceof TextBox) {
            TextBox textBox = (TextBox)guiEventListener;
            SpreadBookEditScreen.onTextBoxCharTyped(textBox);
        }
        return handled;
    }

    private static void onTextBoxCharTyped(TextBox textBox) {
        int cursorPos = textBox.textFieldHelper.m_95194_();
        String text = textBox.getText();
        if (cursorPos < 2 || cursorPos > text.length()) {
            return;
        }
        int sectionSymbolIndex = cursorPos - 2;
        int formattingCharIndex = sectionSymbolIndex + 1;
        String enteredFormattingCode = text.substring(sectionSymbolIndex, formattingCharIndex + 1);
        for (Formatting formatting : Formatting.values()) {
            if (!formatting.getCode().equals(enteredFormattingCode)) continue;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)Scholar.SoundEvents.FORMATTING_CLICK.get(), (float)1.0f, (float)0.5f));
            return;
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.insertSectionSignButton != null && this.insertSectionSignButton.m_274382_()) {
            this.insertSectionSign();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_7379_() {
        this.saveChanges(false, null);
        super.m_7379_();
    }

    public static enum Side {
        LEFT,
        RIGHT;


        public int getSideIndex() {
            return this.ordinal();
        }

        public int getPageIndexFromSpread(int spreadIndex) {
            return spreadIndex * 2 + this.getSideIndex();
        }
    }
}

