/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.screen;

import io.github.mortuusars.scholar.Scholar;
import io.github.mortuusars.scholar.screen.SpreadBookEditScreen;
import io.github.mortuusars.scholar.screen.textbox.HorizontalAlignment;
import io.github.mortuusars.scholar.screen.textbox.TextBox;
import io.github.mortuusars.scholar.util.RenderUtil;
import io.github.mortuusars.scholar.visual.Formatting;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class BookSigningScreen
extends Screen {
    public static final int SELECTION_COLOR = -7829249;
    public static final int SELECTION_UNFOCUSED_COLOR = -4473857;
    public static final ResourceLocation TEXTURE = Scholar.resource("textures/gui/book_signing.png");
    @NotNull
    protected final Minecraft minecraft;
    @NotNull
    protected final Player player;
    protected final SpreadBookEditScreen parentScreen;
    protected final int bookColor;
    protected int imageWidth;
    protected int imageHeight;
    protected int leftPos;
    protected int topPos;
    protected int textureWidth;
    protected int textureHeight;
    protected TextBox titleTextBox;
    protected ImageButton signButton;
    protected ImageButton cancelSigningButton;
    protected String titleText = "";

    public BookSigningScreen(SpreadBookEditScreen parentScreen, int bookColor) {
        super((Component)Component.m_237119_());
        this.parentScreen = parentScreen;
        this.bookColor = bookColor;
        this.minecraft = Minecraft.m_91087_();
        this.player = (Player)Objects.requireNonNull(this.minecraft.f_91074_);
        this.textureWidth = 256;
        this.textureHeight = 256;
    }

    protected void m_7856_() {
        this.imageWidth = 149;
        this.imageHeight = 180;
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.titleTextBox = new TextBox(this.f_96547_, this.leftPos + 21, this.topPos + 71, 108, 9, () -> this.titleText, text -> {
            this.titleText = text;
        }).setFontColor(-8036298, -8036298).setSelectionColor(-7829249, -4473857);
        this.titleTextBox.textValidator = text -> text != null && this.f_96547_.m_92920_(text, 108) <= 9 && !text.contains("\n");
        this.titleTextBox.horizontalAlignment = HorizontalAlignment.CENTER;
        this.m_142416_((GuiEventListener)this.titleTextBox);
        this.signButton = new ImageButton(this.leftPos + 46, this.topPos + 108, 22, 22, 149, 0, 22, TEXTURE, this.textureWidth, this.textureHeight, b -> this.signAlbum(), (Component)Component.m_237115_((String)"book.finalizeButton"));
        MutableComponent component = Component.m_237115_((String)"book.finalizeButton").m_130946_("\n").m_7220_((Component)Component.m_237115_((String)"book.finalizeWarning").m_130940_(ChatFormatting.GRAY));
        this.signButton.m_257544_(Tooltip.m_257550_((Component)component));
        this.m_142416_((GuiEventListener)this.signButton);
        this.cancelSigningButton = new ImageButton(this.leftPos + 83, this.topPos + 108, 22, 22, 171, 0, 22, TEXTURE, this.textureWidth, this.textureHeight, b -> this.cancelSigning(), CommonComponents.f_130656_);
        this.cancelSigningButton.m_257544_(Tooltip.m_257550_((Component)CommonComponents.f_130656_));
        this.m_142416_((GuiEventListener)this.cancelSigningButton);
        this.m_264313_((GuiEventListener)this.titleTextBox);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_86600_() {
        this.titleTextBox.tick();
    }

    private void updateButtons() {
        this.signButton.f_93623_ = this.canSign();
    }

    protected boolean canSign() {
        return !this.titleText.isBlank();
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.updateButtons();
        this.m_280273_(guiGraphics);
        RenderUtil.withColorMultiplied(this.bookColor, () -> guiGraphics.m_280398_(TEXTURE, this.leftPos, this.topPos, 0, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.textureWidth, this.textureHeight));
        guiGraphics.m_280398_(TEXTURE, this.leftPos, this.topPos + 31, 0, 0.0f, 180.0f, this.imageWidth, 76, this.textureWidth, this.textureHeight);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderLabels(guiGraphics);
    }

    private void renderLabels(GuiGraphics guiGraphics) {
        MutableComponent component = Component.m_237115_((String)"book.editTitle");
        guiGraphics.m_280614_(this.f_96547_, (Component)component, this.leftPos + 74 - this.f_96547_.m_92852_((FormattedText)component) / 2, this.topPos + 51, 16116688, false);
        component = Component.m_237110_((String)"book.byAuthor", (Object[])new Object[]{this.player.m_7755_()});
        guiGraphics.m_280614_(this.f_96547_, (Component)component, this.leftPos + 74 - this.f_96547_.m_92852_((FormattedText)component) / 2, this.topPos + 81, 13087894, false);
    }

    protected void signAlbum() {
        if (this.canSign()) {
            this.parentScreen.saveChanges(true, this.titleText.trim());
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)Scholar.SoundEvents.BOOK_SIGNED.get(), (float)1.0f, (float)0.8f));
            this.m_7379_();
        }
    }

    protected void cancelSigning() {
        this.minecraft.m_91152_((Screen)this.parentScreen);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        GuiEventListener guiEventListener;
        if (keyCode == 258) {
            return super.m_7933_(keyCode, scanCode, modifiers);
        }
        if (keyCode == 256) {
            this.cancelSigning();
            return true;
        }
        if (this.parentScreen.isFormattingAllowed() && (guiEventListener = this.m_7222_()) instanceof TextBox) {
            TextBox textBox = (TextBox)guiEventListener;
            if (Screen.m_96637_() && keyCode == 70) {
                textBox.textFieldHelper.m_95158_("\u00a7");
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)Scholar.SoundEvents.FORMATTING_CLICK.get(), (float)1.0f, (float)0.5f));
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        GuiEventListener guiEventListener;
        boolean handled = super.m_5534_(pCodePoint, pModifiers);
        if (handled && (guiEventListener = this.m_7222_()) instanceof TextBox) {
            TextBox textBox = (TextBox)guiEventListener;
            BookSigningScreen.onTextBoxCharTyped(textBox);
        }
        return handled;
    }

    private static void onTextBoxCharTyped(TextBox textBox) {
        int cursorPos = textBox.textFieldHelper.m_95194_();
        String text = textBox.getText();
        if (cursorPos < 2 || cursorPos > text.length()) {
            return;
        }
        int sectionSymbolIndex = cursorPos - 2;
        int formattingCharIndex = sectionSymbolIndex + 1;
        String enteredFormattingCode = text.substring(sectionSymbolIndex, formattingCharIndex + 1);
        for (Formatting formatting : Formatting.values()) {
            if (!formatting.getCode().equals(enteredFormattingCode)) continue;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)Scholar.SoundEvents.FORMATTING_CLICK.get(), (float)1.0f, (float)0.5f));
            return;
        }
    }
}

