/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.mixin;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.scholar.BookHandlerServer;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.util.TriConsumer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class ServerGamePacketListenerImplMixin {
    @Shadow
    public ServerPlayer f_9743_;

    @Shadow
    protected abstract void m_143634_(List<FilteredText> var1, UnaryOperator<String> var2, ItemStack var3);

    @Inject(method={"signBook"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSignBook(FilteredText title, List<FilteredText> pages, int slot, CallbackInfo ci) {
        try {
            ItemStack itemStack = this.f_9743_.m_150109_().m_8020_(slot);
            if (BookHandlerServer.handleBookSigning(this.f_9743_, itemStack, title, pages, slot, (TriConsumer<List<FilteredText>, UnaryOperator<String>, ItemStack>)((TriConsumer)this::m_143634_))) {
                ci.cancel();
            }
        }
        catch (Exception e) {
            LogUtils.getLogger().error("Signing Book failed: " + e);
        }
    }

    @Inject(method={"updateBookContents"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUpdateBookContents(List<FilteredText> pages, int slot, CallbackInfo ci) {
        try {
            ItemStack itemStack = this.f_9743_.m_150109_().m_8020_(slot);
            if (BookHandlerServer.handleBookContentsUpdating(this.f_9743_, itemStack, pages, slot, (TriConsumer<List<FilteredText>, UnaryOperator<String>, ItemStack>)((TriConsumer)this::m_143634_))) {
                ci.cancel();
            }
        }
        catch (Exception e) {
            LogUtils.getLogger().error("Updating Book Contents failed: " + e);
        }
    }
}

