/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.mixin;

import io.github.mortuusars.scholar.Config;
import io.github.mortuusars.scholar.PlatformHelper;
import io.github.mortuusars.scholar.menu.LecternSpreadMenu;
import io.github.mortuusars.scholar.mixin.LecternBlockEntityAccessor;
import io.github.mortuusars.scholar.visual.BookColors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LecternBlock.class})
public abstract class LecternBlockMixin {
    @Inject(method={"openScreen"}, at={@At(value="HEAD")}, cancellable=true)
    private void openScreen(Level level, BlockPos pos, Player player, CallbackInfo ci) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof LecternBlockEntity) {
            LecternBlockEntity lecternBlockEntity = (LecternBlockEntity)blockEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!(player.m_36341_() && ((Boolean)Config.Common.LECTERN_SNEAK_OPENS_VANILLA_SCREEN.get()).booleanValue() || !this.scholar$shouldOpenScholarScreenForBook(lecternBlockEntity.m_59566_()))) {
                    this.scholar$openSpreadGUI(serverPlayer, lecternBlockEntity, lecternBlockEntity.m_59566_());
                    player.m_36220_(Stats.f_12974_);
                    ci.cancel();
                }
            }
        }
    }

    @Unique
    private boolean scholar$shouldOpenScholarScreenForBook(ItemStack bookStack) {
        return (Boolean)Config.Common.LECTERN_REPLACE_VANILLA_SCREEN.get() != false && (bookStack.m_41720_() instanceof WritableBookItem || bookStack.m_41720_() instanceof WrittenBookItem);
    }

    @Unique
    private void scholar$openSpreadGUI(ServerPlayer player, final LecternBlockEntity lecternBlockEntity, final ItemStack bookStack) {
        final int bookColor = BookColors.fromStack(bookStack);
        MenuProvider menuProvider = new MenuProvider(){

            @NotNull
            public Component m_5446_() {
                return bookStack.m_41786_();
            }

            @NotNull
            public AbstractContainerMenu m_7208_(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
                LecternBlockEntityAccessor accessor = (LecternBlockEntityAccessor)lecternBlockEntity;
                return new LecternSpreadMenu(containerId, accessor.getBookAccess(), accessor.getDataAccess(), bookColor);
            }
        };
        PlatformHelper.openMenu(player, menuProvider, buffer -> buffer.m_130055_(bookStack));
    }
}

